/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.pentaho.di.engine.model.Configurable;
import org.pentaho.di.engine.model.Hop;
import org.pentaho.di.engine.model.Transformation;

public class Operation
extends Configurable
implements org.pentaho.di.engine.api.model.Operation {
    private static final long serialVersionUID = -1975677580227607466L;
    private final String id;
    private final Transformation transformation;

    public Operation(String id, Transformation transformation) {
        this.id = id;
        this.transformation = transformation;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private Stream<org.pentaho.di.engine.api.model.Hop> getHopsWhere(Function<org.pentaho.di.engine.api.model.Hop, org.pentaho.di.engine.api.model.Operation> hopFn) {
        return this.transformation.getHops().stream().filter(hop -> this.equals(hopFn.apply((org.pentaho.di.engine.api.model.Hop)hop)));
    }

    @Override
    public List<org.pentaho.di.engine.api.model.Operation> getFrom() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.getHopsWhere(org.pentaho.di.engine.api.model.Hop::getTo).map(org.pentaho.di.engine.api.model.Hop::getFrom).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public List<org.pentaho.di.engine.api.model.Operation> getTo() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.getHopsWhere(org.pentaho.di.engine.api.model.Hop::getFrom).map(org.pentaho.di.engine.api.model.Hop::getTo).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public List<org.pentaho.di.engine.api.model.Hop> getHopsIn() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.getHopsWhere(org.pentaho.di.engine.api.model.Hop::getTo).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public List<org.pentaho.di.engine.api.model.Hop> getHopsOut() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.getHopsWhere(org.pentaho.di.engine.api.model.Hop::getFrom).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public String toString() {
        return "Operation{id='" + this.id + "'}";
    }

    public Hop createHopTo(org.pentaho.di.engine.api.model.Operation to) {
        return this.transformation.createHop(this, to);
    }

    public Hop createHopTo(org.pentaho.di.engine.api.model.Operation to, String type) {
        return this.transformation.createHop(this, to, type);
    }
}

