/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.pentaho;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.api.RunConfigurationProvider;
import org.pentaho.di.engine.configuration.impl.MetaStoreRunConfigurationFactory;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfiguration;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfigurationExecutor;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class DefaultRunConfigurationProvider
extends MetaStoreRunConfigurationFactory
implements RunConfigurationProvider {
    public static final String DEFAULT_CONFIG_NAME = "Pentaho local";
    private static String TYPE = "Pentaho";
    private List<String> supported = Arrays.asList("transformation", "job");
    private static DefaultRunConfiguration defaultRunConfiguration = new DefaultRunConfiguration();
    private DefaultRunConfigurationExecutor defaultRunConfigurationExecutor;

    public DefaultRunConfigurationProvider(MetastoreLocator metastoreLocator, DefaultRunConfigurationExecutor defaultRunConfigurationExecutor) {
        super(metastoreLocator);
        this.defaultRunConfigurationExecutor = defaultRunConfigurationExecutor;
    }

    public RunConfiguration getConfiguration() {
        return new DefaultRunConfiguration();
    }

    public String getType() {
        return TYPE;
    }

    protected MetaStoreFactory<DefaultRunConfiguration> getMetaStoreFactory() throws MetaStoreException {
        return this.getMetastoreFactory(DefaultRunConfiguration.class);
    }

    @Override
    public List<RunConfiguration> load() {
        ArrayList<RunConfiguration> runConfigurations = new ArrayList<RunConfiguration>();
        runConfigurations.add(defaultRunConfiguration);
        runConfigurations.addAll(super.load());
        return runConfigurations;
    }

    @Override
    public RunConfiguration load(String name) {
        if (Utils.isEmpty((CharSequence)name) || name.equals(DEFAULT_CONFIG_NAME)) {
            return defaultRunConfiguration;
        }
        return super.load(name);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(defaultRunConfiguration.getName());
        names.addAll(super.getNames());
        return names;
    }

    public boolean isSupported(String type) {
        return this.supported.contains(type);
    }

    public List<String> getNames(String type) {
        return this.isSupported(type) ? this.getNames() : Collections.emptyList();
    }

    public RunConfigurationExecutor getExecutor() {
        return this.defaultRunConfigurationExecutor;
    }

    static {
        defaultRunConfiguration.setName(DEFAULT_CONFIG_NAME);
        defaultRunConfiguration.setReadOnly(true);
        defaultRunConfiguration.setLocal(true);
    }
}

