/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.adaptive.daemon.validation.ApplicationPropertyValidate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Configuration
@ConfigurationProperties
@Component
@Validated
@ApplicationPropertyValidate
public class ApplicationProperties {
    private static final String SPARK_PROPERTIES_PRFX = "spark.";
    @Value(value="${info.build.version}")
    private String infoBuildVersion;
    @Autowired
    private Environment environment;
    @Value(value="${websocketURL}")
    private String websocketURL;
    @Value(value="${hadoopConfDir}")
    private String hadoopConfDir;
    @Value(value="${sparkHome}")
    private String sparkHome;
    @Value(value="${hadoopUser}")
    private String hadoopUser;
    @Value(value="${sparkApp}")
    private String sparkApp;
    @Value(value="${sparkAppClass}")
    private String sparkAppClass;
    @Value(value="${sparkMaster}")
    private String sparkMaster;
    @Value(value="${sparkDeployMode}")
    private String sparkDeployMode;
    @Value(value="${driverDebugPort:#{-1}}")
    private int driverDebugPort;
    @Value(value="${executorDebugPort:#{-1}}")
    private int executorDebugPort;
    @Value(value="${suspendDebug:#{false}}")
    private boolean suspendDebug;
    @Value(value="${sparkDriverExtraJavaOptions:}")
    private String sparkDriverExtraJavaOptions;
    @Value(value="${sparkExecutorExtraJavaOptions:}")
    private String sparkExecutorExtraJavaOptions;
    @Value(value="${sparkDriverMemory}")
    private String sparkDriverMemory;
    @Value(value="${sparkExecutorMemory}")
    private String sparkExecutorMemory;
    @Value(value="${sparkEventLogEnabled:#{false}}")
    private boolean sparkEventLogEnabled;
    @Value(value="${sparkEventLogDir:#{null}}")
    private String sparkEventLogDir;
    @Value(value="${assemblyZip}")
    private String assemblyZip;
    @Value(value="${keytabLocation}")
    private String keytab;
    @Value(value="${kerberosPrincipal}")
    private String kerberosPrincipal;
    @Value(value="${disableProxyUser:#{false}}")
    private boolean disableProxyUser;
    @Value(value="${driver.security.keytabLocation:#{null}}")
    private String driverSecurityKeytabLocation;
    @Value(value="${driver.security.principal:#{null}}")
    private String driverSecurityPrincipal;
    @Value(value="${overwriteConfig:#{true}}")
    private boolean overwriteConfig;
    @Value(value="${ael.ssl.enabled:#{false}}")
    private boolean sslEnabled;
    @Value(value="${ael.ssl.port:#{-1}}")
    private int sslServerPort;
    @Value(value="${ael.ssl.key-store:#{null}}")
    private String sslKeyStorePath;
    @Value(value="${ael.ssl.key-store-type:#{null}}")
    private String keyStoreType;
    @Value(value="${ael.ssl.key-store-password:#{null}}")
    private String keyStorePassword;
    @Value(value="${ael.ssl.key-password:#{null}}")
    private String keyPassword;
    @Value(value="${ael.unencrypted.port:#{-1}}")
    private int httpPort;
    @Value(value="${http.security.keytabLocation:#{null}}")
    private String httpSecurityKeytabLocation;
    @Value(value="${http.security.principal:#{null}}")
    private String httpSecurityPrincipal;
    @Value(value="${http.security.debug:#{false}}")
    private boolean httpSecurityDebug;
    @Value(value="${driver.session.timeout:30s}")
    private String driverSessionTimeout;
    @Value(value="${driver.session.maxLiving.timeout:1h}")
    private String driverSessionMaxLiving;
    @Value(value="${driver.session.maxIdle.timeout:15m}")
    private String driverSessionMaxIdle;
    @Value(value="${driver.session.maxRequestThreads:#{0}}")
    private int maxRequestThreads;
    @Value(value="${driver.websocket.maxMessageBufferSize:#{2097152}}")
    private int driverWebsocketMaxMessageBufferSize;
    @Value(value="${daemon.websocket.maxMessageBufferSize:#{2097152}}")
    private int daemonWebsocketMaxMessageBufferSize;
    @Value(value="${ael.ssl.enc-properties:#{\"config/enc-ssl.properties\"}}")
    private String encFileName;
    private final Map<String, String> sparkNamespaceMap = new ConcurrentHashMap<String, String>();

    public int getHttpPort() {
        return this.httpPort;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getSslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getEncFileName() {
        return this.encFileName;
    }

    public String getInfoBuildVersion() {
        return this.infoBuildVersion;
    }

    public int getSslServerPort() {
        return this.sslServerPort;
    }

    public String getWebsocketURL() {
        return this.websocketURL;
    }

    public String getHadoopConfDir() {
        return this.hadoopConfDir;
    }

    public String getSparkHome() {
        return this.sparkHome;
    }

    public String getHadoopUser() {
        return this.hadoopUser;
    }

    public String getSparkApp() {
        return this.sparkApp;
    }

    public String getSparkAppClass() {
        return this.sparkAppClass;
    }

    public String getSparkMaster() {
        return this.sparkMaster;
    }

    public String getSparkDeployMode() {
        return this.sparkDeployMode;
    }

    public int getDriverDebugPort() {
        return this.driverDebugPort;
    }

    public int getExecutorDebugPort() {
        return this.executorDebugPort;
    }

    public boolean getSuspendDebug() {
        return this.suspendDebug;
    }

    public String getSparkDriverExtraJavaOptions() {
        return this.sparkDriverExtraJavaOptions;
    }

    public String getSparkExecutorExtraJavaOptions() {
        return this.sparkExecutorExtraJavaOptions;
    }

    public String getSparkDriverMemory() {
        return this.sparkDriverMemory;
    }

    public String getSparkExecutorMemory() {
        return this.sparkExecutorMemory;
    }

    public String getAssemblyZip() {
        return this.assemblyZip;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public boolean isDisableProxyUser() {
        return this.disableProxyUser;
    }

    public String getDriverSecurityKeytabLocation() {
        return this.driverSecurityKeytabLocation;
    }

    public String getDriverSecurityPrincipal() {
        return this.driverSecurityPrincipal;
    }

    public boolean isOverwriteConfig() {
        return this.overwriteConfig;
    }

    public String getHttpSecurityKeytabLocation() {
        return this.httpSecurityKeytabLocation;
    }

    public String getHttpSecurityPrincipal() {
        return this.httpSecurityPrincipal;
    }

    public boolean isHttpSecurityDebug() {
        return this.httpSecurityDebug;
    }

    public String getDriverSessionTimeout() {
        return this.driverSessionTimeout;
    }

    public String getDriverSessionMaxLiving() {
        return this.driverSessionMaxLiving;
    }

    public String getDriverSessionMaxIdle() {
        return this.driverSessionMaxIdle;
    }

    public int getMaxRequestThreads() {
        return this.maxRequestThreads;
    }

    public boolean isSparkEventLogEnabled() {
        return this.sparkEventLogEnabled;
    }

    public void setSparkEventLogEnabled(boolean sparkEventLogEnabled) {
        this.sparkEventLogEnabled = sparkEventLogEnabled;
    }

    public String getSparkEventLogDir() {
        return this.sparkEventLogDir;
    }

    public void setSparkEventLogDir(String sparkEventLogDir) {
        this.sparkEventLogDir = sparkEventLogDir;
    }

    public int getDriverWebsocketMaxMessageBufferSize() {
        return this.driverWebsocketMaxMessageBufferSize;
    }

    public void setDriverWebsocketMaxMessageBufferSize(int driverWebsocketMaxMessageBufferSize) {
        this.driverWebsocketMaxMessageBufferSize = driverWebsocketMaxMessageBufferSize;
    }

    public int getDaemonWebsocketMaxMessageBufferSize() {
        return this.daemonWebsocketMaxMessageBufferSize;
    }

    public void setDaemonWebsocketMaxMessageBufferSize(int daemonWebsocketMaxMessageBufferSize) {
        this.daemonWebsocketMaxMessageBufferSize = daemonWebsocketMaxMessageBufferSize;
    }

    public Map<String, String> getSpark() {
        return this.sparkNamespaceMap;
    }

    public Map<String, String> userDefinedSparkProperties() {
        ConcurrentHashMap<String, String> sparkProps = new ConcurrentHashMap<String, String>();
        Map<String, String> sparkPropNamespaceMap = this.getSpark();
        if (sparkPropNamespaceMap == null || sparkPropNamespaceMap.isEmpty()) {
            return sparkProps;
        }
        for (Map.Entry<String, String> propEntry : sparkPropNamespaceMap.entrySet()) {
            sparkProps.put(SPARK_PROPERTIES_PRFX + propEntry.getKey(), propEntry.getValue());
        }
        return sparkProps;
    }
}

