/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.session;

import java.io.Serializable;
import javax.websocket.Session;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.session.SessionHelper;
import org.pentaho.di.engine.api.remote.ExecutionRequest;

public class RequestData
implements Serializable {
    private String requestID;
    private String userID;
    private Session clientSession;
    private Session driverSession;
    private ExecutionRequest executionRequest;
    private boolean reuseSparkContext;
    private int driverCores = 1;
    private String driverMemory;
    private String executorMemory;

    public RequestData(ApplicationProperties config, String requestId, Session clientSession, ExecutionRequest executionRequest) {
        this.requestID = requestId;
        this.userID = SessionHelper.getUserId(config, executionRequest.getActingPrincipal());
        this.clientSession = clientSession;
        this.executionRequest = executionRequest;
        this.reuseSparkContext = executionRequest.isToReuseSparkContext();
        this.driverSession = null;
        this.executorMemory = config.getSparkExecutorMemory();
        this.driverMemory = config.getSparkDriverMemory();
    }

    public String getRequestID() {
        return this.requestID;
    }

    public String getUserID() {
        return this.userID;
    }

    public Session getClientSession() {
        return this.clientSession;
    }

    public Session getDriverSession() {
        return this.driverSession;
    }

    public boolean isReuseSparkContext() {
        return this.reuseSparkContext;
    }

    public void setDriverSession(Session driverSession) {
        this.driverSession = driverSession;
    }

    public ExecutionRequest getExecutionRequest() {
        return this.executionRequest;
    }

    public int getCores() {
        return this.driverCores;
    }

    public String getDriverMemory() {
        return this.driverMemory;
    }

    public String getExecutorMemory() {
        return this.executorMemory;
    }
}

