/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.spark.launcher.SparkAppHandle;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.config.SpringBootConfigurator;
import org.pentaho.adaptive.daemon.session.RequestData;
import org.pentaho.adaptive.daemon.session.SessionHelper;
import org.pentaho.adaptive.daemon.session.SessionTracker;
import org.pentaho.adaptive.daemon.spark.SparkRunner;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.pentaho.di.engine.api.events.ErrorEvent;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.remote.DriverSessionClosed;
import org.pentaho.di.engine.api.remote.ExecutionFetchRequest;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.MessageDecoder;
import org.pentaho.di.engine.api.remote.MessageEncoder;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ServerEndpoint(value="/execution", decoders={MessageDecoder.class}, encoders={MessageEncoder.class}, configurator=SpringBootConfigurator.class)
public class RequestServerEndpoint {
    private Logger LOG = LoggerFactory.getLogger(RequestServerEndpoint.class);
    private static final MessageLoader MESSAGE_LOADER = new MessageLoader(RequestServerEndpoint.class);
    private static final String REQUEST_UUID = "REQUEST_UUID";
    private static final String USER_ID = "USER_IDENTIFICATION";
    private static final String CLIENT_LOST_FIRST_MSG_LOGGED = "CLIENT_LOST_FIRST_MSG_LOGGED";
    private static final String STOP_ALREADY_SENT_TO_CLIENT = "STOP_ALREADY_SENT_TO_CLIENT";
    private static final String SPARK_HANDLER = "SPARK_APP_ HANDLE";
    private static final String DRIVER_SESSION_CONNECTED_SIGNAL = "DRIVER_SESSION_CONNECTED_SIGNAL";
    private static final String CON_RST_PEER = "RequestServerEndpoint.ConnectionResetByPeer";
    private static final String SPARK_SESSION_KILLED_MSG = "RequestServerEndpoint.SparkSessionKilled";
    private static final String DRIVER_SESSION_TIMEOUT = "RequestServerEndpoint.DriverSessionExpired";
    private static final String EXECUTION_ALREADY_FINISHED = "RequestServerEndpoint.ExecutionAlreadyFinished";
    private static final String UNABLE_T_SEND_STOP = "RequestServerEndpoint.UnableToSendStopMsgToDriver";
    private static final String DRV_SESS_TOUT_ERROR = "RequestServerEndpoint.DriverSessionTimeoutError";
    private static final String DRV_STB_CON_ET = "RequestServerEndpoint.DriverEstablishedConnection";
    private static final String DRV_STB_TOUT_EXP = "RequestServerEndpoint.DriverSessionTimeoutExpired";
    private static final String ST_DRV_SESS_MNT = "RequestServerEndpoint.StartingDriverSessionMonitor";
    private static final String UNB_STP_MSG_AFT_SESS_KLD = "RequestServerEndpoint.UnableToSendStopMessageToClientSessionKilled";
    private static final String UNB_STP_MSG_AFT_ERROR_RUN_SPARK = "RequestServerEndpoint.UnableToSendStopMessageToClientErrorRunSpark";
    private static final String UNX_ERR_RUN_SPARK_JOB = "RequestServerEndpoint.UnexpectedErrorRunningSpark";
    private static final String UNX_ERR_PRC_DRV_REQ = "RequestServerEndpoint.UnexpectedErrorProcessingDriverReq";
    private static final String UNX_ERR_PRC_GNR_MSG = "RequestServerEndpoint.UnexpectedErrorProcessingEventMsg";
    private static final String UNX_ERR_PRC_STP_MSG = "RequestServerEndpoint.UnexpectedErrorProcessingStopMsg";
    private static final String ERROR_RUN_SPARK = "RequestServerEndpoint.ErrorRunningSpark";
    private static final String RCV_REQ_MSG = "RequestServerEndpoint.ReceivedRequestMsg";
    private static final String RCV_DRV_SESS_CLSD = "RequestServerEndpoint.ReceivedDriverSessionClosedMessage";
    private static final String RCV_STP_MSG_CLT = "RequestServerEndpoint.ReceivedStopFromClient";
    private static final String RCV_STP_MSG_DRV = "RequestServerEndpoint.ReceivedStopFromDriver";
    private static final String UNB_FWD_STP_MSG = "RequestServerEndpoint.UnableToForwardStopMessage";
    private static final String CLT_SESS_CLSD_NO_FWD_STP_MSG = "RequestServerEndpoint.ClientSessionAlreadyCloseStopWasntSentToClient";
    private static final String FND_TRANSF = "RequestServerEndpoint.FoundTransformation";
    private static final String RLS_DRV_SESS_MNT = "RequestServerEndpoint.ReleasingDriverSessionMonitor";
    private static final String RCV_DRV_FTCH_MSG = "RequestServerEndpoint.ReceivedDriverFetchMessage";
    private static final String RQST_MSG_NOT_FOUND = "RequestServerEndpoint.RequestMessageNotFound";
    private static final String CLT_SESSION_NOT_FOUND = "RequestServerEndpoint.ClientSessionNotFound";
    private static final String CLT_SESS_LST_EVENT_LST = "RequestServerEndpoint.ClientSessionWasLostEventWasntSent";
    private static final String CLT_SESS_LST_ALL_EVENT_LST = "RequestServerEndpoint.ClientSessionLostAllEventsNotSent";
    private static final String REQ_ID = "RequestServerEndpoint.requestID";
    private static final String HDL_PDI_EVENT = "RequestServerEndpoint.handlePDIEvent";
    private static final String WBSCK_EXCPT = "RequestServerEndpoint.WebsocketException";
    private static final String LST_CLT_CON = "RequestServerEndpoint.LostConnectionWithClient";
    private static final String SESS_CLSD_ABRUPTLY = "RequestServerEndpoint.SessionClosedAbruptly";
    private static final String ERROR_CLS_SESS = "RequestServerEndpoint.ErrorClosingSession";
    private static final String SESS_CLSD_REASON = "RequestServerEndpoint.SessionClosedReason";
    private static final String WAIT_DRIVER_2_SEND_STP_MSG = "RequestServerEndpoint.SessionWaitingForDriverInitToSendStopMessage";
    private static final String FINISHED_WAIT_DRIVER_2_SEND_STP_MSG = "RequestServerEndpoint.SessionFinishedWaitingFromDriverSendingStop";
    private static final String CONNECTED_MSG = "RequestServerEndpoint.Connected";
    private static final String KILLING_SPARK_DRIVER = "RequestServerEndpoint.KillingSparkDriver";
    private static final String BROKEN_PIPE = "Broken pipe";
    @Autowired
    private SparkRunner sparkRunner;
    @Autowired
    private ApplicationProperties config;
    @Autowired
    private SessionTracker sessionTracker;

    @OnOpen
    public void onOpen(Session session) {
        this.LOG.info(MESSAGE_LOADER.get(CONNECTED_MSG, session.getId()));
        session.setMaxTextMessageBufferSize(this.config.getDaemonWebsocketMaxMessageBufferSize());
        session.setMaxBinaryMessageBufferSize(this.config.getDaemonWebsocketMaxMessageBufferSize());
        RequestServerEndpoint.initParameters(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        Session session2 = session;
        synchronized (session2) {
            this.LOG.info(MESSAGE_LOADER.get(SESS_CLSD_REASON, session.getId(), closeReason));
            String requestUUID = this.getRequestUUID(session);
            String userID = this.getUserID(session);
            if (userID != null) {
                this.closeAllClientSessionsFromDriver(session);
                this.sessionTracker.removeDriverSession(userID, session.getId());
            } else if (requestUUID != null) {
                this.sessionTracker.removeRequest(this.getRequestUUID(session));
            }
        }
    }

    @OnMessage
    public void onMessage(Message message, Session session) {
        if (message instanceof MetricsEvent || message instanceof LogEvent || message instanceof StatusEvent || message instanceof ErrorEvent) {
            this.handlePDIEvent((PDIEvent)message, session);
        } else if (message instanceof ExecutionRequest) {
            this.handleRequestMessage((ExecutionRequest)message, session);
        } else if (message instanceof ExecutionFetchRequest) {
            this.handleSparkRequestMessage((ExecutionFetchRequest)message, session);
        } else if (message instanceof StopMessage) {
            this.handleStopMessage((StopMessage)message, session);
        } else if (message instanceof DriverSessionClosed) {
            this.handleDriverSessionClosed((DriverSessionClosed)message, session);
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable.getCause() != null && throwable.getCause() instanceof IOException && throwable.getCause().getMessage() != null && throwable.getCause().getMessage().indexOf(BROKEN_PIPE) >= 0 && session != null && !session.isOpen()) {
            this.LOG.info(MESSAGE_LOADER.get(ERROR_CLS_SESS, throwable.getCause().getMessage(), session.getId()));
        } else if (throwable instanceof EOFException && session.isOpen()) {
            this.LOG.info(MESSAGE_LOADER.get(SESS_CLSD_ABRUPTLY, session.getId()));
            this.closeAllClientSessionsFromDriver(session);
        } else if (throwable instanceof IOException && MESSAGE_LOADER.get(CON_RST_PEER).equals(throwable.getMessage())) {
            this.LOG.error(MESSAGE_LOADER.get(LST_CLT_CON, throwable.getMessage()));
        } else {
            this.LOG.error(MESSAGE_LOADER.get(WBSCK_EXCPT), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePDIEvent(PDIEvent message, Session session) {
        block12: {
            Session clientSession = null;
            try {
                String requestId = ((RemoteSource)message.getSource()).getRequestUUID();
                this.LOG.debug(MESSAGE_LOADER.get(HDL_PDI_EVENT, message, session));
                this.LOG.debug(MESSAGE_LOADER.get(REQ_ID, requestId));
                clientSession = this.sessionTracker.fetchClientSessionByRequestId(requestId);
                if (clientSession != null && clientSession.isOpen()) {
                    Session session2 = clientSession;
                    synchronized (session2) {
                        if (clientSession.isOpen()) {
                            clientSession.getBasicRemote().sendObject((Object)message);
                        } else if (!RequestServerEndpoint.getAndSet(session, CLIENT_LOST_FIRST_MSG_LOGGED, true)) {
                            this.LOG.info(MESSAGE_LOADER.get(CLT_SESS_LST_ALL_EVENT_LST));
                        } else {
                            this.LOG.debug(MESSAGE_LOADER.get(CLT_SESS_LST_EVENT_LST, message));
                        }
                        break block12;
                    }
                }
                if (!RequestServerEndpoint.getAndSet(session, CLIENT_LOST_FIRST_MSG_LOGGED, true)) {
                    this.LOG.info(MESSAGE_LOADER.get(CLT_SESS_LST_ALL_EVENT_LST));
                } else {
                    this.LOG.debug(MESSAGE_LOADER.get(CLT_SESS_LST_EVENT_LST, message));
                }
            }
            catch (Exception e) {
                this.LOG.warn(MESSAGE_LOADER.get(UNX_ERR_PRC_GNR_MSG, message, session));
                this.onError(clientSession, e);
            }
        }
    }

    private void handleSparkRequestMessage(ExecutionFetchRequest message, Session driverSession) {
        try {
            this.LOG.info(MESSAGE_LOADER.get(RCV_DRV_FTCH_MSG, driverSession.getId()));
            ExecutionRequest requestMessage = this.sessionTracker.fetchRequestMessageByRequestId(message.getRequestId());
            if (requestMessage == null) {
                this.LOG.warn(MESSAGE_LOADER.get(RQST_MSG_NOT_FOUND, message.getRequestId()));
                return;
            }
            String user = SessionHelper.getUserId(this.config, requestMessage.getActingPrincipal());
            this.setUserID(user, driverSession);
            this.LOG.info(MESSAGE_LOADER.get(FND_TRANSF, requestMessage.getTransformation().getId()));
            this.sessionTracker.addDriverSession(message.getRequestId(), driverSession);
            Session clientSession = this.sessionTracker.fetchClientSessionByRequestId(message.getRequestId());
            if (clientSession != null) {
                CountDownLatch countDownLatch = RequestServerEndpoint.getDriverSessionEstablishedSignal(clientSession);
                if (countDownLatch != null) {
                    this.LOG.info(MESSAGE_LOADER.get(RLS_DRV_SESS_MNT, driverSession.getId()));
                    countDownLatch.countDown();
                }
            } else {
                this.LOG.warn(MESSAGE_LOADER.get(CLT_SESSION_NOT_FOUND, message.getRequestId()));
            }
            driverSession.getBasicRemote().sendObject((Object)requestMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(MESSAGE_LOADER.get(UNX_ERR_PRC_DRV_REQ), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStopMessage(StopMessage message, Session session) {
        Session clientSession;
        if (message.getRequestUUID() == null) {
            this.LOG.info(MESSAGE_LOADER.get(RCV_STP_MSG_CLT));
            this.stopSpark(message, session);
            return;
        }
        this.LOG.info(MESSAGE_LOADER.get(RCV_STP_MSG_DRV));
        RequestData requestData = this.sessionTracker.getRequestData(message.getRequestUUID());
        Session session2 = clientSession = requestData != null ? requestData.getClientSession() : null;
        if (requestData == null || clientSession == null) {
            this.LOG.info(MESSAGE_LOADER.get(UNB_FWD_STP_MSG));
            return;
        }
        clientSession = requestData.getClientSession();
        boolean sparkReuse = requestData.isReuseSparkContext();
        if (!sparkReuse && message.operationFailed()) {
            this.LOG.debug(MESSAGE_LOADER.get(KILLING_SPARK_DRIVER));
            this.hardStopSpark(clientSession);
            message = new StopMessage(MESSAGE_LOADER.get(SPARK_SESSION_KILLED_MSG), StopMessage.Status.SUCCESS);
        }
        try {
            Session session3 = clientSession;
            synchronized (session3) {
                if (clientSession.isOpen()) {
                    clientSession.getBasicRemote().sendObject((Object)message);
                    RequestServerEndpoint.getAndSet(clientSession, STOP_ALREADY_SENT_TO_CLIENT, true);
                } else {
                    this.LOG.info(MESSAGE_LOADER.get(CLT_SESS_CLSD_NO_FWD_STP_MSG));
                }
            }
        }
        catch (IOException | EncodeException e) {
            this.LOG.info(MESSAGE_LOADER.get(UNB_FWD_STP_MSG), e);
            this.onError(session, e);
        }
    }

    private void handleDriverSessionClosed(DriverSessionClosed message, Session session) {
        this.LOG.info(MESSAGE_LOADER.get(RCV_DRV_SESS_CLSD, message.getReason()));
        this.sessionTracker.removeDriverSession(message.getUserId(), session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestMessage(ExecutionRequest message, Session session) {
        try {
            this.LOG.info(MESSAGE_LOADER.get(RCV_REQ_MSG));
            this.setRequestUUID(message, session);
            Session driverSession = null;
            if (message.isToReuseSparkContext()) {
                driverSession = this.sessionTracker.getDriverSession(this.config, message.getActingPrincipal());
            }
            this.sessionTracker.addRequest(this.config, session, message);
            boolean msgSent = false;
            if (driverSession != null && driverSession.isOpen()) {
                Session session2 = driverSession;
                synchronized (session2) {
                    if (driverSession.isOpen()) {
                        try {
                            this.sessionTracker.setDriverSession(message.getRequestId(), driverSession);
                            driverSession.getBasicRemote().sendObject((Object)message);
                            msgSent = true;
                        }
                        catch (IOException | EncodeException e) {
                            this.LOG.warn(MESSAGE_LOADER.get(UNB_STP_MSG_AFT_ERROR_RUN_SPARK));
                            this.onError(driverSession, e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (!msgSent) {
                RequestServerEndpoint.setDriverSessionEstablishedSignal(session);
                this.runSpark(session, message);
                this.startDriverSessionMonitor(session, RequestServerEndpoint.getDriverSessionEstablishedSignal(session));
            }
        }
        catch (Exception e) {
            try {
                session.getBasicRemote().sendObject((Object)new StopMessage(MESSAGE_LOADER.get(ERROR_RUN_SPARK)));
                RequestServerEndpoint.getAndSet(session, STOP_ALREADY_SENT_TO_CLIENT, true);
            }
            catch (IOException | EncodeException e1) {
                this.LOG.info(MESSAGE_LOADER.get(UNB_STP_MSG_AFT_ERROR_RUN_SPARK));
                throw e;
            }
        }
    }

    private void runSpark(final Session session, ExecutionRequest executionRequest) {
        try {
            SparkAppHandle sparkAppHandle = this.sparkRunner.execute(executionRequest);
            RequestServerEndpoint.setSparkAppHandle(session, sparkAppHandle);
            SparkAppHandle.Listener statusListener = new SparkAppHandle.Listener(){
                Session driverSession = null;

                public void stateChanged(SparkAppHandle sparkAppHandle) {
                    SparkAppHandle.State state = sparkAppHandle.getState();
                    if (state.equals((Object)SparkAppHandle.State.KILLED)) {
                        RequestServerEndpoint.this.LOG.info(MESSAGE_LOADER.get(RequestServerEndpoint.SPARK_SESSION_KILLED_MSG));
                        if (this.driverSession != null) {
                            sparkAppHandle.kill();
                            RequestServerEndpoint.this.closeAllClientSessionsFromDriver(this.driverSession);
                        }
                    } else if (this.driverSession == null) {
                        this.driverSession = RequestServerEndpoint.this.sessionTracker.getDriverSession(session);
                    }
                }

                public void infoChanged(SparkAppHandle sparkAppHandle) {
                }
            };
            sparkAppHandle.addListener(statusListener);
        }
        catch (Exception e) {
            this.LOG.error(MESSAGE_LOADER.get(UNX_ERR_RUN_SPARK_JOB), (Throwable)e);
            throw new RuntimeException(MESSAGE_LOADER.get(UNX_ERR_RUN_SPARK_JOB), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllClientSessionsFromDriver(Session driverSession) {
        List<RequestData> requestsData = this.sessionTracker.getRequestsData(driverSession);
        for (RequestData requestData : requestsData) {
            Session clientSession = requestData.getClientSession();
            if (clientSession == null || !clientSession.isOpen()) continue;
            Session session = clientSession;
            synchronized (session) {
                try {
                    if (!RequestServerEndpoint.getAndSet(clientSession, STOP_ALREADY_SENT_TO_CLIENT, true) && clientSession.isOpen()) {
                        clientSession.getBasicRemote().sendObject((Object)new StopMessage(MESSAGE_LOADER.get(SPARK_SESSION_KILLED_MSG), StopMessage.Status.SESSION_KILLED));
                    }
                }
                catch (IOException | EncodeException e1) {
                    this.LOG.warn(MESSAGE_LOADER.get(UNB_STP_MSG_AFT_SESS_KLD));
                    this.onError(clientSession, e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSpark(StopMessage message, Session session) {
        CountDownLatch driverSessionEstablishedSignal = RequestServerEndpoint.getDriverSessionEstablishedSignal(session);
        if (driverSessionEstablishedSignal != null) {
            this.LOG.debug(MESSAGE_LOADER.get(WAIT_DRIVER_2_SEND_STP_MSG, session.getId()));
            try {
                driverSessionEstablishedSignal.await(ValidatorHelper.getTimeAsMs(this.config.getDriverSessionTimeout()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.LOG.error(MESSAGE_LOADER.get(UNX_ERR_PRC_STP_MSG), (Throwable)e);
            }
            this.LOG.debug(MESSAGE_LOADER.get(FINISHED_WAIT_DRIVER_2_SEND_STP_MSG, session.getId()));
        }
        Session driverSession = this.sessionTracker.getDriverSession(session);
        boolean msgSent = false;
        if (driverSession != null && driverSession.isOpen()) {
            Session session2 = driverSession;
            synchronized (session2) {
                String requestId;
                if (driverSession.isOpen() && (requestId = this.sessionTracker.getRequestId(session)) != null) {
                    try {
                        driverSession.getBasicRemote().sendObject((Object)new StopMessage(requestId, message.getReasonPhrase()));
                        msgSent = true;
                    }
                    catch (IOException | EncodeException e) {
                        this.LOG.warn(MESSAGE_LOADER.get(UNABLE_T_SEND_STOP));
                        this.onError(driverSession, e);
                    }
                }
            }
        }
        if (!msgSent) {
            try {
                session.getBasicRemote().sendObject((Object)new StopMessage(MESSAGE_LOADER.get(EXECUTION_ALREADY_FINISHED)));
                RequestServerEndpoint.getAndSet(session, STOP_ALREADY_SENT_TO_CLIENT, true);
            }
            catch (IOException | EncodeException e) {
                this.LOG.warn(MESSAGE_LOADER.get(UNB_STP_MSG_AFT_SESS_KLD));
                this.onError(session, e);
            }
        }
    }

    private void hardStopSpark(Session clientSession) {
        SparkAppHandle sparkAppHandle = RequestServerEndpoint.getSparkAppHandle(clientSession);
        if (sparkAppHandle != null) {
            sparkAppHandle.kill();
        }
    }

    private void startDriverSessionMonitor(Session session, CountDownLatch driverSessionEstablishedSignal) {
        this.LOG.debug(MESSAGE_LOADER.get(ST_DRV_SESS_MNT));
        ExecutorService driverSessionMonitor = Executors.newSingleThreadExecutor();
        driverSessionMonitor.submit(() -> {
            try {
                if (!driverSessionEstablishedSignal.await(ValidatorHelper.getTimeAsMs(this.config.getDriverSessionTimeout()), TimeUnit.MILLISECONDS)) {
                    this.LOG.warn(MESSAGE_LOADER.get(DRV_STB_TOUT_EXP, this.config.getDriverSessionTimeout()));
                    session.getBasicRemote().sendObject((Object)new StopMessage(MESSAGE_LOADER.get(DRIVER_SESSION_TIMEOUT)));
                    RequestServerEndpoint.getAndSet(session, STOP_ALREADY_SENT_TO_CLIENT, true);
                } else {
                    this.LOG.debug(MESSAGE_LOADER.get(DRV_STB_CON_ET, this.config.getDriverSessionTimeout()));
                    RequestServerEndpoint.removeDriverSessionEstablishedSignal(session);
                }
            }
            catch (IOException | InterruptedException | EncodeException e) {
                this.LOG.error(MESSAGE_LOADER.get(DRV_SESS_TOUT_ERROR), e);
            }
        });
    }

    private static void initParameters(Session session) {
        session.getUserProperties().put(CLIENT_LOST_FIRST_MSG_LOGGED, new AtomicBoolean(false));
        session.getUserProperties().put(STOP_ALREADY_SENT_TO_CLIENT, new AtomicBoolean(false));
    }

    private static boolean getAndSet(Session session, String parameter, boolean value) {
        AtomicBoolean property = (AtomicBoolean)session.getUserProperties().get(parameter);
        return property.getAndSet(value);
    }

    private static void setSparkAppHandle(Session session, SparkAppHandle sparkAppHandle) {
        session.getUserProperties().put(SPARK_HANDLER, sparkAppHandle);
    }

    private static SparkAppHandle getSparkAppHandle(Session session) {
        return (SparkAppHandle)session.getUserProperties().get(SPARK_HANDLER);
    }

    private void setRequestUUID(ExecutionRequest message, Session session) {
        session.getUserProperties().put(REQUEST_UUID, message.getRequestId());
    }

    private String getRequestUUID(Session session) {
        return (String)session.getUserProperties().get(REQUEST_UUID);
    }

    private void setUserID(String userId, Session session) {
        session.getUserProperties().put(USER_ID, userId);
    }

    private String getUserID(Session session) {
        return (String)session.getUserProperties().get(USER_ID);
    }

    private static CountDownLatch getDriverSessionEstablishedSignal(Session session) {
        return (CountDownLatch)session.getUserProperties().get(DRIVER_SESSION_CONNECTED_SIGNAL);
    }

    private static void setDriverSessionEstablishedSignal(Session session) {
        session.getUserProperties().put(DRIVER_SESSION_CONNECTED_SIGNAL, new CountDownLatch(1));
    }

    private static void removeDriverSessionEstablishedSignal(Session session) {
        session.getUserProperties().remove(DRIVER_SESSION_CONNECTED_SIGNAL);
    }
}

