/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PathValidator.class);
    private static final String TEST_MODULE = "validation.module.pathFields";
    private static final String HADOOP_CONF_DIR_ERROR_INCORRECTPATH = "hadoopConfDir.error.incorrectPath";
    private static final String SPARK_HOME_ERROR_INCORRECTPATH = "sparkHome.error.incorrectPath";
    private static final String SPARK_APP_ERROR_INCORRECTPATH = "sparkApp.error.incorrectPath";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid = true;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            valid = PathValidator.isValid(obj, "hadoopConfDir", HADOOP_CONF_DIR_ERROR_INCORRECTPATH, "hadoopConfDir", valid, constraintValidatorContext, messages);
            valid = PathValidator.isValid(obj, "sparkHome", SPARK_HOME_ERROR_INCORRECTPATH, "sparkHome", valid, constraintValidatorContext, messages);
            valid = PathValidator.isValid(obj, "sparkApp", SPARK_APP_ERROR_INCORRECTPATH, "sparkApp", valid, constraintValidatorContext, messages);
            LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    private static boolean isValid(Object obj, String beanField, String errorMsg, String propertyField, boolean valid, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String value = BeanUtils.getProperty((Object)obj, (String)beanField);
        boolean testValidation = ValidatorHelper.verifyIfPathExists(value, messages.get(errorMsg), constraintValidatorContext);
        LOG.debug(messages.get("validator.debug.testmessage", propertyField, ValidatorHelper.getTestResult(testValidation)));
        return testValidation ? valid : testValidation;
    }
}

