/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SSLValidator.class);
    private static final String TEST_MODULE = "validation.module.ssl";
    private static final String PORT_ERROR_MANDATORY = "ael.ssl.port.error.mandatory";
    private static final String PORT_ERROR_INVALIDPORT = "ael.ssl.port.error.invalidPort";
    private static final String KEY_STORE_MANDATORY = "ael.ssl.key-store.error.mandatory";
    private static final String KEY_STORE_INCORRECT_PATH = "ael.ssl.key-store.error.incorrectPath";
    private static final String KEY_STORE_TYPE_MANDATORY = "ael.ssl.key-store-type.error.mandatory";
    private static final String WRONG_PROTOCOL = "ael.ssl.websocketURL.warning.wrongProtocol";
    private static final String SEC_UNSEC_PORTS_ENABLED = "ael.ssl.websocketURL.warning.secureAndUnsecurePortsEnabled";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid = true;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            String sslEnabled = BeanUtils.getProperty((Object)obj, (String)"sslEnabled");
            String sslServerPort = BeanUtils.getProperty((Object)obj, (String)"sslServerPort");
            String sslKeyStorePath = BeanUtils.getProperty((Object)obj, (String)"sslKeyStorePath");
            String keyStoreType = BeanUtils.getProperty((Object)obj, (String)"keyStoreType");
            String websocketURL = BeanUtils.getProperty((Object)obj, (String)"websocketURL");
            if ("true".equalsIgnoreCase(sslEnabled)) {
                String httpPort;
                if ("-1".equals(sslServerPort)) {
                    constraintValidatorContext.buildConstraintViolationWithTemplate(messages.get(PORT_ERROR_MANDATORY)).addConstraintViolation();
                    valid = false;
                }
                LOG.debug(messages.get("validator.debug.testmessage", "sslServerPort", ValidatorHelper.getTestResult(valid)));
                boolean testValidation = ValidatorHelper.verifyPort(sslServerPort, messages.get(PORT_ERROR_INVALIDPORT), constraintValidatorContext);
                valid = testValidation ? valid : testValidation;
                LOG.debug(messages.get("validator.debug.testmessage", "sslServerPort", ValidatorHelper.getTestResult(testValidation)));
                testValidation = ValidatorHelper.verifyMandatory(sslKeyStorePath, messages.get(KEY_STORE_MANDATORY), constraintValidatorContext);
                valid = testValidation ? valid : testValidation;
                LOG.debug(messages.get("validator.debug.testmessage", "ael.ssl.key-store", ValidatorHelper.getTestResult(testValidation)));
                testValidation = ValidatorHelper.verifyIfPathExists(sslKeyStorePath, messages.get(KEY_STORE_INCORRECT_PATH), constraintValidatorContext);
                valid = testValidation ? valid : testValidation;
                LOG.debug(messages.get("validator.debug.testmessage", "ael.ssl.key-store", ValidatorHelper.getTestResult(testValidation)));
                testValidation = ValidatorHelper.verifyMandatory(keyStoreType, messages.get(KEY_STORE_TYPE_MANDATORY), constraintValidatorContext);
                valid = testValidation ? valid : testValidation;
                LOG.debug(messages.get("validator.debug.testmessage", "ael.ssl.key-store-type", ValidatorHelper.getTestResult(testValidation)));
                if (websocketURL != null && !websocketURL.isEmpty() && !websocketURL.toLowerCase().contains("wss")) {
                    LOG.warn(messages.get(WRONG_PROTOCOL));
                }
                if ((httpPort = BeanUtils.getProperty((Object)obj, (String)"httpPort")) != null && !httpPort.isEmpty() && !"-1".equals(httpPort)) {
                    LOG.warn(messages.get(SEC_UNSEC_PORTS_ENABLED));
                }
                LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }
}

