/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityValidator.class);
    private static final String TEST_MODULE = "validation.module.security";
    private static final String RELATION_FIELDS_TST = "Related Fields";
    private static final String PATH_VLD_TST = "Path Field";
    private static final String KEYTAB_ERROR_MNDT = "keytabLocation.error.mandatory";
    private static final String KRB_PRNC_ERROR_MNDT = "kerberosPrincipal.error.mandatory";
    private static final String KEYTAB_ERROR_INCPTH = "keytabLocation.error.incorrectPath";
    private static final String HTTP_KEYTAB_ERROR_MNDT = "http.security.keytabLocation.error.mandatory";
    private static final String HTTP_PRINCIPAL_ERROR_MNDT = "http.security.Principal.error.mandatory";
    private static final String HTTP_KEYTAB_ERROR_INCPTH = "http.security.keytabLocation.error.incorrectPath";
    private static final String DRV_KEYTAB_ERROR_MNDT = "driver.security.keytabLocation.error.mandatory";
    private static final String DRV_PRINCIPAL_ERROR_MNDT = "driver.security.Principal.error.mandatory";
    private static final String DRV_KEYTAB_ERROR_INCPTH = "driver.security.keytabLocation.error.incorrectPath";
    private static final String TST_RLT_DBG_MSG = "validator.debug.relatedFieldsTestmessage";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid = true;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            valid = SecurityValidator.isValidRelatedValues(obj, "keytab", "kerberosPrincipal", KEYTAB_ERROR_MNDT, KRB_PRNC_ERROR_MNDT, "keytabLocation", "kerberosPrincipal", valid, constraintValidatorContext, messages);
            valid = SecurityValidator.isValidPath(obj, "keytab", KEYTAB_ERROR_INCPTH, "keytabLocation", valid, constraintValidatorContext, messages);
            valid = SecurityValidator.isValidRelatedValues(obj, "httpSecurityKeytabLocation", "httpSecurityPrincipal", HTTP_KEYTAB_ERROR_MNDT, HTTP_PRINCIPAL_ERROR_MNDT, "http.security.keytabLocation", "http.security.principal", valid, constraintValidatorContext, messages);
            valid = SecurityValidator.isValidPath(obj, "httpSecurityKeytabLocation", HTTP_KEYTAB_ERROR_INCPTH, "http.security.keytabLocation", valid, constraintValidatorContext, messages);
            valid = SecurityValidator.isValidRelatedValues(obj, "driverSecurityKeytabLocation", "driverSecurityPrincipal", DRV_KEYTAB_ERROR_MNDT, DRV_PRINCIPAL_ERROR_MNDT, "driver.security.keytabLocation", "driver.security.principal", valid, constraintValidatorContext, messages);
            valid = SecurityValidator.isValidPath(obj, "driverSecurityKeytabLocation", DRV_KEYTAB_ERROR_INCPTH, "driver.security.keytabLocation", valid, constraintValidatorContext, messages);
            LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    private static boolean isValidRelatedValues(Object obj, String field1, String field2, String errorField1Msg, String errorField2Msg, String propertyField1, String propertyField2, boolean valid, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String field1Value = BeanUtils.getProperty((Object)obj, (String)field1);
        String field2Value = BeanUtils.getProperty((Object)obj, (String)field2);
        boolean testValidation = ValidatorHelper.relatedValues(field1Value, field2Value, messages.get(errorField1Msg), messages.get(errorField2Msg), constraintValidatorContext);
        LOG.debug(messages.get(TST_RLT_DBG_MSG, RELATION_FIELDS_TST, propertyField1 + ", " + propertyField2, ValidatorHelper.getTestResult(testValidation)));
        return testValidation ? valid : testValidation;
    }

    private static boolean isValidPath(Object obj, String beanField, String errorMsg, String propertyField, boolean valid, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String value = BeanUtils.getProperty((Object)obj, (String)beanField);
        boolean testValidation = ValidatorHelper.verifyIfPathExists(value, messages.get(errorMsg), constraintValidatorContext);
        LOG.debug(messages.get(TST_RLT_DBG_MSG, PATH_VLD_TST, propertyField, ValidatorHelper.getTestResult(testValidation)));
        return testValidation ? valid : testValidation;
    }
}

