/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.NamedStaticDataFactory;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.StaticDataSetParametersReadHandler;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StaticDataSetReadHandler
extends AbstractXmlReadHandler {
    private String queryName;
    private String className;
    private String methodName;
    private StaticDataSetParametersReadHandler parameters;
    private NamedStaticDataFactory staticDataFactory;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.queryName = attrs.getValue(this.getUri(), "queryName");
        if (this.queryName == null) {
            throw new ParseException("Attribute 'queryName' must be given");
        }
        this.className = attrs.getValue(this.getUri(), "className");
        if (this.className == null) {
            throw new ParseException("Attribute 'className' must be given");
        }
        this.methodName = attrs.getValue(this.getUri(), "methodName");
        if (this.methodName == null) {
            throw new ParseException("Attribute 'methodName' must be given");
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("padding".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("parameters".equals(tagName)) {
            this.parameters = new StaticDataSetParametersReadHandler();
            return this.parameters;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        LinkedMap map = (LinkedMap)this.parameters.getObject();
        this.staticDataFactory = new NamedStaticDataFactory();
        if (map.isEmpty()) {
            this.staticDataFactory.setQuery(this.queryName, this.className + '#' + this.methodName);
        } else {
            String query = this.className + '#' + this.methodName + '(';
            Object[] objects = map.keys();
            for (int i = 0; i < objects.length; ++i) {
                if (i != 0) {
                    query = query + ",";
                }
                query = query + String.valueOf(objects[i]);
            }
            this.staticDataFactory.setQuery(this.queryName, query);
        }
    }

    public Object getObject() throws SAXException {
        return this.staticDataFactory;
    }
}

