/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.DoubleDimensionConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.Point2DConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ElementBorderReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ElementPaddingReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ElementStyleExpressionsReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractReportElementReadHandler
extends PropertiesReadHandler {
    private ElementStyleExpressionsReadHandler styleExpressions;

    protected ElementStyleSheet getStyle() {
        return this.getElement().getStyle();
    }

    protected abstract Element getElement();

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(this.getUri())) {
            return null;
        }
        if ("styleExpressions".equals(tagName)) {
            this.styleExpressions = new ElementStyleExpressionsReadHandler();
            return this.styleExpressions;
        }
        if ("padding".equals(tagName)) {
            return new ElementPaddingReadHandler(this.getStyle());
        }
        if ("elementBorder".equals(tagName)) {
            return new ElementBorderReadHandler(this.getStyle());
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        String dynContent;
        String bgColorText;
        String maxSizeText;
        String prefSizeText;
        String minSizeText;
        String positionText;
        super.doneParsing();
        Properties result1 = this.getResult();
        String name = result1.getProperty("name");
        if (name != null) {
            this.getElement().setName(name);
        }
        if ((positionText = result1.getProperty("position")) != null) {
            Point2D pos = (Point2D)new Point2DConverter().convertFromString(positionText, this.getLocator());
            this.getStyle().setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(pos.getX()));
            this.getStyle().setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(pos.getY()));
        }
        if ((minSizeText = result1.getProperty("minimumSize")) != null) {
            Dimension2D size = (Dimension2D)new DoubleDimensionConverter().convertFromString(minSizeText, this.getLocator());
            this.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(size.getWidth()));
            this.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(size.getHeight()));
        }
        if ((prefSizeText = result1.getProperty("preferredSize")) != null) {
            Dimension2D size = (Dimension2D)new DoubleDimensionConverter().convertFromString(prefSizeText, this.getLocator());
            this.getStyle().setStyleProperty(ElementStyleKeys.WIDTH, (Object)new Float(size.getWidth()));
            this.getStyle().setStyleProperty(ElementStyleKeys.HEIGHT, (Object)new Float(size.getHeight()));
        }
        if ((maxSizeText = result1.getProperty("maximumSize")) != null) {
            Dimension2D size = (Dimension2D)new DoubleDimensionConverter().convertFromString(maxSizeText, this.getLocator());
            this.getStyle().setStyleProperty(ElementStyleKeys.MAX_WIDTH, (Object)new Float(size.getWidth()));
            this.getStyle().setStyleProperty(ElementStyleKeys.MAX_HEIGHT, (Object)new Float(size.getHeight()));
        }
        if ((bgColorText = result1.getProperty("background")) != null) {
            Color c = ColorConverter.getObject(bgColorText);
            this.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)c);
        }
        if ((dynContent = result1.getProperty("dynamicContent")) != null) {
            if ("true".equals(dynContent)) {
                this.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, (Object)Boolean.TRUE);
            } else {
                this.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, (Object)Boolean.FALSE);
            }
        }
        Map map = this.getStyleExpressions();
        for (Map.Entry entry : map.entrySet()) {
            StyleKey key = (StyleKey)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            this.getElement().setStyleExpression(key, expression);
        }
    }

    protected Map getStyleExpressions() throws SAXException {
        if (this.styleExpressions != null) {
            return (Map)this.styleExpressions.getObject();
        }
        return Collections.emptyMap();
    }
}

