/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.util.ArrayList;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.AbstractReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.AnchorFieldElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ChartElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.DateFieldReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.DrawableFieldReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.EllipseElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ImageFieldReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.LabelReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.LineReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.MessageReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.NumberFieldReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.RectangleElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ResourceFieldReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ResourceLabelReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.ResourceMessageReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.StaticImageReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.TextFieldReportElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BandElementReadHandler
extends AbstractReportElementReadHandler {
    private Band band;
    private ArrayList<AbstractReportElementReadHandler> childElements = new ArrayList();

    public BandElementReadHandler(Band band) {
        this.band = band;
    }

    @Override
    protected Element getElement() {
        return this.band;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && "child".equalsIgnoreCase(tagName)) {
            String type = atts.getValue(uri, "type");
            if ("org.pentaho.reportdesigner.crm.report.model.BandReportElement".equals(type)) {
                BandElementReadHandler readHandler = new BandElementReadHandler(new Band());
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.AnchorFieldReportElement".equals(type)) {
                AnchorFieldElementReadHandler readHandler = new AnchorFieldElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.DateFieldReportElement".equals(type)) {
                DateFieldReportElementReadHandler readHandler = new DateFieldReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ChartReportElement".equals(type)) {
                ChartElementReadHandler readHandler = new ChartElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.EllipseReportElement".equals(type)) {
                EllipseElementReadHandler readHandler = new EllipseElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ImageURLFieldReportElement".equals(type) || "org.pentaho.reportdesigner.crm.report.model.ImageFieldReportElement".equals(type)) {
                ImageFieldReportElementReadHandler readHandler = new ImageFieldReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.LabelReportElement".equals(type)) {
                LabelReportElementReadHandler readHandler = new LabelReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.LineReportElement".equals(type)) {
                LineReportElementReadHandler readHandler = new LineReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.MessageFieldReportElement".equals(type)) {
                MessageReportElementReadHandler readHandler = new MessageReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.NumberFieldReportElement".equals(type)) {
                NumberFieldReportElementReadHandler readHandler = new NumberFieldReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.RectangleReportElement".equals(type)) {
                RectangleElementReadHandler readHandler = new RectangleElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ResourceFieldReportElement".equals(type)) {
                ResourceFieldReportElementReadHandler readHandler = new ResourceFieldReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ResourceLabelReportElement".equals(type)) {
                ResourceLabelReportElementReadHandler readHandler = new ResourceLabelReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ResourceMessageReportElement".equals(type)) {
                ResourceMessageReportElementReadHandler readHandler = new ResourceMessageReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.StaticImageReportElement".equals(type)) {
                StaticImageReportElementReadHandler readHandler = new StaticImageReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.TextFieldReportElement".equals(type)) {
                TextFieldReportElementReadHandler readHandler = new TextFieldReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.DrawableFieldReportElement".equals(type)) {
                DrawableFieldReportElementReadHandler readHandler = new DrawableFieldReportElementReadHandler();
                this.childElements.add(readHandler);
                return readHandler;
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    @Override
    protected void doneParsing() throws SAXException {
        super.doneParsing();
        Properties result = this.getResult();
        String showInGUI = result.getProperty("showInLayoutGUI");
        if (showInGUI != null) {
            if ("true".equals(showInGUI)) {
                this.band.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.FALSE);
            } else {
                this.band.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
            }
        }
        String layoutType = result.getProperty("reportLayoutManagerType");
        this.band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, this.parseLayoutManager(layoutType));
        for (int i = 0; i < this.childElements.size(); ++i) {
            AbstractReportElementReadHandler handler = this.childElements.get(i);
            this.band.addElement(handler.getElement());
        }
    }

    private Object parseLayoutManager(String layoutType) {
        if (layoutType == null) {
            return null;
        }
        if ("STACKED".equals(layoutType)) {
            return "block";
        }
        if ("NULL".equals(layoutType)) {
            return "canvas";
        }
        return null;
    }

    public Band getBand() {
        return this.band;
    }

    public Object getObject() throws SAXException {
        return this.band;
    }
}

