/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.verticabulkload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.verticabulkload.VerticaBulkLoaderMeta;

public class VerticaBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = VerticaBulkLoaderMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wMainTab;
    private CTabItem wFieldsTab;
    private FormData fdMainComp;
    private FormData fdFieldsComp;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlExceptionsLogFile;
    private TextVar wExceptionsLogFile;
    private FormData fdlExceptionsLogFile;
    private FormData fdExceptionsLogFile;
    private Label wlRejectedDataLogFile;
    private TextVar wRejectedDataLogFile;
    private FormData fdlRejectedDataLogFile;
    private FormData fdRejectedDataLogFile;
    private Label wlStreamName;
    private TextVar wStreamName;
    private FormData fdlStreamName;
    private FormData fdStreamName;
    private Label wlAbortOnError;
    private Button wAbortOnError;
    private FormData fdlAbortOnError;
    private FormData fdAbortOnError;
    private Label wlDirect;
    private Button wDirect;
    private FormData fdlDirect;
    private FormData fdDirect;
    private Label wlSpecifyFields;
    private Button wSpecifyFields;
    private FormData fdlSpecifyFields;
    private FormData fdSpecifyFields;
    private Label wlFields;
    private TableView wFields;
    private Button wGetFields;
    private FormData fdGetFields;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private VerticaBulkLoaderMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciFields;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public VerticaBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (VerticaBulkLoaderMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VerticaBulkLoaderDialog.this.input.setChanged();
            }
        };
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                VerticaBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DialogTitle", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString((String)"System.Label.StepName"));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                VerticaBulkLoaderDialog.this.setFlags();
            }
        });
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString((String)"System.Button.Browse"));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        this.fdTable = new FormData();
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData((Object)this.fdTable);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                VerticaBulkLoaderDialog.this.input.setChanged();
            }
        };
        this.wlSpecifyFields = new Label((Composite)this.shell, 131072);
        this.wlSpecifyFields.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.SpecifyFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSpecifyFields);
        this.fdlSpecifyFields = new FormData();
        this.fdlSpecifyFields.left = new FormAttachment(0, 0);
        this.fdlSpecifyFields.top = new FormAttachment((Control)this.wbTable, margin);
        this.fdlSpecifyFields.right = new FormAttachment(middle, -margin);
        this.wlSpecifyFields.setLayoutData((Object)this.fdlSpecifyFields);
        this.wSpecifyFields = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSpecifyFields);
        this.fdSpecifyFields = new FormData();
        this.fdSpecifyFields.left = new FormAttachment(middle, 0);
        this.fdSpecifyFields.top = new FormAttachment((Control)this.wbTable, margin);
        this.fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)this.fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)lsSelMod);
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                VerticaBulkLoaderDialog.this.setFlags();
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wMainTab = new CTabItem(this.wTabFolder, 0);
        this.wMainTab.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.MainTab.CTabItem", (String[])new String[0]));
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        Composite wMainComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMainComp);
        wMainComp.setLayout((Layout)mainLayout);
        this.fdMainComp = new FormData();
        this.fdMainComp.left = new FormAttachment(0, 0);
        this.fdMainComp.top = new FormAttachment(0, 0);
        this.fdMainComp.right = new FormAttachment(100, 0);
        this.fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)this.fdMainComp);
        this.wlDirect = new Label(wMainComp, 131072);
        this.wlDirect.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertDirect.Label", (String[])new String[0]));
        this.wlDirect.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertDirect.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlDirect);
        this.fdlDirect = new FormData();
        this.fdlDirect.left = new FormAttachment(0, 0);
        this.fdlDirect.top = new FormAttachment(0, margin);
        this.fdlDirect.right = new FormAttachment(middle, -margin);
        this.wlDirect.setLayoutData((Object)this.fdlDirect);
        this.wDirect = new Button(wMainComp, 32);
        this.wDirect.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertDirect.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDirect);
        this.fdDirect = new FormData();
        this.fdDirect.left = new FormAttachment(middle, 0);
        this.fdDirect.top = new FormAttachment(0, margin);
        this.fdDirect.right = new FormAttachment(100, 0);
        this.wDirect.setLayoutData((Object)this.fdDirect);
        this.wlAbortOnError = new Label(wMainComp, 131072);
        this.wlAbortOnError.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.AbortOnError.Label", (String[])new String[0]));
        this.wlAbortOnError.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.AbortOnError.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlAbortOnError);
        this.fdlAbortOnError = new FormData();
        this.fdlAbortOnError.left = new FormAttachment(0, 0);
        this.fdlAbortOnError.top = new FormAttachment((Control)this.wDirect, margin);
        this.fdlAbortOnError.right = new FormAttachment(middle, -margin);
        this.wlAbortOnError.setLayoutData((Object)this.fdlAbortOnError);
        this.wAbortOnError = new Button(wMainComp, 32);
        this.wAbortOnError.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.AbortOnError.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAbortOnError);
        this.fdAbortOnError = new FormData();
        this.fdAbortOnError.left = new FormAttachment(middle, 0);
        this.fdAbortOnError.top = new FormAttachment((Control)this.wDirect, margin);
        this.fdAbortOnError.right = new FormAttachment(100, 0);
        this.wAbortOnError.setLayoutData((Object)this.fdAbortOnError);
        this.wlExceptionsLogFile = new Label(wMainComp, 131072);
        this.wlExceptionsLogFile.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ExceptionsLogFile.Label", (String[])new String[0]));
        this.wlExceptionsLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ExceptionsLogFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlExceptionsLogFile);
        this.fdlExceptionsLogFile = new FormData();
        this.fdlExceptionsLogFile.left = new FormAttachment(0, 0);
        this.fdlExceptionsLogFile.right = new FormAttachment(middle, -margin);
        this.fdlExceptionsLogFile.top = new FormAttachment((Control)this.wAbortOnError, margin * 2);
        this.wlExceptionsLogFile.setLayoutData((Object)this.fdlExceptionsLogFile);
        this.wExceptionsLogFile = new TextVar((VariableSpace)this.transMeta, wMainComp, 18436);
        this.wExceptionsLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ExceptionsLogFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExceptionsLogFile);
        this.wExceptionsLogFile.addModifyListener(lsMod);
        this.wExceptionsLogFile.addFocusListener((FocusListener)lsFocusLost);
        this.fdExceptionsLogFile = new FormData();
        this.fdExceptionsLogFile.left = new FormAttachment(middle, 0);
        this.fdExceptionsLogFile.top = new FormAttachment((Control)this.wAbortOnError, margin * 2);
        this.fdExceptionsLogFile.right = new FormAttachment(100, 0);
        this.wExceptionsLogFile.setLayoutData((Object)this.fdExceptionsLogFile);
        this.wlRejectedDataLogFile = new Label(wMainComp, 131072);
        this.wlRejectedDataLogFile.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.RejectedDataLogFile.Label", (String[])new String[0]));
        this.wlRejectedDataLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.RejectedDataLogFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlRejectedDataLogFile);
        this.fdlRejectedDataLogFile = new FormData();
        this.fdlRejectedDataLogFile.left = new FormAttachment(0, 0);
        this.fdlRejectedDataLogFile.right = new FormAttachment(middle, -margin);
        this.fdlRejectedDataLogFile.top = new FormAttachment((Control)this.wExceptionsLogFile, margin * 2);
        this.wlRejectedDataLogFile.setLayoutData((Object)this.fdlRejectedDataLogFile);
        this.wRejectedDataLogFile = new TextVar((VariableSpace)this.transMeta, wMainComp, 18436);
        this.wRejectedDataLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.RejectedDataLogFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRejectedDataLogFile);
        this.wRejectedDataLogFile.addModifyListener(lsMod);
        this.wRejectedDataLogFile.addFocusListener((FocusListener)lsFocusLost);
        this.fdRejectedDataLogFile = new FormData();
        this.fdRejectedDataLogFile.left = new FormAttachment(middle, 0);
        this.fdRejectedDataLogFile.top = new FormAttachment((Control)this.wExceptionsLogFile, margin * 2);
        this.fdRejectedDataLogFile.right = new FormAttachment(100, 0);
        this.wRejectedDataLogFile.setLayoutData((Object)this.fdRejectedDataLogFile);
        this.wlStreamName = new Label(wMainComp, 131072);
        this.wlStreamName.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.StreamName.Label", (String[])new String[0]));
        this.wlStreamName.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.StreamName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlStreamName);
        this.fdlStreamName = new FormData();
        this.fdlStreamName.left = new FormAttachment(0, 0);
        this.fdlStreamName.right = new FormAttachment(middle, -margin);
        this.fdlStreamName.top = new FormAttachment((Control)this.wRejectedDataLogFile, margin * 2);
        this.wlStreamName.setLayoutData((Object)this.fdlStreamName);
        this.wStreamName = new TextVar((VariableSpace)this.transMeta, wMainComp, 18436);
        this.wStreamName.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.StreamName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wStreamName);
        this.wStreamName.addModifyListener(lsMod);
        this.wStreamName.addFocusListener((FocusListener)lsFocusLost);
        this.fdStreamName = new FormData();
        this.fdStreamName.left = new FormAttachment(middle, 0);
        this.fdStreamName.top = new FormAttachment((Control)this.wRejectedDataLogFile, margin * 2);
        this.fdStreamName.right = new FormAttachment(100, 0);
        this.wStreamName.setLayoutData((Object)this.fdStreamName);
        wMainComp.layout();
        this.wMainTab.setControl((Control)wMainComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FieldsTab.CTabItem.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = 5;
        fieldsCompLayout.marginHeight = 5;
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        this.wlFields = new Label(wFieldsComp, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int UpInsRows = this.input.getFieldStream() != null ? this.input.getFieldStream().length : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciFields[0]);
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 68354, this.ciFields, UpInsRows, lsMod, this.props);
        this.wGetFields = new Button(wFieldsComp, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.GetFields.Button", (String[])new String[0]));
        this.fdGetFields = new FormData();
        this.fdGetFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)this.fdGetFields);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.Button", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                VerticaBulkLoaderDialog.this.generateMappings();
            }
        });
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment(100, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = VerticaBulkLoaderDialog.this.transMeta.findStep(VerticaBulkLoaderDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = VerticaBulkLoaderDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            VerticaBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        VerticaBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        VerticaBulkLoaderDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message")});
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString((String)"System.Button.SQL"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wCreate}, margin, null);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wSpecifyFields, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                VerticaBulkLoaderDialog.this.ok();
            }
        };
        this.lsCreate = new Listener(){

            public void handleEvent(Event e) {
                VerticaBulkLoaderDialog.this.sql();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                VerticaBulkLoaderDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                VerticaBulkLoaderDialog.this.get();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCreate.addListener(13, this.lsCreate);
        this.wCancel.addListener(13, this.lsCancel);
        this.wGetFields.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                VerticaBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VerticaBulkLoaderDialog.this.getTableName();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                VerticaBulkLoaderDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTablename(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                block6: {
                    DatabaseMeta ci;
                    for (int i = 0; i < VerticaBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = (ColumnInfo)VerticaBulkLoaderDialog.this.tableFieldColumns.get(i);
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Const.isEmpty((String)VerticaBulkLoaderDialog.this.wTable.getText()) && (ci = VerticaBulkLoaderDialog.this.transMeta.findDatabase(VerticaBulkLoaderDialog.this.wConnection.getText())) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(VerticaBulkLoaderDialog.this.transMeta.environmentSubstitute(VerticaBulkLoaderDialog.this.wSchema.getText()), VerticaBulkLoaderDialog.this.transMeta.environmentSubstitute(VerticaBulkLoaderDialog.this.wTable.getText()));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block6;
                            for (int i = 0; i < VerticaBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)VerticaBulkLoaderDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (int i = 0; i < VerticaBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)VerticaBulkLoaderDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciFields[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        boolean specifyFields = this.wSpecifyFields.getSelection();
        this.wFields.setEnabled(specifyFields);
        this.wGetFields.setEnabled(specifyFields);
    }

    public void getData() {
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getExceptionsFileName() != null) {
            this.wExceptionsLogFile.setText(this.input.getExceptionsFileName());
        }
        if (this.input.getRejectedDataFileName() != null) {
            this.wRejectedDataLogFile.setText(this.input.getRejectedDataFileName());
        }
        if (this.input.getStreamName() != null) {
            this.wStreamName.setText(this.input.getStreamName());
        }
        this.wDirect.setSelection(this.input.isDirect());
        this.wAbortOnError.setSelection(this.input.isAbortOnError());
        this.wSpecifyFields.setSelection(this.input.specifyFields());
        for (int i = 0; i < this.input.getFieldDatabase().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getFieldDatabase()[i] != null) {
                item.setText(1, this.input.getFieldDatabase()[i]);
            }
            if (this.input.getFieldStream()[i] == null) continue;
            item.setText(2, this.input.getFieldStream()[i]);
        }
        this.setFlags();
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(VerticaBulkLoaderMeta info) {
        info.setSchemaName(this.wSchema.getText());
        info.setTablename(this.wTable.getText());
        info.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        info.setExceptionsFileName(this.wExceptionsLogFile.getText());
        info.setRejectedDataFileName(this.wRejectedDataLogFile.getText());
        info.setStreamName(this.wStreamName.getText());
        info.setDirect(this.wDirect.getSelection());
        info.setAbortOnError(this.wAbortOnError.getSelection());
        info.setSpecifyFields(this.wSpecifyFields.getSelection());
        int nrRows = this.wFields.nrNonEmpty();
        info.allocate(nrRows);
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            info.getFieldDatabase()[i] = Const.NVL((String)item.getText(1), (String)"");
            info.getFieldStream()[i] = Const.NVL((String)item.getText(2), (String)"");
        }
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)"System.Dialog.Error.Title"));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            DatabaseMeta inf = this.transMeta.getDatabase(connr);
            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[]{inf.toString()})});
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)"System.Dialog.Error.Title"));
            mb.open();
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void sql() {
        try {
            SQLStatement sql;
            VerticaBulkLoaderMeta info = new VerticaBulkLoaderMeta();
            this.getInfo(info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            StepMeta stepMeta = this.transMeta.findStep(this.stepname);
            if (info.specifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getFieldDatabase().length; ++i) {
                    ValueMetaInterface insValue = prev.searchValueMeta(info.getFieldStream()[i]);
                    if (insValue == null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FailedToFindField.Message", (String[])new String[]{info.getFieldStream()[i]}));
                    }
                    ValueMetaInterface insertValue = insValue.clone();
                    insertValue.setName(info.getFieldDatabase()[i]);
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            if (!(sql = info.getSQLStatements(this.transMeta, stepMeta, prev)).hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor(this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString((String)"System.Dialog.Error.Title"));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

