/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.IUserRoleListChangeListener;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.UserRoleHelper;
import org.pentaho.di.repository.pur.UserRoleListChangeListenerCollection;
import org.pentaho.di.repository.pur.UserRoleLookupCache;
import org.pentaho.di.repository.pur.model.IEEUser;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.platform.api.engine.security.userroledao.UserRoleInfo;
import org.pentaho.platform.security.userrole.ws.IUserRoleListWebService;
import org.pentaho.platform.security.userroledao.ws.IUserRoleWebService;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoRole;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoUser;
import org.pentaho.platform.security.userroledao.ws.UserRoleException;
import org.pentaho.platform.security.userroledao.ws.UserRoleSecurityInfo;

public class UserRoleDelegate
implements Serializable {
    private static final String TRUST_USER = "_trust_user_";
    private static final long serialVersionUID = 1295309456550391059L;
    private UserRoleListChangeListenerCollection userRoleListChangeListeners;
    private final Log logger;
    IUserRoleWebService userRoleWebService;
    IUserRoleListWebService userDetailsRoleListWebService;
    IRoleSupportSecurityManager rsm;
    UserRoleLookupCache lookupCache;
    UserRoleSecurityInfo userRoleSecurityInfo;
    UserRoleInfo userRoleInfo;
    boolean hasNecessaryPermissions = false;
    boolean managed = true;

    public UserRoleDelegate(IRoleSupportSecurityManager rsm, PurRepositoryMeta repositoryMeta, IUser userInfo, Log logger, ServiceManager serviceManager) {
        this.logger = logger;
        String login = userInfo.getLogin();
        String password = userInfo.getPassword();
        try {
            this.userDetailsRoleListWebService = serviceManager.createService(login, password, IUserRoleListWebService.class);
            this.userRoleWebService = serviceManager.createService(login, password, IUserRoleWebService.class);
            this.rsm = rsm;
            this.initManaged(repositoryMeta, userInfo);
            this.updateUserRoleInfo();
        }
        catch (Exception e) {
            this.logger.error((Object)BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0001_UNABLE_TO_INITIALIZE_USER_ROLE_WEBSVC", (String[])new String[0]), (Throwable)e);
        }
    }

    UserRoleDelegate(Log logger, IUserRoleListWebService userDetailsRoleListWebService, IUserRoleWebService userRoleWebService) {
        this.logger = logger;
        this.userDetailsRoleListWebService = userDetailsRoleListWebService;
        this.userRoleWebService = userRoleWebService;
    }

    private void initManaged(PurRepositoryMeta repositoryMeta, IUser userInfo) throws JSONException {
        String baseUrl = repositoryMeta.getRepositoryLocation().getUrl();
        String webService = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/system/authentication-provider";
        HTTPBasicAuthFilter authFilter = new HTTPBasicAuthFilter(userInfo.getLogin(), userInfo.getPassword());
        Client client = new Client();
        client.addFilter((ClientFilter)authFilter);
        WebResource.Builder resource = client.resource(webService).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (StringUtils.isNotBlank((String)System.getProperty("pentaho.repository.client.attemptTrust"))) {
            resource = (WebResource.Builder)resource.header(TRUST_USER, (Object)userInfo.getLogin());
        }
        String response = (String)resource.get(String.class);
        String provider = new JSONObject(response).getString("authenticationType");
        this.managed = "jackrabbit".equals(provider);
    }

    public void updateUserRoleInfo() throws UserRoleException {
        if (this.isManaged()) {
            this.userRoleSecurityInfo = this.userRoleWebService.getUserRoleSecurityInfo();
            this.lookupCache = new UserRoleLookupCache(this.userRoleSecurityInfo, this.rsm);
            this.hasNecessaryPermissions = true;
        } else {
            this.userRoleInfo = this.userDetailsRoleListWebService.getUserRoleInfo();
            this.hasNecessaryPermissions = false;
        }
    }

    public boolean isManaged() {
        return this.managed;
    }

    private void ensureHasPermissions() throws KettleException {
        if (!this.hasNecessaryPermissions) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0014_INSUFFICIENT_PRIVILEGES", (String[])new String[0]));
        }
    }

    public void createUser(IUser newUser) throws KettleException {
        this.ensureHasPermissions();
        ProxyPentahoUser user = UserRoleHelper.convertToPentahoProxyUser(newUser);
        try {
            ProxyPentahoUser[] existingUsers = this.userRoleWebService.getUsers();
            if (this.existsAmong(existingUsers, user)) {
                throw this.userExistsException();
            }
        }
        catch (UserRoleException e) {
            throw this.cannotCreateUserException(newUser, (Exception)((Object)e));
        }
        try {
            this.userRoleWebService.createUser(user);
            if (newUser instanceof IEEUser) {
                this.userRoleWebService.setRoles(user, UserRoleHelper.convertToPentahoProxyRoles(((IEEUser)newUser).getRoles()));
            }
            this.lookupCache.insertUserToLookupSet(newUser);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            if (e.getCause().toString().contains("org.pentaho.platform.api.engine.security.userroledao.AlreadyExistsException")) {
                throw this.userExistsException();
            }
            throw this.cannotCreateUserException(newUser, e);
        }
    }

    private boolean existsAmong(ProxyPentahoUser[] existing, ProxyPentahoUser user) {
        if (existing != null) {
            String name = user.getName();
            for (ProxyPentahoUser pentahoUser : existing) {
                if (!name.equals(pentahoUser.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private KettleException userExistsException() {
        return new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0015_USER_NAME_ALREADY_EXISTS", (String[])new String[0]));
    }

    private KettleException cannotCreateUserException(IUser user, Exception e) {
        return new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0002_UNABLE_TO_CREATE_USER", (String[])new String[]{user.getName()}), (Throwable)e);
    }

    public void deleteUsers(List<IUser> users) throws KettleException {
        this.ensureHasPermissions();
        try {
            this.userRoleWebService.deleteUsers(UserRoleHelper.convertToPentahoProxyUsers(users));
            this.lookupCache.removeUsersFromLookupSet(users);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0003_UNABLE_TO_DELETE_USERS", (String[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public void deleteUser(String name) throws KettleException {
        this.ensureHasPermissions();
        try {
            ProxyPentahoUser user = this.userRoleWebService.getUser(name);
            if (user == null) {
                throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0004_UNABLE_TO_DELETE_USER", (String[])new String[]{name}));
            }
            ProxyPentahoUser[] users = new ProxyPentahoUser[]{user};
            this.userRoleWebService.deleteUsers(users);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0004_UNABLE_TO_DELETE_USER", (String[])new String[]{name}), (Throwable)e);
        }
    }

    public void setUsers(List<IUser> users) throws KettleException {
    }

    public IUser getUser(String name, String password) throws KettleException {
        this.ensureHasPermissions();
        IUser userInfo = null;
        try {
            ProxyPentahoUser user = this.userRoleWebService.getUser(name);
            if (user != null && user.getName().equals(name) && user.getPassword().equals(password)) {
                userInfo = UserRoleHelper.convertToUserInfo(user, this.userRoleWebService.getRolesForUser(user), this.rsm);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0005_UNABLE_TO_GET_USER", (String[])new String[]{name}), (Throwable)e);
        }
        return userInfo;
    }

    public IUser getUser(String name) throws KettleException {
        this.ensureHasPermissions();
        IUser userInfo = null;
        try {
            ProxyPentahoUser user = this.userRoleWebService.getUser(name);
            if (user != null && user.getName().equals(name)) {
                userInfo = UserRoleHelper.convertToUserInfo(user, this.userRoleWebService.getRolesForUser(user), this.rsm);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0005_UNABLE_TO_GET_USER", (String[])new String[]{name}), (Throwable)e);
        }
        return userInfo;
    }

    public List<IUser> getUsers() throws KettleException {
        try {
            if (this.hasNecessaryPermissions) {
                return UserRoleHelper.convertFromProxyPentahoUsers(this.userRoleSecurityInfo, this.rsm);
            }
            return UserRoleHelper.convertFromNonPentahoUsers(this.userRoleInfo, this.rsm);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0006_UNABLE_TO_GET_USERS", (String[])new String[0]), (Throwable)e);
        }
    }

    public void updateUser(IUser user) throws KettleException {
        this.ensureHasPermissions();
        try {
            ProxyPentahoUser proxyUser = UserRoleHelper.convertToPentahoProxyUser(user);
            this.userRoleWebService.updateUser(proxyUser);
            if (user instanceof IEEUser) {
                this.userRoleWebService.setRoles(proxyUser, UserRoleHelper.convertToPentahoProxyRoles(((IEEUser)user).getRoles()));
            }
            this.lookupCache.updateUserInLookupSet(user);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0007_UNABLE_TO_UPDATE_USER", (String[])new String[]{user.getLogin()}), (Throwable)e);
        }
    }

    public void createRole(IRole newRole) throws KettleException {
        block6: {
            this.ensureHasPermissions();
            ProxyPentahoRole role = UserRoleHelper.convertToPentahoProxyRole(newRole);
            try {
                ProxyPentahoRole[] existingRoles = this.userRoleWebService.getRoles();
                if (this.existsAmong(existingRoles, role)) {
                    throw this.roleExistsException();
                }
            }
            catch (UserRoleException e) {
                throw this.cannotCreateRoleException(newRole, (Exception)((Object)e));
            }
            try {
                this.userRoleWebService.createRole(role);
                this.userRoleWebService.setUsers(role, UserRoleHelper.convertToPentahoProxyUsers(newRole.getUsers()));
                this.lookupCache.insertRoleToLookupSet(newRole);
                this.fireUserRoleListChange();
            }
            catch (UserRoleException e) {
                throw this.cannotCreateRoleException(newRole, (Exception)((Object)e));
            }
            catch (Exception e) {
                if (!e.getCause().toString().contains("org.pentaho.platform.api.engine.security.userroledao.AlreadyExistsException")) break block6;
                throw this.roleExistsException();
            }
        }
    }

    private boolean existsAmong(ProxyPentahoRole[] existing, ProxyPentahoRole role) {
        if (existing != null) {
            String name = role.getName();
            for (ProxyPentahoRole pentahoRole : existing) {
                if (!name.equalsIgnoreCase(pentahoRole.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private KettleException roleExistsException() {
        return new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0016_ROLE_NAME_ALREADY_EXISTS", (String[])new String[0]));
    }

    private KettleException cannotCreateRoleException(IRole role, Exception e) {
        return new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0008_UNABLE_TO_CREATE_ROLE", (String[])new String[]{role.getName()}), (Throwable)e);
    }

    public void deleteRoles(List<IRole> roles) throws KettleException {
        this.ensureHasPermissions();
        try {
            this.userRoleWebService.deleteRoles(UserRoleHelper.convertToPentahoProxyRoles(roles));
            this.lookupCache.removeRolesFromLookupSet(roles);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0009_UNABLE_TO_DELETE_ROLES", (String[])new String[0]), (Throwable)e);
        }
    }

    public IRole getRole(String name) throws KettleException {
        this.ensureHasPermissions();
        try {
            return UserRoleHelper.convertFromProxyPentahoRole(this.userRoleWebService, UserRoleHelper.getProxyPentahoRole(this.userRoleWebService, name), this.lookupCache, this.rsm);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0010_UNABLE_TO_GET_ROLE", (String[])new String[]{name}), (Throwable)e);
        }
    }

    public List<IRole> getRoles() throws KettleException {
        try {
            if (this.hasNecessaryPermissions) {
                return UserRoleHelper.convertToListFromProxyPentahoRoles(this.userRoleSecurityInfo, this.rsm);
            }
            return UserRoleHelper.convertToListFromNonPentahoRoles(this.userRoleInfo, this.rsm);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0011_UNABLE_TO_GET_ROLES", (String[])new String[0]), (Throwable)e);
        }
    }

    public List<IRole> getDefaultRoles() throws KettleException {
        this.ensureHasPermissions();
        try {
            return UserRoleHelper.convertToListFromProxyPentahoDefaultRoles(this.userRoleSecurityInfo, this.rsm);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0011_UNABLE_TO_GET_ROLES", (String[])new String[0]), (Throwable)e);
        }
    }

    public void updateRole(IRole role) throws KettleException {
        this.ensureHasPermissions();
        try {
            ArrayList<String> users = new ArrayList<String>();
            for (IUser user : role.getUsers()) {
                users.add(user.getLogin());
            }
            this.userRoleWebService.updateRole(role.getName(), role.getDescription(), users);
            this.lookupCache.updateRoleInLookupSet(role);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0012_UNABLE_TO_UPDATE_ROLE", (String[])new String[]{role.getName()}), (Throwable)e);
        }
    }

    public void deleteRole(String name) throws KettleException {
        this.ensureHasPermissions();
        try {
            ProxyPentahoRole roleToDelete = UserRoleHelper.getProxyPentahoRole(this.userRoleWebService, name);
            if (roleToDelete == null) {
                throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0013_UNABLE_TO_DELETE_ROLE", (String[])new String[]{name}));
            }
            ProxyPentahoRole[] roleArray = new ProxyPentahoRole[]{roleToDelete};
            this.userRoleWebService.deleteRoles(roleArray);
            this.fireUserRoleListChange();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(UserRoleDelegate.class, (String)"UserRoleDelegate.ERROR_0013_UNABLE_TO_DELETE_ROLE", (String[])new String[]{name}), (Throwable)e);
        }
    }

    public void setRoles(List<IRole> roles) throws KettleException {
    }

    public void addUserRoleListChangeListener(IUserRoleListChangeListener listener) {
        if (this.userRoleListChangeListeners == null) {
            this.userRoleListChangeListeners = new UserRoleListChangeListenerCollection();
        }
        this.userRoleListChangeListeners.add(listener);
    }

    public void removeUserRoleListChangeListener(IUserRoleListChangeListener listener) {
        if (this.userRoleListChangeListeners != null) {
            this.userRoleListChangeListeners.remove(listener);
        }
    }

    void fireUserRoleListChange() {
        if (this.userRoleListChangeListeners != null) {
            this.userRoleListChangeListeners.fireOnChange();
        }
    }
}

