/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ConfigUtils;

public class StatusUtils {
    public static Job.Status getStatus(CoordinatorJobBean coordJob) {
        Job.Status newStatus = null;
        if (coordJob != null) {
            newStatus = coordJob.getStatus();
            boolean backwardSupportForCoordStatus = ConfigUtils.isBackwardSupportForCoordStatus();
            if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1")) {
                if (coordJob.getStatus() == Job.Status.DONEWITHERROR) {
                    newStatus = Job.Status.SUCCEEDED;
                } else if (coordJob.getStatus() == Job.Status.PAUSED || coordJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
                    newStatus = Job.Status.RUNNING;
                } else if ((coordJob.getStatus() == Job.Status.RUNNING || coordJob.getStatus() == Job.Status.RUNNINGWITHERROR) && coordJob.isDoneMaterialization()) {
                    newStatus = Job.Status.SUCCEEDED;
                } else if (coordJob.getStatus() == Job.Status.PREPSUSPENDED) {
                    newStatus = Job.Status.SUSPENDED;
                } else if (coordJob.getStatus() == Job.Status.PREPPAUSED) {
                    newStatus = Job.Status.PREP;
                }
            }
        }
        return newStatus;
    }

    public static Job.Status getStatusForCoordRerun(CoordinatorJobBean coordJob, Job.Status prevStatus) {
        Job.Status newStatus = null;
        if (coordJob != null) {
            newStatus = coordJob.getStatus();
            boolean backwardSupportForCoordStatus = ConfigUtils.isBackwardSupportForCoordStatus();
            if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1")) {
                if (prevStatus == Job.Status.SUSPENDED) {
                    newStatus = Job.Status.SUSPENDED;
                } else if (coordJob.isDoneMaterialization() || prevStatus == Job.Status.SUCCEEDED) {
                    newStatus = Job.Status.SUCCEEDED;
                    coordJob.setDoneMaterialization();
                }
            }
        }
        return newStatus;
    }

    public static boolean getStatusForCoordActionInputCheck(CoordinatorJobBean coordJob) {
        boolean backwardSupportForCoordStatus;
        boolean ret = false;
        if (coordJob != null && (backwardSupportForCoordStatus = ConfigUtils.isBackwardSupportForCoordStatus()) && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1")) {
            if (coordJob.getStatus() == Job.Status.SUCCEEDED) {
                ret = true;
            } else if (coordJob.getStatus() == Job.Status.SUSPENDED) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean isV1CoordjobKillable(CoordinatorJobBean coordJob) {
        boolean ret = false;
        if (coordJob != null) {
            Configuration conf = Services.get().getConf();
            boolean backwardSupportForCoordStatus = ConfigUtils.isBackwardSupportForCoordStatus();
            if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1") && coordJob.getStatus() == Job.Status.SUCCEEDED) {
                ret = true;
            }
        }
        return ret;
    }

    public static Job.Status getStatusIfBackwardSupportTrue(Job.Status currentJobStatus) {
        Job.Status newStatus = currentJobStatus;
        boolean backwardSupportForStatesWithoutError = ConfigurationService.getBoolean("oozie.service.StatusTransitService.backward.support.for.states.without.error");
        if (backwardSupportForStatesWithoutError) {
            if (currentJobStatus == Job.Status.PAUSEDWITHERROR) {
                newStatus = Job.Status.PAUSED;
            } else if (currentJobStatus == Job.Status.SUSPENDEDWITHERROR) {
                newStatus = Job.Status.SUSPENDED;
            } else if (currentJobStatus == Job.Status.RUNNINGWITHERROR) {
                newStatus = Job.Status.RUNNING;
            }
        }
        return newStatus;
    }
}

