/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td.options;

import java.lang.reflect.Method;
import org.apache.connectors.td.options.Option;
import org.apache.connectors.td.options.ParameterValidationException;
import org.apache.connectors.td.options.SetupException;
import org.apache.hadoop.conf.Configuration;

public class DefaultOption
implements Option {
    private String name;
    private String value;
    private String defaultValue;
    private boolean optional;
    private boolean isSet = false;
    private Class configurationClass;
    private String configMethod;

    public DefaultOption(String name, String defaultValue, boolean optional, Class configurationClass, String configMethod) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.optional = optional;
        this.configurationClass = configurationClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        if (this.isSet) {
            return this.value;
        }
        if (!this.optional) {
            return this.defaultValue;
        }
        return null;
    }

    @Override
    public void setValue(String value) throws ParameterValidationException {
        if (!this.isValid(value)) {
            throw new ParameterValidationException(this.getName() + " was set to " + value + " which is an invalid value.");
        }
        this.isSet = true;
        this.value = value;
    }

    public boolean isValid(String value) {
        return true;
    }

    protected String getConfigMethod() {
        return this.configMethod;
    }

    protected Class getConfigClass() {
        return this.configurationClass;
    }

    @Override
    public void configure(Configuration confObj) throws SetupException {
        if (this.getValue() != null) {
            try {
                Method method = this.getConfigClass().getMethod(this.getConfigMethod(), this.getConfigClass());
                Object object = method.invoke(null, confObj, this.getValue());
            }
            catch (Exception e) {
                throw new SetupException("Config could not find method " + this.getConfigMethod() + " in " + this.getConfigClass().getCanonicalName(), e);
            }
        }
    }

    @Override
    public boolean hasValue() {
        return this.isSet || !this.optional;
    }
}

