/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.job.entries.google.bigquery;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="GoogleBigQueryStorageLoad", name="GoogleBigQueryStorageLoad.Name", description="GoogleBigQueryStorageLoad.TooltipDesc", image="google-bigquery.svg", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.itfactory.kettle.job.entries.bigqueryloader", documentationUrl="GoogleBigQueryStorageLoad.DocumentationURL", casesUrl="GoogleBigQueryStorageLoad.CasesURL", forumUrl="GoogleBigQueryStorageLoad.ForumURL")
public class JobEntryBigQueryLoader
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryBigQueryLoader.class;
    public static final String TYPE_JSON = "JSON";
    public static final String TYPE_CSV = "CSV";
    public static final String TYPE_AVRO = "Avro";
    private String datasetName = null;
    private String tableName = null;
    private String sourceUri = null;
    private String fileType = "CSV";
    private String delimiter = ",";
    private String quote = "";
    private String leadingRowsToSkip = "1";
    private boolean truncateTable = false;
    private Map<String, String> tableFields;
    private String[] fieldNames = new String[0];
    private String[] fieldTypes = new String[0];
    BigQuery bigQuery;

    public JobEntryBigQueryLoader() {
        super("BigQueryLoader", "Loads Google Cloud Storage files in to Google BigQuery");
        this.tableFields = new HashMap<String, String>();
    }

    public JobEntryBigQueryLoader(String name) {
        super(name, "Loads Google Cloud Storage files in to Google BigQuery");
        this.tableFields = new HashMap<String, String>();
    }

    public Object clone() {
        JobEntryBigQueryLoader je = (JobEntryBigQueryLoader)super.clone();
        return je;
    }

    public String getDialogClassName() {
        return "com.pentaho.di.ui.job.entries.google.bigquery.JobEntryBigQueryLoaderDialog";
    }

    public boolean evaluates() {
        return true;
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(650);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"datasetName", (String)this.datasetName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tableName", (String)this.tableName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sourceUri", (String)this.sourceUri));
        retval.append("      ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        retval.append("      ").append(XMLHandler.addTagValue((String)"quote", (String)this.quote));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fileType", (String)this.fileType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"leadingRowsToSkip", (String)this.leadingRowsToSkip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"truncateTable", (boolean)this.truncateTable));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldNames[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.fieldTypes[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.datasetName = XMLHandler.getTagValue((Node)entrynode, (String)"datasetName");
            this.tableName = XMLHandler.getTagValue((Node)entrynode, (String)"tableName");
            this.sourceUri = XMLHandler.getTagValue((Node)entrynode, (String)"sourceUri");
            String d = XMLHandler.getTagValue((Node)entrynode, (String)"delimiter");
            this.delimiter = null == d ? "," : d;
            String q = XMLHandler.getTagValue((Node)entrynode, (String)"quote");
            this.quote = null == q ? "" : q;
            this.fileType = XMLHandler.getTagValue((Node)entrynode, (String)"fileType");
            this.leadingRowsToSkip = XMLHandler.getTagValue((Node)entrynode, (String)"leadingRowsToSkip");
            this.truncateTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"truncateTable"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldNames[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldTypes[i] = XMLHandler.getTagValue((Node)fnode, (String)"type");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.datasetName = rep.getJobEntryAttributeString(id_jobentry, "datasetName");
            this.tableName = rep.getJobEntryAttributeString(id_jobentry, "tableName");
            this.sourceUri = rep.getJobEntryAttributeString(id_jobentry, "sourceUri");
            this.delimiter = rep.getJobEntryAttributeString(id_jobentry, "delimiter");
            this.quote = rep.getJobEntryAttributeString(id_jobentry, "quote");
            this.fileType = rep.getJobEntryAttributeString(id_jobentry, "fileType");
            this.leadingRowsToSkip = rep.getJobEntryAttributeString(id_jobentry, "leadingRowsToSkip");
            this.truncateTable = rep.getStepAttributeBoolean(id_jobentry, "truncateTable");
            int nrfields = rep.countNrStepAttributes(id_jobentry, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldNames[i] = rep.getStepAttributeString(id_jobentry, i, "field_name");
                this.fieldTypes[i] = rep.getStepAttributeString(id_jobentry, i, "field_type");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'bigQuery-gcs-load' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "datasetName", this.datasetName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tableName", this.tableName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sourceUri", this.sourceUri);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "delimiter", this.delimiter);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "quote", this.quote);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fileType", this.fileType);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "leadingRowsToSkip", this.leadingRowsToSkip);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "truncateTable", this.truncateTable);
            for (int i = 0; i < this.fieldNames.length; ++i) {
                rep.saveStepAttribute(id_job, this.getObjectId(), i, "field_name", this.fieldNames[i]);
                rep.saveStepAttribute(id_job, this.getObjectId(), i, "field_type", this.fieldTypes[i]);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'bigQuery-gcs-load' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result execute(Result previousResult, int nr) throws KettleException {
        TableId tableId;
        Table table;
        Result result;
        block19: {
            result = previousResult;
            String credentialsPath = this.parentJob.getVariable("KETTLE_GOOGLE_APPLICATION_CREDENTIALS");
            FileInputStream serviceAccountStream = null;
            if (Utils.isEmpty((CharSequence)credentialsPath)) {
                this.bigQuery = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
            } else {
                serviceAccountStream = new FileInputStream(credentialsPath);
                ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccountStream);
                this.bigQuery = (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)credentials)).setProjectId(credentials.getProjectId())).build().getService();
                IOUtils.closeQuietly((InputStream)serviceAccountStream);
            }
            break block19;
            catch (Exception e) {
                try {
                    this.bigQuery = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(serviceAccountStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)serviceAccountStream);
            }
        }
        result.setResult(false);
        result.setNrErrors(0L);
        DatasetInfo datasetInfo = Dataset.of((String)this.environmentSubstitute(this.datasetName));
        Dataset dataset = this.bigQuery.getDataset(datasetInfo.getDatasetId(), new BigQuery.DatasetOption[0]);
        if (dataset == null) {
            dataset = this.bigQuery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        }
        if ((table = this.bigQuery.getTable(tableId = TableId.of((String)dataset.getDatasetId().getDataset(), (String)this.environmentSubstitute(this.tableName)), new BigQuery.TableOption[0])) == null) {
            this.logDebug("Table not found: " + this.environmentSubstitute(this.tableName));
            this.logDebug("Creating table based on mapping specification");
            ArrayList<Field> fieldList = new ArrayList<Field>();
            int nrfields = this.getFieldNames().length;
            for (int i = 0; i < nrfields; ++i) {
                fieldList.add(Field.of((String)this.fieldNames[i], (LegacySQLTypeName)LegacySQLTypeName.valueOf((String)this.fieldTypes[i]), (Field[])new Field[0]));
            }
            Schema schema = Schema.of(fieldList);
            table = this.bigQuery.create(TableInfo.of((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)), new BigQuery.TableOption[0]);
        }
        ArrayList<String> fileList = new ArrayList<String>();
        String fileTypeString = this.environmentSubstitute(this.fileType);
        FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.sourceUri));
        boolean isFolder = false;
        try {
            isFolder = fileObject.isFolder();
            if (isFolder) {
                FileObject[] fileObjects;
                for (FileObject fileObject1 : fileObjects = fileObject.getChildren()) {
                    if (!fileObject1.getName().getExtension().equals(fileTypeString.toLowerCase())) continue;
                    fileList.add(fileObject1.getPublicURIString());
                }
            }
        }
        catch (FileSystemException fileObjects) {
            // empty catch block
        }
        if (!isFolder) {
            fileList.add(this.environmentSubstitute(this.sourceUri));
        }
        Object formatOptions = TYPE_CSV.equals(fileTypeString) ? CsvOptions.newBuilder().setFieldDelimiter(this.environmentSubstitute(this.delimiter)).setQuote(this.environmentSubstitute(this.quote)).setSkipLeadingRows((long)Integer.valueOf(this.environmentSubstitute(this.leadingRowsToSkip)).intValue()).build() : (TYPE_AVRO.equals(fileTypeString) ? FormatOptions.avro() : FormatOptions.json());
        JobInfo.WriteDisposition writeDisposition = JobInfo.WriteDisposition.WRITE_APPEND;
        if (this.truncateTable) {
            writeDisposition = JobInfo.WriteDisposition.WRITE_TRUNCATE;
        }
        LoadJobConfiguration loadConfig = LoadJobConfiguration.newBuilder((TableId)tableId, fileList, (FormatOptions)formatOptions).setWriteDisposition(writeDisposition).build();
        JobInfo jobInfo = JobInfo.of((JobConfiguration)loadConfig);
        Job loadJob = this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
        try {
            loadJob = loadJob.waitFor(new RetryOption[0]);
            if (loadJob.getStatus().getError() != null) {
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError("Error while loading table: " + loadJob.getStatus().toString());
            } else {
                result.setResult(true);
            }
        }
        catch (InterruptedException e) {
            result.setNrErrors(1L);
            result.setResult(false);
            this.logError("An error occurred executing this job entry : " + e.getMessage());
        }
        return result;
    }

    public void setDatasetName(String dsn) {
        this.datasetName = dsn;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setTableName(String tn) {
        this.tableName = tn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setSourceUri(String uri) {
        this.sourceUri = uri;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String ft) {
        this.fileType = ft;
    }

    public void setDelimiter(String delim) {
        this.delimiter = delim;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setQuote(String q) {
        this.quote = q;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setLeadingRowsToSkip(String skip) {
        this.leadingRowsToSkip = skip;
    }

    public String getLeadingRowsToSkip() {
        return this.leadingRowsToSkip;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public void setTableFields(Map<String, String> fs) {
        this.tableFields = fs;
    }

    public Map<String, String> getTableFields() {
        return this.tableFields;
    }

    public void allocate(int nrfields) {
        this.fieldNames = new String[nrfields];
        this.fieldTypes = new String[nrfields];
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(String[] fn) {
        this.fieldNames = fn;
    }

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(String[] t) {
        this.fieldTypes = t;
    }
}

