/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import java.util.List;
import org.bson.BsonDocument;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class UpdateDescription {
    private final List<String> removedFields;
    private final BsonDocument updatedFields;

    @BsonCreator
    public UpdateDescription(@BsonProperty(value="removedFields") List<String> removedFields, @BsonProperty(value="updatedFields") BsonDocument updatedFields) {
        this.removedFields = removedFields;
        this.updatedFields = updatedFields;
    }

    public List<String> getRemovedFields() {
        return this.removedFields;
    }

    public BsonDocument getUpdatedFields() {
        return this.updatedFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDescription that = (UpdateDescription)o;
        if (this.getRemovedFields() != null ? !this.getRemovedFields().equals(that.getRemovedFields()) : that.getRemovedFields() != null) {
            return false;
        }
        return !(this.getUpdatedFields() != null ? !this.getUpdatedFields().equals(that.getUpdatedFields()) : that.getUpdatedFields() != null);
    }

    public int hashCode() {
        int result = this.getRemovedFields() != null ? this.getRemovedFields().hashCode() : 0;
        result = 31 * result + (this.getUpdatedFields() != null ? this.getUpdatedFields().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UpdateDescription{removedFields=" + this.removedFields + ", updatedFields=" + this.updatedFields + "}";
    }
}

