/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rex.RexLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesNode
implements Node {
    private final Sink sink;
    private final int fieldCount;
    private final ImmutableList<Row> rows;

    public ValuesNode(Interpreter interpreter, Values rel) {
        this.sink = interpreter.sink(rel);
        this.fieldCount = rel.getRowType().getFieldCount();
        this.rows = this.createRows(interpreter, rel.getTuples());
    }

    private ImmutableList<Row> createRows(Interpreter interpreter, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        ArrayList nodes = Lists.newArrayList();
        for (ImmutableList tuple : tuples) {
            nodes.addAll(tuple);
        }
        Scalar scalar = interpreter.compile(nodes, (List<RelNode>)ImmutableList.of());
        Object[] values = new Object[nodes.size()];
        Context context = interpreter.createContext();
        scalar.execute(context, values);
        ImmutableList.Builder rows = ImmutableList.builder();
        Object[] subValues = new Object[this.fieldCount];
        for (int i = 0; i < values.length; i += this.fieldCount) {
            System.arraycopy(values, i, subValues, 0, this.fieldCount);
            rows.add((Object)Row.asCopy(subValues));
        }
        return rows.build();
    }

    @Override
    public void run() throws InterruptedException {
        for (Row row : this.rows) {
            this.sink.send(row);
        }
        this.sink.end();
    }
}

