/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class QueryCacheStats
implements Streamable,
ToXContent {
    long ramBytesUsed;
    long hitCount;
    long missCount;
    long cacheCount;
    long cacheSize;

    public QueryCacheStats() {
    }

    public QueryCacheStats(long ramBytesUsed, long hitCount, long missCount, long cacheCount, long cacheSize) {
        this.ramBytesUsed = ramBytesUsed;
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.cacheCount = cacheCount;
        this.cacheSize = cacheSize;
    }

    public void add(QueryCacheStats stats) {
        this.ramBytesUsed += stats.ramBytesUsed;
        this.hitCount += stats.hitCount;
        this.missCount += stats.missCount;
        this.cacheCount += stats.cacheCount;
        this.cacheSize += stats.cacheSize;
    }

    public long getMemorySizeInBytes() {
        return this.ramBytesUsed;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.ramBytesUsed);
    }

    public long getTotalCount() {
        return this.hitCount + this.missCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getCacheCount() {
        return this.cacheCount;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public long getEvictions() {
        return this.cacheCount - this.cacheSize;
    }

    public static QueryCacheStats readQueryCacheStats(StreamInput in) throws IOException {
        QueryCacheStats stats = new QueryCacheStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.ramBytesUsed = in.readLong();
        this.hitCount = in.readLong();
        this.missCount = in.readLong();
        this.cacheCount = in.readLong();
        this.cacheSize = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.ramBytesUsed);
        out.writeLong(this.hitCount);
        out.writeLong(this.missCount);
        out.writeLong(this.cacheCount);
        out.writeLong(this.cacheSize);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.QUERY_CACHE);
        builder.byteSizeField(Fields.MEMORY_SIZE_IN_BYTES, Fields.MEMORY_SIZE, this.ramBytesUsed);
        builder.field(Fields.TOTAL_COUNT, this.getTotalCount());
        builder.field(Fields.HIT_COUNT, this.getHitCount());
        builder.field(Fields.MISS_COUNT, this.getMissCount());
        builder.field(Fields.CACHE_SIZE, this.getCacheSize());
        builder.field(Fields.CACHE_COUNT, this.getCacheCount());
        builder.field(Fields.EVICTIONS, this.getEvictions());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString QUERY_CACHE = new XContentBuilderString("query_cache");
        static final XContentBuilderString MEMORY_SIZE = new XContentBuilderString("memory_size");
        static final XContentBuilderString MEMORY_SIZE_IN_BYTES = new XContentBuilderString("memory_size_in_bytes");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString HIT_COUNT = new XContentBuilderString("hit_count");
        static final XContentBuilderString MISS_COUNT = new XContentBuilderString("miss_count");
        static final XContentBuilderString CACHE_SIZE = new XContentBuilderString("cache_size");
        static final XContentBuilderString CACHE_COUNT = new XContentBuilderString("cache_count");
        static final XContentBuilderString EVICTIONS = new XContentBuilderString("evictions");

        Fields() {
        }
    }
}

