/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class ScriptStats
implements Streamable,
ToXContent {
    private long compilations;
    private long cacheEvictions;

    public ScriptStats() {
    }

    public ScriptStats(long compilations, long cacheEvictions) {
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
    }

    public void add(ScriptStats stats) {
        this.compilations += stats.compilations;
        this.cacheEvictions += stats.cacheEvictions;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.SCRIPT_STATS);
        builder.field(Fields.COMPILATIONS, this.getCompilations());
        builder.field(Fields.CACHE_EVICTIONS, this.getCacheEvictions());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString SCRIPT_STATS = new XContentBuilderString("script");
        static final XContentBuilderString COMPILATIONS = new XContentBuilderString("compilations");
        static final XContentBuilderString CACHE_EVICTIONS = new XContentBuilderString("cache_evictions");

        Fields() {
        }
    }
}

