/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.vfs.ui;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.URLFileName;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.vfs.messages.Messages;
import org.pentaho.vfs.ui.ComboBoxInputDialog;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.DelegatingResolver;
import org.pentaho.vfs.ui.IVfsFileChooser;
import org.pentaho.vfs.ui.TextInputDialog;
import org.pentaho.vfs.ui.VfsBrowser;
import org.pentaho.vfs.ui.VfsBrowserListener;
import org.pentaho.vfs.ui.VfsResolver;

public class VfsFileChooserDialog
implements SelectionListener,
MouseListener,
VfsBrowserListener,
IVfsFileChooser {
    private Image imgFolderUp;
    private Image imgDelete;
    private Image imgNewFolder;
    public static final int VFS_DIALOG_OPEN_FILE = 0;
    public static final int VFS_DIALOG_OPEN_DIRECTORY = 1;
    public static final int VFS_DIALOG_OPEN_FILE_OR_DIRECTORY = 2;
    public static final int VFS_DIALOG_SAVEAS = 3;
    private static final String FILE_SCHEME = "file";
    public FileObject rootFile;
    public FileObject initialFile;
    private FileObject selectedFile;
    private CustomVfsUiPanel currentPanel;
    public Text fileNameText = null;
    public String enteredFileName = "";
    public Shell dialog = null;
    Shell applicationShell = null;
    public boolean okPressed = false;
    public Button okButton = null;
    public Button cancelButton = null;
    public Label folderUpButton = null;
    public Label deleteFileButton = null;
    public Label newFolderButton = null;
    public Combo openFileCombo = null;
    public Combo fileFilterCombo = null;
    public int fileDialogMode = 0;
    public String[] fileFilters;
    public String[] fileFilterNames;
    public VfsBrowser vfsBrowser = null;
    public FileObject defaultInitialFile = null;
    public Composite customUIPanel;
    Map<Integer, CustomVfsUiPanel> customUIPanelsOrderedMap = new TreeMap<Integer, CustomVfsUiPanel>();
    Composite comboPanel;
    Combo customUIPicker;
    Shell fakeShell = new Shell();
    String initialScheme = "file";
    String[] schemeRestrictions = null;
    boolean showFileScheme = true;
    boolean showLocation;
    boolean showCustomUI = true;
    final VfsResolver resolver;
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public void addVFSUIPanel(CustomVfsUiPanel panel) {
        int orderForNewPanel = Integer.MAX_VALUE;
        while (this.customUIPanelsOrderedMap.get(orderForNewPanel) != null) {
            --orderForNewPanel;
        }
        this.addVFSUIPanel(orderForNewPanel, panel);
    }

    public void addVFSUIPanel(Integer order, CustomVfsUiPanel panel) {
        this.customUIPanelsOrderedMap.put(order, panel);
    }

    public List<CustomVfsUiPanel> getCustomVfsUiPanels() {
        return this.customUIPanelsOrderedMap.values().stream().collect(Collectors.toList());
    }

    public void createCustomUIPanel(Shell dialog) {
        this.customUIPanel = new Composite((Composite)dialog, 0);
        GridData gridData = new GridData(4, 4, true, false);
        this.customUIPanel.setLayoutData((Object)gridData);
        this.customUIPanel.setLayout((Layout)new GridLayout(1, false));
        this.comboPanel = new Composite(this.customUIPanel, 0);
        this.comboPanel.setLayoutData((Object)gridData);
        this.comboPanel.setLayout((Layout)new GridLayout(2, false));
        this.comboPanel.setData((Object)"donotremove");
        Label lookInLabel = new Label(this.comboPanel, 0);
        lookInLabel.setText(Messages.getString("VfsFileChooserDialog.LookIn"));
        gridData = new GridData(16384, 0x1000000, false, false);
        lookInLabel.setLayoutData((Object)gridData);
        this.customUIPicker = new Combo(this.comboPanel, 8);
        gridData = new GridData(16384, 0x1000000, true, false);
        this.customUIPicker.setLayoutData((Object)gridData);
        if (!this.showLocation) {
            this.comboPanel.setParent((Composite)this.fakeShell);
        }
        if (!this.showCustomUI) {
            this.customUIPanel.setParent((Composite)this.fakeShell);
        }
        this.customUIPicker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                VfsFileChooserDialog.this.selectCustomUI();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                VfsFileChooserDialog.this.selectCustomUI();
            }
        });
        this.customUIPicker.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                VfsFileChooserDialog.this.selectCustomUI();
            }

            public void keyPressed(KeyEvent arg0) {
                VfsFileChooserDialog.this.selectCustomUI();
            }
        });
        boolean createdLocal = false;
        for (CustomVfsUiPanel panel : this.getCustomVfsUiPanels()) {
            if (!panel.getVfsScheme().equals(FILE_SCHEME)) continue;
            createdLocal = true;
        }
        if (!createdLocal) {
            CustomVfsUiPanel localPanel = new CustomVfsUiPanel(FILE_SCHEME, "Local", this, 0){

                @Override
                public void activate() {
                    try {
                        File startFile = new File(System.getProperty("user.home"));
                        if (startFile == null || !startFile.exists()) {
                            startFile = File.listRoots()[0];
                        }
                        FileObject dot = VfsFileChooserDialog.this.resolver.resolveFile(startFile.toURI().toURL().toExternalForm());
                        VfsFileChooserDialog.this.rootFile = dot.getFileSystem().getRoot();
                        VfsFileChooserDialog.this.selectedFile = VfsFileChooserDialog.this.rootFile;
                        VfsFileChooserDialog.this.setInitialFile(VfsFileChooserDialog.this.selectedFile);
                        VfsFileChooserDialog.this.openFileCombo.setText(VfsFileChooserDialog.this.selectedFile.getName().getURI());
                        VfsFileChooserDialog.this.resolveVfsBrowser();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            this.addVFSUIPanel(100, localPanel);
        }
    }

    private void selectCustomUI() {
        this.hideCustomPanelChildren();
        String desiredScheme = this.customUIPicker.getText();
        for (CustomVfsUiPanel panel : this.getCustomVfsUiPanels()) {
            if (!desiredScheme.equals(panel.getVfsSchemeDisplayText())) continue;
            panel.setParent(this.customUIPanel);
            panel.activate();
            this.currentPanel = panel;
        }
        if (this.currentPanel == null) {
            this.currentPanel = this.getCustomVfsUiPanels().get(0);
            this.currentPanel.setParent(this.customUIPanel);
            this.currentPanel.activate();
        }
        this.customUIPanel.pack();
        this.dialog.layout();
    }

    private void hideCustomPanelChildren() {
        Control[] children;
        for (Control child : children = this.customUIPanel.getChildren()) {
            if (child instanceof Composite && "donotremove".equals(child.getData())) continue;
            child.setParent((Composite)this.fakeShell);
        }
        this.customUIPanel.pack();
    }

    public void populateCustomUIPanel(Shell dialog) {
        ArrayList<String> customNames = new ArrayList<String>();
        for (int i = 0; i < this.getCustomVfsUiPanels().size(); ++i) {
            CustomVfsUiPanel panel = this.getCustomVfsUiPanels().get(i);
            if (!panel.getVfsScheme().equalsIgnoreCase(FILE_SCHEME) && this.schemeRestrictions != null && !this.isRestrictedTo(panel.getVfsScheme()) || panel.getVfsScheme().equalsIgnoreCase(FILE_SCHEME) && !this.showFileScheme) continue;
            customNames.add(panel.getVfsSchemeDisplayText());
        }
        this.customUIPicker.setItems(customNames.toArray(new String[0]));
        this.hideCustomPanelChildren();
        if (customNames.size() == 0) {
            this.customUIPanel.setParent((Composite)this.fakeShell);
        } else if (customNames.size() == 1 && FILE_SCHEME.equals(customNames.get(0))) {
            this.customUIPanel.setParent((Composite)this.fakeShell);
        } else {
            int i;
            String initialSchemeDisplayText = this.initialScheme;
            for (i = 0; i < this.getCustomVfsUiPanels().size(); ++i) {
                if (!this.getCustomVfsUiPanels().get(i).getVfsScheme().equalsIgnoreCase(this.initialScheme)) continue;
                initialSchemeDisplayText = this.getCustomVfsUiPanels().get(i).getVfsSchemeDisplayText();
                break;
            }
            for (i = 0; i < this.customUIPicker.getItemCount(); ++i) {
                if (!this.customUIPicker.getItem(i).equalsIgnoreCase(initialSchemeDisplayText)) continue;
                this.customUIPicker.select(i);
                this.customUIPicker.notifyListeners(13, null);
            }
        }
    }

    private boolean isRestrictedTo(String schema) {
        boolean isRestrictedTo = false;
        if (this.schemeRestrictions != null && schema != null) {
            for (String restriction : this.schemeRestrictions) {
                if (!schema.equalsIgnoreCase(restriction)) continue;
                isRestrictedTo = true;
                break;
            }
        }
        return isRestrictedTo;
    }

    public VfsFileChooserDialog(Shell applicationShell, FileSystemManager fsm, FileObject rootFile, FileObject initialFile) {
        this(applicationShell, new DelegatingResolver(fsm), rootFile, initialFile);
    }

    public VfsFileChooserDialog(Shell applicationShell, VfsResolver resolver, FileObject rootFile, FileObject initialFile) {
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.applicationShell = applicationShell;
        this.resolver = resolver;
        this.createDialog(applicationShell);
    }

    private void createDialog(Shell applicationShell) {
        if (this.dialog == null || this.dialog.isDisposed()) {
            this.dialog = new Shell(applicationShell, 67696);
            if (applicationShell.getImage() != null) {
                this.dialog.setImage(applicationShell.getImage());
            }
            this.dialog.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    VfsFileChooserDialog.this.hideCustomPanelChildren();
                }
            });
            this.dialog.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    VfsFileChooserDialog.this.disposeImages();
                }
            });
            if (this.fileDialogMode != 3) {
                this.dialog.setText(Messages.getString("VfsFileChooserDialog.openFile"));
            } else {
                this.dialog.setText(Messages.getString("VfsFileChooserDialog.saveAs"));
            }
            this.dialog.setLayout((Layout)new GridLayout());
            this.dialog.setBackgroundMode(2);
            this.dialog.setBackground(this.dialog.getDisplay().getSystemColor(1));
            this.createCustomUIPanel(this.dialog);
        }
    }

    private void disposeImages() {
        if (this.imgFolderUp != null && !this.imgFolderUp.isDisposed()) {
            this.imgFolderUp.dispose();
        }
        if (this.imgDelete != null && !this.imgDelete.isDisposed()) {
            this.imgDelete.dispose();
        }
        if (this.imgNewFolder != null && !this.imgNewFolder.isDisposed()) {
            this.imgNewFolder.dispose();
        }
    }

    @Override
    public FileObject open(Shell applicationShell, FileObject defaultInitialFile, String fileName, String[] fileFilters, String[] fileFilterNames, int fileDialogMode) {
        return this.open(applicationShell, defaultInitialFile, fileName, fileFilters, fileFilterNames, fileDialogMode, false);
    }

    public FileObject open(Shell applicationShell, FileObject defaultInitialFile, String fileName, String[] fileFilters, String[] fileFilterNames, int fileDialogMode, boolean returnUserAuthenticatedFile) {
        this.defaultInitialFile = defaultInitialFile;
        return this.open(applicationShell, fileName, fileFilters, fileFilterNames, fileDialogMode, returnUserAuthenticatedFile);
    }

    @Override
    public FileObject open(Shell applicationShell, String fileName, String[] fileFilters, String[] fileFilterNames, int fileDialogMode) {
        return this.open(applicationShell, fileName, fileFilters, fileFilterNames, fileDialogMode, false);
    }

    public FileObject open(Shell applicationShell, String fileName, String[] fileFilters, String[] fileFilterNames, int fileDialogMode, boolean returnUserAuthenticatedFile) {
        if (this.defaultInitialFile != null && this.defaultInitialFile.getName() != null && this.defaultInitialFile.getName().getScheme() != null) {
            return this.open(applicationShell, "", this.defaultInitialFile.getName().getScheme(), true, fileName, fileFilters, fileFilterNames, fileDialogMode, returnUserAuthenticatedFile);
        }
        return this.open(applicationShell, "", FILE_SCHEME, true, fileName, fileFilters, fileFilterNames, fileDialogMode, returnUserAuthenticatedFile);
    }

    public FileObject open(Shell applicationShell, String schemeRestriction, String initialScheme, boolean showFileScheme, String fileName, String[] fileFilters, String[] fileFilterNames, int fileDialogMode) {
        return this.open(applicationShell, schemeRestriction, initialScheme, showFileScheme, fileName, fileFilters, fileFilterNames, fileDialogMode, false);
    }

    public FileObject open(Shell applicationShell, String schemeRestriction, String initialScheme, boolean showFileScheme, String fileName, String[] fileFilters, String[] fileFilterNames, int fileDialogMode, boolean returnUserAuthenticatedFile) {
        String[] restrictions = null;
        if (schemeRestriction != null && !schemeRestriction.trim().equals("")) {
            restrictions = new String[]{schemeRestriction};
        }
        return this.open(applicationShell, restrictions, initialScheme, showFileScheme, fileName, fileFilters, fileFilterNames, returnUserAuthenticatedFile, fileDialogMode);
    }

    public FileObject open(Shell applicationShell, String[] schemeRestrictions, String initialScheme, boolean showFileScheme, String fileName, String[] fileFilters, String[] fileFilterNames, boolean returnUserAuthenticatedFile, int fileDialogMode) {
        return this.open(applicationShell, schemeRestrictions, initialScheme, showFileScheme, fileName, fileFilters, fileFilterNames, returnUserAuthenticatedFile, fileDialogMode, true);
    }

    public FileObject open(Shell applicationShell, String[] schemeRestrictions, String initialScheme, boolean showFileScheme, String fileName, String[] fileFilters, String[] fileFilterNames, boolean returnUserAuthenticatedFile, int fileDialogMode, boolean showLocation) {
        return this.open(applicationShell, schemeRestrictions, initialScheme, showFileScheme, fileName, fileFilters, fileFilterNames, returnUserAuthenticatedFile, fileDialogMode, true, true);
    }

    public FileObject open(Shell applicationShell, String[] schemeRestrictions, String initialScheme, boolean showFileScheme, String fileName, String[] fileFilters, String[] fileFilterNames, boolean returnUserAuthenticatedFile, int fileDialogMode, boolean showLocation, boolean showCustomUI) {
        this.fileDialogMode = fileDialogMode;
        this.fileFilters = fileFilters;
        this.fileFilterNames = fileFilterNames;
        this.applicationShell = applicationShell;
        this.showFileScheme = showFileScheme;
        this.initialScheme = initialScheme;
        this.schemeRestrictions = schemeRestrictions;
        this.showLocation = showLocation;
        this.showCustomUI = showCustomUI;
        FileObject tmpInitialFile = this.initialFile;
        if (this.defaultInitialFile != null && this.rootFile == null) {
            try {
                this.rootFile = this.defaultInitialFile.getFileSystem().getRoot();
                this.initialFile = this.defaultInitialFile;
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        this.createDialog(applicationShell);
        if (!showLocation) {
            this.comboPanel.setParent((Composite)this.fakeShell);
        } else {
            this.comboPanel.setParent(this.customUIPanel);
        }
        if (!showCustomUI) {
            this.customUIPanel.setParent((Composite)this.fakeShell);
        } else {
            this.customUIPanel.setParent((Composite)this.dialog);
        }
        this.createToolbarPanel(this.dialog);
        this.createVfsBrowser(this.dialog);
        this.populateCustomUIPanel(this.dialog);
        if (fileDialogMode == 3) {
            this.createFileNamePanel(this.dialog, fileName);
        } else {
            this.createFileFilterPanel(this.dialog);
        }
        this.createButtonPanel(this.dialog);
        this.initialFile = tmpInitialFile;
        try {
            if (this.initialFile != null || this.rootFile != null) {
                this.vfsBrowser.selectTreeItemByFileObject(this.initialFile != null ? this.initialFile : this.rootFile, true);
                this.updateParentFileCombo(this.initialFile != null ? this.initialFile : this.rootFile);
                this.setSelectedFile(this.initialFile != null ? this.initialFile : this.rootFile);
                this.openFileCombo.setText(this.initialFile != null ? this.initialFile.getName().getFriendlyURI() : this.rootFile.getName().getFriendlyURI());
            }
        }
        catch (FileSystemException e) {
            MessageBox box = new MessageBox(this.dialog.getShell());
            box.setText(Messages.getString("VfsFileChooserDialog.error"));
            box.setMessage(e.getMessage());
            box.open();
        }
        int height = 550;
        int width = 800;
        this.dialog.setSize(width, height);
        Rectangle bounds = this.dialog.getDisplay().getPrimaryMonitor().getClientArea();
        int x = (bounds.width - width) / 2;
        int y = (bounds.height - height) / 2;
        this.dialog.setLocation(x, y);
        this.dialog.open();
        if (this.rootFile != null && fileDialogMode == 3 && !this.rootFile.getFileSystem().hasCapability(Capability.WRITE_CONTENT)) {
            MessageBox messageDialog = new MessageBox(this.dialog.getShell(), 32);
            messageDialog.setText(Messages.getString("VfsFileChooserDialog.warning"));
            messageDialog.setMessage(Messages.getString("VfsFileChooserDialog.noWriteSupport"));
            messageDialog.open();
        }
        this.vfsBrowser.fileSystemTree.forceFocus();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        if (!this.dialog.isDisposed()) {
            this.hideCustomPanelChildren();
            this.dialog.dispose();
        }
        if (this.okPressed) {
            URLFileName urlFileName;
            FileObject returnFile = this.vfsBrowser.getSelectedFileObject();
            if (returnFile != null && fileDialogMode == 3) {
                try {
                    if (returnFile.getType().equals((Object)FileType.FILE)) {
                        returnFile = returnFile.getParent();
                    }
                    returnFile = returnFile.resolveFile(this.enteredFileName);
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
            }
            if (!returnUserAuthenticatedFile && returnFile != null && returnFile.getName() instanceof URLFileName && ((urlFileName = (URLFileName)returnFile.getName()).getUserName() == null || urlFileName.getPassword() == null)) {
                int port;
                String user = "";
                String pass = "";
                UserAuthenticator userAuthenticator = DefaultFileSystemConfigBuilder.getInstance().getUserAuthenticator(returnFile.getFileSystem().getFileSystemOptions());
                if (userAuthenticator != null) {
                    UserAuthenticationData data = userAuthenticator.requestAuthentication(AUTHENTICATOR_TYPES);
                    user = String.valueOf(data.getData(UserAuthenticationData.USERNAME));
                    pass = String.valueOf(data.getData(UserAuthenticationData.PASSWORD));
                    try {
                        user = URLEncoder.encode(user, "UTF-8");
                        pass = URLEncoder.encode(pass, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                String portString = (port = urlFileName.getPort()) < 1 ? "" : ":" + port;
                String urlWithUserPass = urlFileName.getScheme() + "://" + user + ":" + pass + "@" + urlFileName.getHostName() + portString + urlFileName.getPath();
                try {
                    returnFile = this.currentPanel.resolveFile(urlWithUserPass);
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
            }
            return returnFile;
        }
        return null;
    }

    public void createButtonPanel(Shell dialog) {
        Label emptyLabel;
        Composite buttonPanel = new Composite((Composite)dialog, 0);
        GridData gridData = new GridData(4, 4, true, false);
        buttonPanel.setLayoutData((Object)gridData);
        buttonPanel.setLayout((Layout)new GridLayout(4, false));
        String buttonAlign = System.getProperty("org.pentaho.di.buttonPosition", "right").toLowerCase();
        if (!"left".equals(buttonAlign)) {
            emptyLabel = new Label(buttonPanel, 0);
            gridData = new GridData(4, 4, true, false);
            emptyLabel.setLayoutData((Object)gridData);
        }
        this.okButton = new Button(buttonPanel, 8);
        this.okButton.setText(Messages.getString("VfsFileChooserDialog.ok"));
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 90;
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.addSelectionListener((SelectionListener)this);
        this.cancelButton = new Button(buttonPanel, 8);
        this.cancelButton.setText(Messages.getString("VfsFileChooserDialog.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 90;
        this.cancelButton.setLayoutData((Object)gridData);
        if ("center".equals(buttonAlign)) {
            emptyLabel = new Label(buttonPanel, 0);
            gridData = new GridData(4, 4, true, false);
            emptyLabel.setLayoutData((Object)gridData);
        }
    }

    public void createFileFilterPanel(Shell dialog) {
        Composite filterPanel = new Composite((Composite)dialog, 0);
        GridData gridData = new GridData(4, 4, true, false);
        filterPanel.setLayoutData((Object)gridData);
        filterPanel.setLayout((Layout)new GridLayout(3, false));
        Label filterLabel = new Label(filterPanel, 0);
        filterLabel.setText(Messages.getString("VfsFileChooserDialog.filter"));
        gridData = new GridData(4, 0x1000000, false, false);
        filterLabel.setLayoutData((Object)gridData);
        this.fileFilterCombo = new Combo(filterPanel, 8);
        gridData = new GridData(4, 4, true, false);
        this.fileFilterCombo.setLayoutData((Object)gridData);
        this.fileFilterCombo.setItems(this.fileFilterNames);
        this.fileFilterCombo.addSelectionListener((SelectionListener)this);
        this.fileFilterCombo.select(0);
    }

    public void createFileNamePanel(Shell dialog, String fileName) {
        Composite fileNamePanel = new Composite((Composite)dialog, 0);
        GridData gridData = new GridData(4, 4, true, false);
        fileNamePanel.setLayoutData((Object)gridData);
        fileNamePanel.setLayout((Layout)new GridLayout(2, false));
        Label fileNameLabel = new Label(fileNamePanel, 0);
        fileNameLabel.setText(Messages.getString("VfsFileChooserDialog.fileName"));
        gridData = new GridData(4, 0x1000000, false, false);
        fileNameLabel.setLayoutData((Object)gridData);
        this.fileNameText = new Text(fileNamePanel, 2048);
        if (fileName != null) {
            this.fileNameText.setText(fileName);
        }
        gridData = new GridData(4, 0x1000000, true, false);
        this.fileNameText.setLayoutData((Object)gridData);
        this.fileNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    VfsFileChooserDialog.this.okPressed();
                }
            }
        });
    }

    public void createVfsBrowser(Shell dialog) {
        String defaultFilter = null;
        if (this.fileFilters != null && this.fileFilters.length > 0) {
            defaultFilter = this.fileFilters[0];
        }
        this.vfsBrowser = new VfsBrowser((Composite)dialog, 0, this.rootFile, defaultFilter, this.fileDialogMode == 3, false);
        this.vfsBrowser.addVfsBrowserListener(this);
        GridData gridData = new GridData(4, 4, true, true);
        this.vfsBrowser.setLayoutData(gridData);
    }

    public void createToolbarPanel(Shell dialog) {
        Composite chooserToolbarPanel = new Composite((Composite)dialog, 0);
        chooserToolbarPanel.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        chooserToolbarPanel.setLayoutData((Object)gridData);
        Label parentFoldersLabel = new Label(chooserToolbarPanel, 0);
        if (this.fileDialogMode != 3) {
            parentFoldersLabel.setText(Messages.getString("VfsFileChooserDialog.openFromFolder"));
        } else {
            parentFoldersLabel.setText(Messages.getString("VfsFileChooserDialog.saveInFolder"));
        }
        gridData = new GridData(4, 0x1000000, false, false);
        parentFoldersLabel.setLayoutData((Object)gridData);
        this.openFileCombo = new Combo(chooserToolbarPanel, 2048);
        gridData = new GridData(4, 0x1000000, true, false);
        this.openFileCombo.setLayoutData((Object)gridData);
        this.openFileCombo.addSelectionListener((SelectionListener)this);
        this.openFileCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000001 && (event.stateMask & 0x40000) == 0 && (event.stateMask & 0x10000) == 0) {
                    VfsFileChooserDialog.this.resolveVfsBrowser();
                    VfsFileChooserDialog.this.vfsBrowser.selectPreviousItem();
                }
                if (event.keyCode == 0x1000002 && (event.stateMask & 0x40000) == 0 && (event.stateMask & 0x10000) == 0) {
                    VfsFileChooserDialog.this.resolveVfsBrowser();
                    VfsFileChooserDialog.this.vfsBrowser.selectNextItem();
                }
            }

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    try {
                        FileObject newRoot = VfsFileChooserDialog.this.currentPanel.resolveFile(VfsFileChooserDialog.this.openFileCombo.getText());
                        VfsFileChooserDialog.this.vfsBrowser.resetVfsRoot(newRoot);
                    }
                    catch (FileSystemException e) {
                        MessageBox errorDialog = new MessageBox(VfsFileChooserDialog.this.vfsBrowser.getDisplay().getActiveShell(), 32);
                        errorDialog.setText(Messages.getString("VfsFileChooserDialog.error"));
                        errorDialog.setMessage(e.getMessage());
                        errorDialog.open();
                    }
                }
            }
        });
        this.folderUpButton = new Label(chooserToolbarPanel, 0);
        this.folderUpButton.setToolTipText(Messages.getString("VfsFileChooserDialog.upOneLevel"));
        this.folderUpButton.setImage(this.getFolderUpImage(chooserToolbarPanel.getDisplay()));
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.folderUpButton.setLayoutData((Object)gridData);
        this.folderUpButton.addMouseListener((MouseListener)this);
        this.deleteFileButton = new Label(chooserToolbarPanel, 0);
        this.deleteFileButton.setToolTipText(Messages.getString("VfsFileChooserDialog.deleteFile"));
        this.deleteFileButton.setImage(this.getDeleteImage(chooserToolbarPanel.getDisplay()));
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.deleteFileButton.setLayoutData((Object)gridData);
        this.deleteFileButton.addMouseListener((MouseListener)this);
        this.newFolderButton = new Label(chooserToolbarPanel, 0);
        this.newFolderButton.setToolTipText(Messages.getString("VfsFileChooserDialog.createNewFolder"));
        this.newFolderButton.setImage(this.getNewFolderImage(chooserToolbarPanel.getDisplay()));
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        this.newFolderButton.setLayoutData((Object)gridData);
        this.newFolderButton.addMouseListener((MouseListener)this);
    }

    public void okPressed() {
        if (this.fileDialogMode == 3 && "".equals(this.fileNameText.getText())) {
            MessageBox messageDialog = new MessageBox(this.dialog, 32);
            messageDialog.setText(Messages.getString("VfsFileChooserDialog.error"));
            messageDialog.setMessage(Messages.getString("VfsFileChooserDialog.noFilenameEntered"));
            messageDialog.open();
            return;
        }
        if (this.fileDialogMode == 3) {
            try {
                FileObject toBeSavedFile = this.vfsBrowser.getSelectedFileObject().resolveFile(this.fileNameText.getText());
                if (toBeSavedFile.exists()) {
                    MessageBox messageDialog = new MessageBox(this.dialog, 192);
                    messageDialog.setText(Messages.getString("VfsFileChooserDialog.fileExists"));
                    messageDialog.setMessage(Messages.getString("VfsFileChooserDialog.fileExistsOverwrite"));
                    int flag = messageDialog.open();
                    if (flag == 128) {
                        return;
                    }
                }
            }
            catch (FileSystemException e) {
                e.printStackTrace();
            }
        }
        if (this.fileDialogMode == 3) {
            this.enteredFileName = this.fileNameText.getText();
        }
        try {
            if (this.fileDialogMode == 0 && this.vfsBrowser.getSelectedFileObject().getType().equals((Object)FileType.FOLDER)) {
                this.vfsBrowser.selectTreeItemByFileObject(this.vfsBrowser.getSelectedFileObject(), true);
                return;
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        this.okPressed = true;
        this.hideCustomPanelChildren();
        this.dialog.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent se) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.openFileCombo) {
            try {
                FileObject newRoot = this.currentPanel.resolveFile(this.getSelectedFile().getName().getURI());
                this.vfsBrowser.resetVfsRoot(newRoot);
            }
            catch (FileSystemException e) {
                e.printStackTrace();
            }
        } else if (se.widget == this.okButton) {
            this.okPressed();
        } else if (se.widget == this.fileFilterCombo) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String filter = VfsFileChooserDialog.this.fileFilters[VfsFileChooserDialog.this.fileFilterCombo.getSelectionIndex()];
                    VfsFileChooserDialog.this.vfsBrowser.setFilter(filter);
                    try {
                        VfsFileChooserDialog.this.vfsBrowser.applyFilter();
                    }
                    catch (FileSystemException e) {
                        MessageBox mb = new MessageBox(VfsFileChooserDialog.this.newFolderButton.getShell(), 32);
                        mb.setText(Messages.getString("VfsFileChooserDialog.errorApplyFilter"));
                        mb.setMessage(e.getMessage());
                        mb.open();
                    }
                }
            };
            BusyIndicator.showWhile((Display)this.fileFilterCombo.getDisplay(), (Runnable)r);
        } else {
            this.okPressed = false;
            this.hideCustomPanelChildren();
            this.dialog.dispose();
        }
    }

    public void mouseDown(MouseEvent se) {
        if (se.widget == this.folderUpButton) {
            try {
                FileObject newRoot = this.vfsBrowser.getSelectedFileObject().getParent();
                if (newRoot != null) {
                    this.vfsBrowser.resetVfsRoot(newRoot);
                    this.vfsBrowser.setSelectedFileObject(newRoot);
                    this.openFileCombo.setText(newRoot.getName().getFriendlyURI());
                }
            }
            catch (Exception newRoot) {}
        } else if (se.widget == this.newFolderButton) {
            this.promptForNewFolder();
        } else if (se.widget == this.deleteFileButton) {
            MessageBox messageDialog = new MessageBox(se.widget.getDisplay().getActiveShell(), 192);
            messageDialog.setText(Messages.getString("VfsFileChooserDialog.confirm"));
            messageDialog.setMessage(Messages.getString("VfsFileChooserDialog.deleteFile"));
            int status = messageDialog.open();
            if (status == 64) {
                try {
                    this.vfsBrowser.deleteSelectedItem();
                }
                catch (FileSystemException e) {
                    MessageBox errorDialog = new MessageBox(se.widget.getDisplay().getActiveShell(), 32);
                    errorDialog.setText(Messages.getString("VfsFileChooserDialog.error"));
                    errorDialog.setMessage(e.getMessage());
                    errorDialog.open();
                }
            }
        }
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void promptForNewFolder() {
        String defaultText;
        boolean done = false;
        String text = defaultText = "New Folder";
        while (!done) {
            TextInputDialog textDialog;
            if (text == null) {
                text = defaultText;
            }
            if ((text = (textDialog = new TextInputDialog(Messages.getString("VfsBrowser.enterNewFolderName"), text, 500, 160)).open()) != null && !"".equals(text)) {
                try {
                    this.vfsBrowser.createFolder(text);
                    done = true;
                }
                catch (FileSystemException e) {
                    MessageBox errorDialog = new MessageBox(this.newFolderButton.getShell(), 32);
                    errorDialog.setText(Messages.getString("VfsBrowser.error"));
                    if (e.getCause() != null) {
                        errorDialog.setMessage(e.getCause().getMessage());
                    } else {
                        errorDialog.setMessage(e.getMessage());
                    }
                    errorDialog.open();
                }
                continue;
            }
            done = true;
        }
    }

    public void promptForNewVfsRoot() {
        String defaultText;
        boolean done = false;
        String text = defaultText = this.vfsBrowser.rootFileObject.getName().getURI();
        while (!done) {
            if (text == null) {
                text = defaultText;
            }
            File[] fileRoots = File.listRoots();
            String[] roots = new String[fileRoots.length];
            for (int i = 0; i < roots.length; ++i) {
                try {
                    roots[i] = fileRoots[i].toURI().toURL().toExternalForm();
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ComboBoxInputDialog textDialog = new ComboBoxInputDialog(Messages.getString("VfsFileChooserDialog.enterNewVFSRoot"), text, roots, 650, 100);
            text = textDialog.open();
            if (text != null && !"".equals(text)) {
                try {
                    this.vfsBrowser.resetVfsRoot(this.currentPanel.resolveFile(text));
                    done = true;
                }
                catch (FileSystemException e) {
                    MessageBox errorDialog = new MessageBox(this.vfsBrowser.getDisplay().getActiveShell(), 32);
                    errorDialog.setText(Messages.getString("VfsFileChooserDialog.error"));
                    errorDialog.setMessage(e.getMessage());
                    errorDialog.open();
                }
                continue;
            }
            done = true;
        }
    }

    public void updateParentFileCombo(FileObject selectedItem) {
        try {
            ArrayList<FileObject> parentChain = new ArrayList<FileObject>();
            try {
                if (selectedItem.getType() == FileType.FOLDER && selectedItem.getType().hasChildren()) {
                    parentChain.add(selectedItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (FileObject parentFileObject = selectedItem.getParent(); parentFileObject != null; parentFileObject = parentFileObject.getParent()) {
                parentChain.add(parentFileObject);
            }
            File[] roots = File.listRoots();
            if (this.currentPanel != null) {
                for (int i = 0; i < roots.length; ++i) {
                    parentChain.add(this.currentPanel.resolveFile(roots[i].getAbsolutePath()));
                }
            }
            String[] items = new String[parentChain.size()];
            int idx = 0;
            for (int i = parentChain.size() - 1; i >= 0; --i) {
                items[idx++] = ((FileObject)parentChain.get(i)).getName().getFriendlyURI();
            }
            this.openFileCombo.setItems(items);
            this.openFileCombo.select(items.length - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fireFileObjectDoubleClicked(FileObject selectedItem) {
        if (this.fileDialogMode != 3) {
            String scheme = null;
            if (selectedItem.getName().getExtension().contains("jar")) {
                scheme = "jar:";
            } else if (selectedItem.getName().getExtension().contains("zip")) {
                scheme = "zip:";
            } else if (selectedItem.getName().getExtension().contains("gz")) {
                scheme = "gz:";
            } else if (selectedItem.getName().getExtension().contains("war")) {
                scheme = "war:";
            } else if (selectedItem.getName().getExtension().contains("ear")) {
                scheme = "ear:";
            } else if (selectedItem.getName().getExtension().contains("sar")) {
                scheme = "sar:";
            } else if (selectedItem.getName().getExtension().contains("tar")) {
                scheme = "tar:";
            } else if (selectedItem.getName().getExtension().contains("tbz2")) {
                scheme = "tbz2:";
            } else if (selectedItem.getName().getExtension().contains("tgz")) {
                scheme = "tgz:";
            } else if (selectedItem.getName().getExtension().contains("bz2")) {
                scheme = "bz2:";
            }
            if (scheme != null) {
                try {
                    FileObject jarFileObject = selectedItem.getFileSystem().getFileSystemManager().resolveFile(scheme + selectedItem.getName().getURI());
                    this.vfsBrowser.resetVfsRoot(jarFileObject);
                    this.updateParentFileCombo(jarFileObject);
                    this.vfsBrowser.fileSystemTree.forceFocus();
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                    this.okPressed = true;
                    this.hideCustomPanelChildren();
                    this.dialog.dispose();
                }
            } else {
                this.okPressed = true;
                this.hideCustomPanelChildren();
                this.dialog.dispose();
            }
        }
    }

    @Override
    public void fireFileObjectSelected(FileObject selectedItem) {
        this.updateParentFileCombo(selectedItem);
    }

    public void resolveVfsBrowser() {
        FileObject newRoot = null;
        try {
            if (this.currentPanel != null) {
                newRoot = this.currentPanel.resolveFile(this.getSelectedFile().getName().getURI());
            }
        }
        catch (FileSystemException e) {
            this.displayMessageBox(32, Messages.getString("VfsFileChooserDialog.error"), e.getMessage());
        }
        if (newRoot != null) {
            this.vfsBrowser.resetVfsRoot(newRoot);
        }
    }

    private void displayMessageBox(int widgetArguments, String title, String message) {
        MessageBox errorDialog = new MessageBox(this.vfsBrowser.getDisplay().getActiveShell(), widgetArguments);
        errorDialog.setText(title);
        errorDialog.setMessage(message);
        errorDialog.open();
    }

    public FileObject getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(FileObject rootFile) {
        this.rootFile = rootFile;
    }

    public FileObject getInitialFile() {
        return this.initialFile;
    }

    public void setInitialFile(FileObject initialFile) {
        this.initialFile = initialFile;
    }

    public FileObject getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(FileObject selectedFile) {
        this.selectedFile = selectedFile;
        if (selectedFile != null) {
            this.openFileCombo.setText(selectedFile.getName().getFriendlyURI());
            this.resolveVfsBrowser();
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        CustomVfsUiPanel panel = this.getPanelFromFileUri(fileUri);
        if (panel != null) {
            if (opts == null) {
                return panel.resolveFile(fileUri);
            }
            return panel.resolveFile(fileUri, opts);
        }
        return null;
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        return this.resolveFile(fileUri, null);
    }

    private CustomVfsUiPanel getPanelFromFileUri(String fileUri) {
        if (this.getCustomVfsUiPanels() != null) {
            for (CustomVfsUiPanel panel : this.getCustomVfsUiPanels()) {
                if (!fileUri.startsWith(panel.getVfsScheme())) continue;
                return panel;
            }
        }
        return null;
    }

    public Composite getCustomUIPanel() {
        return this.customUIPanel;
    }

    public void setCustomUIPanel(Composite customUIPanel) {
        this.customUIPanel = customUIPanel;
    }

    private Image getFolderUpImage(Display display) {
        if (this.imgFolderUp == null || this.imgFolderUp.isDisposed()) {
            this.imgFolderUp = new Image((Device)display, this.getClass().getResourceAsStream("/icons/folderup.png"));
        }
        return this.imgFolderUp;
    }

    private Image getDeleteImage(Display display) {
        if (this.imgDelete == null || this.imgDelete.isDisposed()) {
            this.imgDelete = new Image((Device)display, this.getClass().getResourceAsStream("/icons/generic-delete.png"));
        }
        return this.imgDelete;
    }

    private Image getNewFolderImage(Display display) {
        if (this.imgNewFolder == null || this.imgNewFolder.isDisposed()) {
            this.imgNewFolder = new Image((Device)display, this.getClass().getResourceAsStream("/icons/Add.png"));
        }
        return this.imgNewFolder;
    }

    public CustomVfsUiPanel getCurrentPanel() {
        return this.currentPanel;
    }
}

