/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.ws.MQTTSocket;
import org.apache.activemq.transport.ws.StompSocket;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;

public class WSServlet
extends WebSocketServlet {
    private static final long serialVersionUID = -4716657876092884139L;
    private TransportAcceptListener listener;

    public void init() throws ServletException {
        super.init();
        this.listener = (TransportAcceptListener)this.getServletContext().getAttribute("acceptListener");
        if (this.listener == null) {
            throw new ServletException("No such attribute 'acceptListener' available in the ServletContext");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        TransportSupport socket = protocol != null && protocol.startsWith("mqtt") ? new MQTTSocket() : new StompSocket();
        this.listener.onAccept(socket);
        return socket;
    }
}

