/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hdfs;

import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemCallable;
import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemImpl;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemFactory;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemFactoryImpl
implements HadoopFileSystemFactory {
    public static final String SHIM_IDENTIFIER = "shim.identifier";
    public static final String HDFS = "hdfs";
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileSystemFactoryImpl.class);
    private final boolean isActiveConfiguration;
    private final HadoopConfiguration hadoopConfiguration;

    public HadoopFileSystemFactoryImpl(boolean isActiveConfiguration, HadoopConfiguration hadoopConfiguration, String scheme) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        String shimIdentifier = namedCluster.getShimIdentifier();
        return shimIdentifier == null && this.isActiveConfiguration && !namedCluster.isUseGateway() || this.hadoopConfiguration.getIdentifier().equals(shimIdentifier) && !namedCluster.isUseGateway();
    }

    public HadoopFileSystem create(NamedCluster namedCluster) throws IOException {
        return this.create(namedCluster, null);
    }

    public HadoopFileSystem create(NamedCluster namedCluster, URI uri) throws IOException {
        Configuration configuration;
        final URI finalUri = uri != null ? uri : URI.create("");
        final HadoopShim hadoopShim = this.hadoopConfiguration.getHadoopShim();
        FileSystem fileSystem = (FileSystem)hadoopShim.getFileSystem(configuration = hadoopShim.createConfiguration()).getDelegate();
        if (fileSystem instanceof LocalFileSystem) {
            LOGGER.error("Got a local filesystem, was expecting an hdfs connection");
            throw new IOException("Got a local filesystem, was expecting an hdfs connection");
        }
        return new HadoopFileSystemImpl(new HadoopFileSystemCallable(){

            @Override
            public FileSystem getFileSystem() {
                try {
                    return (FileSystem)hadoopShim.getFileSystem(finalUri, configuration, null).getDelegate();
                }
                catch (IOException e) {
                    LOGGER.debug("Error looking up/creating the file system ", (Throwable)e);
                    return null;
                }
                catch (InterruptedException e) {
                    LOGGER.debug("Error looking up/creating the file system ", (Throwable)e);
                    return null;
                }
            }
        });
    }
}

