/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.jcr.DefaultPermissionConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.IAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityRolePrincipal;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityUserPrincipal;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.util.Assert;

public class JcrRepositoryFileAclDao
implements IRepositoryFileAclDao {
    private static final Log logger = LogFactory.getLog(JcrRepositoryFileAclDao.class);
    private JcrTemplate jcrTemplate;
    private IPathConversionHelper pathConversionHelper;
    private String tenantAdminAuthorityName;

    public JcrRepositoryFileAclDao(JcrTemplate jcrTemplate, IPathConversionHelper pathConversionHelper, String tenantAdminAuthorityName) {
        this.jcrTemplate = jcrTemplate;
        this.pathConversionHelper = pathConversionHelper;
        this.tenantAdminAuthorityName = tenantAdminAuthorityName;
    }

    @Override
    public List<RepositoryFileAce> getEffectiveAces(final Serializable id, final boolean forceEntriesInheriting) {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                AccessControlPolicy[] acPolicies;
                Node node = session.getNodeByIdentifier(id.toString());
                if (node == null) {
                    throw new RepositoryException(Messages.getInstance().getString("JackrabbitRepositoryFileAclDao.ERROR_0001_NODE_NOT_FOUND", new Object[]{id.toString()}));
                }
                if (forceEntriesInheriting && session.getNodeByIdentifier(id.toString()).getParent() != null) {
                    node = node.getParent();
                }
                String absPath = node.getPath();
                for (AccessControlPolicy policy : acPolicies = session.getAccessControlManager().getEffectivePolicies(absPath)) {
                    Assert.isTrue((boolean)(policy instanceof AccessControlList));
                    AccessControlList acList = (AccessControlList)policy;
                    if (JcrRepositoryFileAclDao.this.isEntriesInheriting(session, absPath, acList)) continue;
                    ArrayList<RepositoryFileAce> aces = new ArrayList<RepositoryFileAce>();
                    AccessControlEntry[] acEntries = acList.getAccessControlEntries();
                    List<AccessControlEntry> cleanedAcEntries = JcrRepositoryFileAclUtils.removeAclMetadata(Arrays.asList(acEntries));
                    for (AccessControlEntry acEntry : cleanedAcEntries) {
                        if (acEntry.getPrincipal().equals(new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(JcrRepositoryFileAclDao.this.tenantAdminAuthorityName)))) continue;
                        aces.add(JcrRepositoryFileAclDao.this.toAce(session, acEntry));
                    }
                    return aces;
                }
                AccessControlList acList = (AccessControlList)acPolicies[acPolicies.length - 1];
                ArrayList<RepositoryFileAce> aces = new ArrayList<RepositoryFileAce>();
                AccessControlEntry[] acEntries = acList.getAccessControlEntries();
                List<AccessControlEntry> cleanedAcEntries = JcrRepositoryFileAclUtils.removeAclMetadata(Arrays.asList(acEntries));
                for (AccessControlEntry acEntry : cleanedAcEntries) {
                    if (acEntry.getPrincipal().equals(new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(JcrRepositoryFileAclDao.this.tenantAdminAuthorityName)))) continue;
                    aces.add(JcrRepositoryFileAclDao.this.toAce(session, acEntry));
                }
                return aces;
            }
        });
    }

    protected String getOwner(Session session, String path, AccessControlList acList) throws RepositoryException {
        IAclMetadataStrategy.AclMetadata aclMetadata = JcrRepositoryFileAclUtils.getAclMetadata(session, path, acList);
        if (aclMetadata != null) {
            return aclMetadata.getOwner();
        }
        return null;
    }

    protected boolean isEntriesInheriting(Session session, String path, AccessControlList acList) throws RepositoryException {
        IAclMetadataStrategy.AclMetadata aclMetadata = JcrRepositoryFileAclUtils.getAclMetadata(session, path, acList);
        if (aclMetadata != null) {
            return aclMetadata.isEntriesInheriting();
        }
        return false;
    }

    @Override
    public boolean hasAccess(final String relPath, final EnumSet<RepositoryFilePermission> permissions) {
        return (Boolean)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                DefaultPermissionConversionHelper permissionConversionHelper = new DefaultPermissionConversionHelper(session);
                Privilege[] privs = permissionConversionHelper.pentahoPermissionsToPrivileges(session, permissions);
                try {
                    String absPath = JcrRepositoryFileAclDao.this.pathConversionHelper.relToAbs(relPath);
                    return session.getAccessControlManager().hasPrivileges(JcrStringHelper.pathEncode(absPath), privs);
                }
                catch (PathNotFoundException e) {
                    return false;
                }
            }
        });
    }

    private RepositoryFileAcl toAcl(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable id) throws RepositoryException {
        Node node = session.getNodeByIdentifier(id.toString());
        if (node == null) {
            throw new RepositoryException(Messages.getInstance().getString("JackrabbitRepositoryFileAclDao.ERROR_0001_NODE_NOT_FOUND", new Object[]{id.toString()}));
        }
        String absPath = node.getPath();
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlList acList = this.getAccessControlList(acMgr, absPath);
        RepositoryFileSid owner = null;
        String ownerString = this.getOwner(session, absPath, acList);
        if (ownerString != null) {
            owner = new RepositoryFileSid(JcrTenantUtils.getUserNameUtils().getPrincipleName(ownerString), RepositoryFileSid.Type.USER);
        }
        RepositoryFileAcl.Builder aclBuilder = new RepositoryFileAcl.Builder(id, owner);
        aclBuilder.entriesInheriting(this.isEntriesInheriting(session, absPath, acList));
        List<AccessControlEntry> cleanedAcEntries = JcrRepositoryFileAclUtils.removeAclMetadata(Arrays.asList(acList.getAccessControlEntries()));
        for (AccessControlEntry acEntry : cleanedAcEntries) {
            if (acEntry.getPrincipal().equals(new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(this.tenantAdminAuthorityName)))) continue;
            aclBuilder.ace(this.toAce(session, acEntry));
        }
        return aclBuilder.build();
    }

    protected RepositoryFileAce toAce(Session session, AccessControlEntry acEntry) throws RepositoryException {
        Principal principal = acEntry.getPrincipal();
        RepositoryFileSid sid = null;
        String name = principal.getName();
        DefaultPermissionConversionHelper permissionConversionHelper = new DefaultPermissionConversionHelper(session);
        sid = principal instanceof Group ? new RepositoryFileSid(JcrTenantUtils.getRoleNameUtils().getPrincipleName(name), RepositoryFileSid.Type.ROLE) : new RepositoryFileSid(JcrTenantUtils.getUserNameUtils().getPrincipleName(name), RepositoryFileSid.Type.USER);
        logger.debug((Object)String.format("principal class [%s]", principal.getClass().getName()));
        Privilege[] privileges = acEntry.getPrivileges();
        return new RepositoryFileAce(sid, permissionConversionHelper.privilegesToPentahoPermissions(session, privileges));
    }

    @Override
    public void addAce(Serializable id, RepositoryFileSid recipient, EnumSet<RepositoryFilePermission> permission) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)id);
        Assert.notNull((Object)recipient);
        Assert.notNull(permission);
        RepositoryFileAcl acl = this.getAcl(id);
        Assert.notNull((Object)acl);
        RepositoryFileSid newRecipient = recipient;
        if (recipient.getType().equals((Object)RepositoryFileSid.Type.USER)) {
            if (JcrTenantUtils.getUserNameUtils().getTenant(recipient.getName()) == null) {
                newRecipient = new RepositoryFileSid(JcrTenantUtils.getTenantedUser(recipient.getName()), recipient.getType());
            }
        } else if (JcrTenantUtils.getRoleNameUtils().getTenant(recipient.getName()) == null) {
            newRecipient = new RepositoryFileSid(JcrTenantUtils.getTenantedRole(recipient.getName()), recipient.getType());
        }
        RepositoryFileAcl updatedAcl = new RepositoryFileAcl.Builder(acl).ace(newRecipient, permission).build();
        this.updateAcl(updatedAcl);
        logger.debug((Object)("added ace: id=" + id + ", sid=" + recipient + ", permission=" + permission));
    }

    @Override
    public RepositoryFileAcl createAcl(final Serializable fileId, final RepositoryFileAcl acl) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        return (RepositoryFileAcl)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                Node node = session.getNodeByIdentifier(fileId.toString());
                String absPath = node.getPath();
                AccessControlManager acMgr = session.getAccessControlManager();
                AccessControlList acList = JcrRepositoryFileAclDao.this.getAccessControlList(acMgr, absPath);
                acMgr.setPolicy(absPath, (AccessControlPolicy)acList);
                return JcrRepositoryFileAclDao.this.internalUpdateAcl(session, pentahoJcrConstants, fileId, acl);
            }
        });
    }

    private AccessControlList getAccessControlList(AccessControlManager acMgr, String path) throws RepositoryException {
        AccessControlPolicyIterator applicablePolicies = acMgr.getApplicablePolicies(path);
        while (applicablePolicies.hasNext()) {
            AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
            if (!(policy instanceof AccessControlList)) continue;
            return (AccessControlList)policy;
        }
        AccessControlPolicy[] policies = acMgr.getPolicies(path);
        for (int i = 0; i < policies.length; ++i) {
            if (!(policies[i] instanceof AccessControlList)) continue;
            return (AccessControlList)policies[i];
        }
        throw new IllegalStateException("no access control list applies or is bound to node");
    }

    @Override
    public RepositoryFileAcl getAcl(final Serializable id) {
        return (RepositoryFileAcl)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileAclDao.this.toAcl(session, pentahoJcrConstants, id);
            }
        });
    }

    protected RepositoryFileAcl getParentAcl(final Serializable id) {
        return (RepositoryFileAcl)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                Node node = session.getNodeByIdentifier(id.toString());
                if (!node.getParent().isSame((Item)session.getRootNode())) {
                    return JcrRepositoryFileAclDao.this.toAcl(session, pentahoJcrConstants, (Serializable)((Object)node.getParent().getIdentifier()));
                }
                return null;
            }
        });
    }

    @Override
    public void setFullControl(Serializable id, RepositoryFileSid sid, RepositoryFilePermission permission) {
        this.addAce(id, sid, EnumSet.of(permission));
    }

    @Override
    public RepositoryFileAcl updateAcl(final RepositoryFileAcl acl) {
        return (RepositoryFileAcl)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, acl.getId());
                RepositoryFileAcl updatedAcl = JcrRepositoryFileAclDao.this.internalUpdateAcl(session, pentahoJcrConstants, acl.getId(), acl);
                JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, acl.getId(), null, null, true);
                return updatedAcl;
            }
        });
    }

    protected RepositoryFileAcl internalUpdateAcl(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, RepositoryFileAcl acl) throws RepositoryException {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        DefaultPermissionConversionHelper permissionConversionHelper = new DefaultPermissionConversionHelper(session);
        Node node = session.getNodeByIdentifier(fileId.toString());
        if (node == null) {
            throw new RepositoryException(Messages.getInstance().getString("JackrabbitRepositoryFileAclDao.ERROR_0001_NODE_NOT_FOUND", new Object[]{fileId.toString()}));
        }
        String absPath = node.getPath();
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlList acList = this.getAccessControlList(acMgr, absPath);
        AccessControlEntry[] acEntries = acList.getAccessControlEntries();
        for (int i = 0; i < acEntries.length; ++i) {
            acList.removeAccessControlEntry(acEntries[i]);
        }
        JcrRepositoryFileAclUtils.setAclMetadata(session, absPath, acList, new IAclMetadataStrategy.AclMetadata(acl.getOwner().getName(), acl.isEntriesInheriting()));
        boolean adminPrincipalExist = false;
        ITenant principalTenant = null;
        if (!acl.isEntriesInheriting()) {
            for (RepositoryFileAce ace : acl.getAces()) {
                Object principal = null;
                if (RepositoryFileSid.Type.ROLE == ace.getSid().getType()) {
                    String principalName = JcrTenantUtils.getRoleNameUtils().getPrincipleName(ace.getSid().getName());
                    if (this.tenantAdminAuthorityName.equals(principalName)) {
                        adminPrincipalExist = true;
                    }
                    principal = new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(ace.getSid().getName()));
                } else {
                    principal = new SpringSecurityUserPrincipal(JcrTenantUtils.getTenantedUser(ace.getSid().getName()));
                }
                acList.addAccessControlEntry((Principal)principal, permissionConversionHelper.pentahoPermissionsToPrivileges(session, ace.getPermissions()));
            }
            if (!adminPrincipalExist) {
                if (acl.getAces() != null && acl.getAces().size() > 0) {
                    principalTenant = JcrTenantUtils.getRoleNameUtils().getTenant(((RepositoryFileAce)acl.getAces().get(0)).getSid().getName());
                }
                if (principalTenant == null || principalTenant.getId() == null) {
                    principalTenant = JcrTenantUtils.getTenant();
                }
                ArrayList<RepositoryFilePermission> permissionList = new ArrayList<RepositoryFilePermission>();
                permissionList.add(RepositoryFilePermission.ALL);
                SpringSecurityRolePrincipal adminPrincipal = new SpringSecurityRolePrincipal(JcrTenantUtils.getRoleNameUtils().getPrincipleId(principalTenant, this.tenantAdminAuthorityName));
                acList.addAccessControlEntry((Principal)((Object)adminPrincipal), permissionConversionHelper.pentahoPermissionsToPrivileges(session, EnumSet.copyOf(permissionList)));
            }
        }
        acMgr.setPolicy(absPath, (AccessControlPolicy)acList);
        session.save();
        return this.getAcl(fileId);
    }

    private boolean isKioskEnabled() {
        if (PentahoSystem.getInitializedOK()) {
            return "true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"));
        }
        return false;
    }

    public static interface IPermissionConversionHelper {
        public Privilege[] pentahoPermissionsToPrivileges(Session var1, EnumSet<RepositoryFilePermission> var2) throws RepositoryException;

        public EnumSet<RepositoryFilePermission> privilegesToPentahoPermissions(Session var1, Privilege[] var2) throws RepositoryException;
    }
}

