/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoterManager;
import org.pentaho.platform.api.repository2.unified.IRepositoryDefaultAclHandler;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IDeleteHelper;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.ITransformer;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.util.Assert;

public class JcrRepositoryFileDao
implements IRepositoryFileDao {
    private static final Log logger = LogFactory.getLog(JcrRepositoryFileDao.class);
    private JcrTemplate jcrTemplate;
    private List<ITransformer<IRepositoryFileData>> transformers;
    private ILockHelper lockHelper;
    private IDeleteHelper deleteHelper;
    private IPathConversionHelper pathConversionHelper;
    private IRepositoryFileAclDao aclDao;
    private IRepositoryDefaultAclHandler defaultAclHandler;
    private IRepositoryAccessVoterManager accessVoterManager;

    public JcrRepositoryFileDao(JcrTemplate jcrTemplate, List<ITransformer<IRepositoryFileData>> transformers, ILockHelper lockHelper, IDeleteHelper deleteHelper, IPathConversionHelper pathConversionHelper, IRepositoryFileAclDao aclDao, IRepositoryDefaultAclHandler defaultAclHandler) {
        Assert.notNull((Object)jcrTemplate);
        Assert.notNull(transformers);
        this.jcrTemplate = jcrTemplate;
        this.transformers = transformers;
        this.lockHelper = lockHelper;
        this.deleteHelper = deleteHelper;
        this.pathConversionHelper = pathConversionHelper;
        this.aclDao = aclDao;
        this.defaultAclHandler = defaultAclHandler;
    }

    public JcrRepositoryFileDao(JcrTemplate jcrTemplate, List<ITransformer<IRepositoryFileData>> transformers, ILockHelper lockHelper, IDeleteHelper deleteHelper, IPathConversionHelper pathConversionHelper, IRepositoryFileAclDao aclDao, IRepositoryDefaultAclHandler defaultAclHandler, IRepositoryAccessVoterManager accessVoterManager) {
        this(jcrTemplate, transformers, lockHelper, deleteHelper, pathConversionHelper, aclDao, defaultAclHandler);
        this.accessVoterManager = accessVoterManager;
    }

    private RepositoryFile internalCreateFolder(Session session, Serializable parentFolderId, RepositoryFile folder, RepositoryFileAcl acl, String versionMessage) throws RepositoryException {
        RepositoryFileAcl parentAcl;
        RepositoryFile parentRepositoryFile;
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        if (parentFolderId != null && (parentRepositoryFile = this.getFileById(parentFolderId)) != null && !this.accessVoterManager.hasAccess(parentRepositoryFile, RepositoryFilePermission.WRITE, parentAcl = this.aclDao.getAcl(parentRepositoryFile.getId()), PentahoSessionHolder.getSession())) {
            return null;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
        Node folderNode = JcrRepositoryFileUtils.createFolderNode(session, pentahoJcrConstants, parentFolderId, folder);
        String path = JcrRepositoryFileUtils.getAbsolutePath(session, pentahoJcrConstants, folderNode);
        RepositoryFile tmpFolder = new RepositoryFile.Builder(folder).path(path).build();
        JcrRepositoryFileAclUtils.createAcl(session, pentahoJcrConstants, (Serializable)((Object)folderNode.getIdentifier()), acl == null ? this.defaultAclHandler.createDefaultAcl(tmpFolder) : acl);
        session.save();
        if (folder.isVersioned()) {
            JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, folderNode, versionMessage);
        }
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, Messages.getInstance().getString("JcrRepositoryFileDao.USER_0001_VER_COMMENT_ADD_FOLDER", new Object[]{folder.getName(), parentFolderId == null ? "root" : parentFolderId.toString()}));
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, folderNode);
    }

    private RepositoryFile internalCreateFile(final Serializable parentFolderId, final RepositoryFile file, final IRepositoryFileData content, RepositoryFileAcl acl, String versionMessage) {
        RepositoryFileAcl parentAcl;
        RepositoryFile parentRepositoryFile;
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)file);
        Assert.isTrue((!file.isFolder() ? 1 : 0) != 0);
        if (parentFolderId != null && (parentRepositoryFile = this.getFileById(parentFolderId)) != null && !this.accessVoterManager.hasAccess(parentRepositoryFile, RepositoryFilePermission.WRITE, parentAcl = this.aclDao.getAcl(parentRepositoryFile.getId()), PentahoSessionHolder.getSession())) {
            return null;
        }
        DataNode emptyDataNode = new DataNode(file.getName());
        emptyDataNode.setProperty(" ", "content");
        NodeRepositoryFileData emptyContent = new NodeRepositoryFileData(emptyDataNode);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback((IRepositoryFileData)emptyContent, acl, versionMessage){
            final /* synthetic */ IRepositoryFileData val$emptyContent;
            final /* synthetic */ RepositoryFileAcl val$acl;
            final /* synthetic */ String val$versionMessage;
            {
                this.val$emptyContent = iRepositoryFileData2;
                this.val$acl = repositoryFileAcl;
                this.val$versionMessage = string;
            }

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
                Node fileNode = JcrRepositoryFileUtils.createFileNode(session, pentahoJcrConstants, parentFolderId, file, content == null ? this.val$emptyContent : content, JcrRepositoryFileDao.this.findTransformerForWrite(content == null ? this.val$emptyContent.getClass() : content.getClass()));
                String path = JcrRepositoryFileUtils.getAbsolutePath(session, pentahoJcrConstants, fileNode);
                RepositoryFile tmpFile = new RepositoryFile.Builder(file).path(path).build();
                JcrRepositoryFileDao.this.aclDao.createAcl((Serializable)((Object)fileNode.getIdentifier()), this.val$acl == null ? JcrRepositoryFileDao.this.defaultAclHandler.createDefaultAcl(tmpFile) : this.val$acl);
                session.save();
                if (file.isVersioned()) {
                    JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, fileNode, this.val$versionMessage, file.getCreatedDate(), false);
                }
                JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, Messages.getInstance().getString("JcrRepositoryFileDao.USER_0002_VER_COMMENT_ADD_FILE", new Object[]{file.getName(), parentFolderId == null ? "root" : parentFolderId.toString()}));
                return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, fileNode);
            }
        });
    }

    private RepositoryFile internalUpdateFile(Session session, PentahoJcrConstants pentahoJcrConstants, RepositoryFile file, IRepositoryFileData content, String versionMessage) throws RepositoryException {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)file);
        Assert.isTrue((!file.isFolder() ? 1 : 0) != 0);
        Assert.notNull((Object)content);
        RepositoryFileAcl acl = this.aclDao.getAcl(file.getId());
        if (!this.accessVoterManager.hasAccess(file, RepositoryFilePermission.WRITE, acl, PentahoSessionHolder.getSession())) {
            return null;
        }
        this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, file.getId());
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, file.getId());
        JcrRepositoryFileUtils.updateFileNode(session, pentahoJcrConstants, file, content, this.findTransformerForWrite(content.getClass()));
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, file.getId(), versionMessage, file.getCreatedDate() != null ? file.getCreatedDate() : new Date(), true);
        this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, file.getId());
        return JcrRepositoryFileUtils.nodeIdToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, file.getId());
    }

    private RepositoryFile internalUpdateFolder(Session session, PentahoJcrConstants pentahoJcrConstants, RepositoryFile folder, String versionMessage) throws RepositoryException {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)folder);
        Assert.isTrue((boolean)folder.isFolder());
        this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, folder.getId());
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, folder.getId());
        JcrRepositoryFileUtils.updateFolderNode(session, pentahoJcrConstants, folder);
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, folder.getId(), versionMessage);
        this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, folder.getId());
        return JcrRepositoryFileUtils.nodeIdToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, folder.getId());
    }

    protected ITransformer<IRepositoryFileData> findTransformerForRead(String contentType, Class<? extends IRepositoryFileData> clazz) {
        for (ITransformer<IRepositoryFileData> transformer : this.transformers) {
            if (!transformer.canRead(contentType, clazz)) continue;
            return transformer;
        }
        throw new IllegalArgumentException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0001_NO_TRANSFORMER"));
    }

    protected ITransformer<IRepositoryFileData> findTransformerForWrite(Class<? extends IRepositoryFileData> clazz) {
        for (ITransformer<IRepositoryFileData> transformer : this.transformers) {
            if (!transformer.canWrite(clazz)) continue;
            return transformer;
        }
        throw new IllegalArgumentException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0001_NO_TRANSFORMER"));
    }

    @Override
    public RepositoryFile createFile(Serializable parentFolderId, RepositoryFile file, IRepositoryFileData content, RepositoryFileAcl acl, String versionMessage) {
        return this.internalCreateFile(parentFolderId, file, content, acl, versionMessage);
    }

    @Override
    public RepositoryFile createFolder(final Serializable parentFolderId, final RepositoryFile folder, final RepositoryFileAcl acl, final String versionMessage) {
        Assert.notNull((Object)folder);
        Assert.isTrue((boolean)folder.isFolder());
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDao.this.internalCreateFolder(session, parentFolderId, folder, acl, versionMessage);
            }
        });
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId) {
        return this.internalGetFileById(fileId, false, null);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, boolean loadMaps) {
        return this.internalGetFileById(fileId, loadMaps, null);
    }

    @Override
    public RepositoryFile getFile(String relPath, IPentahoLocale locale) {
        return this.getFile(relPath, false, locale);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, IPentahoLocale locale) {
        return this.internalGetFileById(fileId, false, locale);
    }

    @Override
    public RepositoryFile getFile(final String relPath, final boolean loadLocaleMaps, final IPentahoLocale locale) {
        Assert.hasText((String)relPath);
        Assert.isTrue((boolean)relPath.startsWith("/"));
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                String absPath = JcrRepositoryFileDao.this.pathConversionHelper.relToAbs(relPath);
                return JcrRepositoryFileDao.this.internalGetFile(session, absPath, loadLocaleMaps, locale);
            }
        });
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, boolean loadLocaleMaps, IPentahoLocale locale) {
        return this.internalGetFileById(fileId, loadLocaleMaps, locale);
    }

    private RepositoryFile internalGetFileById(final Serializable fileId, final boolean loadMaps, final IPentahoLocale locale) {
        Assert.notNull((Object)fileId);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                RepositoryFile file;
                Node fileNode;
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                try {
                    fileNode = session.getNodeByIdentifier(fileId.toString());
                }
                catch (ItemNotFoundException e) {
                    logger.info((Object)("Couldn't find file by id: " + fileId));
                    fileNode = null;
                }
                RepositoryFile repositoryFile = file = fileNode != null ? JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, fileNode, loadMaps, locale) : null;
                if (file != null) {
                    RepositoryFileAcl acl = JcrRepositoryFileDao.this.aclDao.getAcl(file.getId());
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(file, RepositoryFilePermission.READ, acl, PentahoSessionHolder.getSession())) {
                        return null;
                    }
                }
                return file;
            }
        });
    }

    @Override
    public RepositoryFile getFile(String relPath) {
        return this.getFile(relPath, false, null);
    }

    @Override
    public RepositoryFile getFileByAbsolutePath(final String absPath) {
        Assert.hasText((String)absPath);
        Assert.isTrue((boolean)absPath.startsWith("/"));
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDao.this.internalGetFile(session, absPath, false, null);
            }
        });
    }

    @Override
    public RepositoryFile getFile(final String relPath, final boolean loadMaps) {
        Assert.hasText((String)relPath);
        Assert.isTrue((boolean)relPath.startsWith("/"));
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                String absPath = JcrRepositoryFileDao.this.pathConversionHelper.relToAbs(relPath);
                return JcrRepositoryFileDao.this.internalGetFile(session, absPath, loadMaps, null);
            }
        });
    }

    private RepositoryFile internalGetFile(Session session, String absPath, boolean loadMaps, IPentahoLocale locale) throws RepositoryException {
        RepositoryFileAcl acl;
        RepositoryFile file;
        Item fileNode;
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        try {
            fileNode = session.getItem(JcrStringHelper.pathEncode(absPath));
            Assert.isTrue((boolean)fileNode.isNode());
        }
        catch (PathNotFoundException e) {
            fileNode = null;
        }
        RepositoryFile repositoryFile = file = fileNode != null ? JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, (Node)fileNode, loadMaps, locale) : null;
        if (file != null && !this.accessVoterManager.hasAccess(file, RepositoryFilePermission.READ, acl = this.aclDao.getAcl(file.getId()), PentahoSessionHolder.getSession())) {
            return null;
        }
        return file;
    }

    @Override
    public <T extends IRepositoryFileData> T getData(final Serializable fileId, final Serializable versionId, final Class<T> contentClass) {
        Assert.notNull((Object)fileId);
        return (T)((IRepositoryFileData)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                RepositoryFile file;
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                IRepositoryFileData data = JcrRepositoryFileUtils.getContent(session, pentahoJcrConstants, fileId, versionId, JcrRepositoryFileDao.this.findTransformerForRead(JcrRepositoryFileUtils.getFileContentType(session, pentahoJcrConstants, fileId, versionId), contentClass));
                if (fileId != null && (file = JcrRepositoryFileDao.this.internalGetFileById(fileId, false, null)) != null) {
                    RepositoryFileAcl acl = JcrRepositoryFileDao.this.aclDao.getAcl(fileId);
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(file, RepositoryFilePermission.READ, acl, PentahoSessionHolder.getSession())) {
                        return null;
                    }
                }
                return data;
            }
        }));
    }

    @Override
    public List<RepositoryFile> getChildren(final RepositoryRequest repositoryRequest) {
        Assert.notNull((Object)repositoryRequest.getPath());
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileUtils.getChildren(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, repositoryRequest);
            }
        });
    }

    @Override
    public List<RepositoryFile> getChildren(final Serializable folderId, final String filter, final Boolean showHiddenFiles) {
        Assert.notNull((Object)folderId);
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileUtils.getChildren(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, folderId, filter, showHiddenFiles);
            }
        });
    }

    @Override
    public RepositoryFile updateFile(final RepositoryFile file, final IRepositoryFileData content, final String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)file);
        Assert.isTrue((!file.isFolder() ? 1 : 0) != 0);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileDao.this.internalUpdateFile(session, pentahoJcrConstants, file, content, versionMessage);
            }
        });
    }

    @Override
    public void lockFile(final Serializable fileId, final String message) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                JcrRepositoryFileDao.this.lockHelper.lockFile(session, pentahoJcrConstants, fileId, message);
                return null;
            }
        });
    }

    @Override
    public void unlockFile(final Serializable fileId) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                JcrRepositoryFileDao.this.lockHelper.unlockFile(session, pentahoJcrConstants, fileId);
                return null;
            }
        });
    }

    @Override
    public List<VersionSummary> getVersionSummaries(final Serializable fileId) {
        Assert.notNull((Object)fileId);
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileUtils.getVersionSummaries(session, pentahoJcrConstants, fileId, true);
            }
        });
    }

    @Override
    public RepositoryFile getFile(final Serializable fileId, final Serializable versionId) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileUtils.getFileAtVersion(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, fileId, versionId);
            }
        });
    }

    @Override
    public void deleteFile(final Serializable fileId, final String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                RepositoryFile fileToBeDeleted = JcrRepositoryFileDao.this.getFileById(fileId);
                if (fileToBeDeleted != null) {
                    RepositoryFileAcl toBeDeletedFileAcl = JcrRepositoryFileDao.this.aclDao.getAcl(fileToBeDeleted.getId());
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(fileToBeDeleted, RepositoryFilePermission.DELETE, toBeDeletedFileAcl, PentahoSessionHolder.getSession())) {
                        return null;
                    }
                }
                ArrayList<RepositoryFilePermission> perms = new ArrayList<RepositoryFilePermission>();
                perms.add(RepositoryFilePermission.DELETE);
                if (!JcrRepositoryFileDao.this.aclDao.hasAccess(fileToBeDeleted.getPath(), EnumSet.copyOf(perms))) {
                    throw new AccessDeniedException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED_DELETE", new Object[]{fileId}));
                }
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                Serializable parentFolderId = JcrRepositoryFileUtils.getParentId(session, fileId);
                JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
                JcrRepositoryFileDao.this.deleteHelper.deleteFile(session, pentahoJcrConstants, fileId);
                session.save();
                JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, versionMessage);
                return null;
            }
        });
    }

    @Override
    public void deleteFileAtVersion(final Serializable fileId, final Serializable versionId) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                RepositoryFile fileToBeDeleted = JcrRepositoryFileDao.this.getFileById(fileId);
                if (fileToBeDeleted != null) {
                    RepositoryFileAcl toBeDeletedFileAcl = JcrRepositoryFileDao.this.aclDao.getAcl(fileToBeDeleted.getId());
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(fileToBeDeleted, RepositoryFilePermission.DELETE, toBeDeletedFileAcl, PentahoSessionHolder.getSession())) {
                        return null;
                    }
                }
                Node fileToDeleteNode = session.getNodeByIdentifier(fileId.toString());
                session.getWorkspace().getVersionManager().getVersionHistory(fileToDeleteNode.getPath()).removeVersion(versionId.toString());
                session.save();
                return null;
            }
        });
    }

    @Override
    public List<RepositoryFile> getDeletedFiles(final String origParentFolderPath, final String filter) {
        Assert.hasLength((String)origParentFolderPath);
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileDao.this.deleteHelper.getDeletedFiles(session, pentahoJcrConstants, origParentFolderPath, filter);
            }
        });
    }

    @Override
    public List<RepositoryFile> getDeletedFiles() {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileDao.this.deleteHelper.getDeletedFiles(session, pentahoJcrConstants);
            }
        });
    }

    @Override
    public List<RepositoryFile> getAllDeletedFiles() {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileDao.this.deleteHelper.getAllDeletedFiles(session, pentahoJcrConstants);
            }
        });
    }

    @Override
    public void permanentlyDeleteFile(final Serializable fileId, String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                RepositoryFile fileToBeDeleted = JcrRepositoryFileDao.this.getFileById(fileId);
                if (fileToBeDeleted != null) {
                    RepositoryFileAcl toBeDeletedFileAcl = JcrRepositoryFileDao.this.aclDao.getAcl(fileToBeDeleted.getId());
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(fileToBeDeleted, RepositoryFilePermission.DELETE, toBeDeletedFileAcl, PentahoSessionHolder.getSession())) {
                        return null;
                    }
                }
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                JcrRepositoryFileDao.this.deleteHelper.permanentlyDeleteFile(session, pentahoJcrConstants, fileId);
                session.save();
                return null;
            }
        });
    }

    @Override
    public void undeleteFile(final Serializable fileId, final String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                String absOrigParentFolderPath = JcrRepositoryFileDao.this.deleteHelper.getOriginalParentFolderPath(session, pentahoJcrConstants, fileId);
                Object origParentFolderId = null;
                RepositoryFile file = JcrRepositoryFileDao.this.getFileById(fileId);
                RepositoryFileAcl acl = JcrRepositoryFileDao.this.aclDao.getAcl(fileId);
                if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(file, RepositoryFilePermission.WRITE, acl, PentahoSessionHolder.getSession())) {
                    return null;
                }
                if (session.itemExists(JcrStringHelper.pathEncode(absOrigParentFolderPath))) {
                    origParentFolderId = ((Node)session.getItem(JcrStringHelper.pathEncode(absOrigParentFolderPath))).getIdentifier();
                } else {
                    String[] segments = JcrRepositoryFileDao.this.pathConversionHelper.absToRel(absOrigParentFolderPath).split("/");
                    RepositoryFile lastParentFolder = JcrRepositoryFileDao.this.internalGetFile(session, ServerRepositoryPaths.getTenantRootFolderPath(), false, null);
                    for (String segment : segments) {
                        if (!org.springframework.util.StringUtils.hasLength((String)segment)) continue;
                        RepositoryFile tmp = JcrRepositoryFileDao.this.internalGetFile(session, JcrRepositoryFileDao.this.pathConversionHelper.relToAbs((lastParentFolder.getPath().equals("/") ? "" : lastParentFolder.getPath()) + "/" + segment), false, null);
                        lastParentFolder = tmp == null ? JcrRepositoryFileDao.this.internalCreateFolder(session, lastParentFolder.getId(), new RepositoryFile.Builder(segment).folder(true).build(), JcrRepositoryFileDao.this.defaultAclHandler.createDefaultAcl(lastParentFolder), null) : tmp;
                    }
                    origParentFolderId = lastParentFolder.getId();
                }
                JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, (Serializable)origParentFolderId);
                JcrRepositoryFileDao.this.deleteHelper.undeleteFile(session, pentahoJcrConstants, fileId);
                session.save();
                JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, (Serializable)origParentFolderId, versionMessage);
                return null;
            }
        });
    }

    private void internalCopyOrMove(final Serializable fileId, final String destRelPath, final String versionMessage, final boolean copy) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                String fileName;
                String absPathToDestParentFolder;
                RepositoryFile destFolder;
                RepositoryFile file = JcrRepositoryFileDao.this.getFileById(fileId);
                if (!copy) {
                    RepositoryFileAcl acl = JcrRepositoryFileDao.this.aclDao.getAcl(fileId);
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(file, RepositoryFilePermission.WRITE, acl, PentahoSessionHolder.getSession())) {
                        throw new AccessDeniedException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED_DELETE", new Object[]{fileId}));
                    }
                }
                if ((destFolder = JcrRepositoryFileDao.this.getFile(destRelPath)) != null) {
                    RepositoryFileAcl destFolderAcl = JcrRepositoryFileDao.this.aclDao.getAcl(destFolder.getId());
                    if (!JcrRepositoryFileDao.this.accessVoterManager.hasAccess(destFolder, RepositoryFilePermission.WRITE, destFolderAcl, PentahoSessionHolder.getSession())) {
                        throw new AccessDeniedException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED_CREATE", new Object[]{destFolder.getId()}));
                    }
                }
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                String destAbsPath = JcrRepositoryFileDao.this.pathConversionHelper.relToAbs(destRelPath);
                String cleanDestAbsPath = destAbsPath;
                if (cleanDestAbsPath.endsWith("/")) {
                    cleanDestAbsPath.substring(0, cleanDestAbsPath.length() - 1);
                }
                Node srcFileNode = session.getNodeByIdentifier(fileId.toString());
                Serializable srcParentFolderId = JcrRepositoryFileUtils.getParentId(session, fileId);
                boolean appendFileName = false;
                boolean destExists = true;
                Node destFileNode = null;
                Node destParentFolderNode = null;
                try {
                    destFileNode = (Node)session.getItem(JcrStringHelper.pathEncode(cleanDestAbsPath));
                }
                catch (PathNotFoundException e) {
                    destExists = false;
                }
                if (destExists) {
                    Assert.isTrue((boolean)JcrRepositoryFileUtils.isSupportedNodeType(pentahoJcrConstants, destFileNode));
                    Assert.isTrue((!JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, srcFileNode) || !JcrRepositoryFileUtils.isPentahoFile(pentahoJcrConstants, destFileNode) ? 1 : 0) != 0, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0002_CANNOT_OVERWRITE_FILE_WITH_FOLDER"));
                    if (JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, destFileNode)) {
                        appendFileName = true;
                        destParentFolderNode = destFileNode;
                    } else {
                        int lastSlashIndex = cleanDestAbsPath.lastIndexOf("/");
                        Assert.isTrue((lastSlashIndex > 1 ? 1 : 0) != 0, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0003_ILLEGAL_DEST_PATH"));
                        absPathToDestParentFolder = cleanDestAbsPath.substring(0, lastSlashIndex);
                        destParentFolderNode = (Node)session.getItem(JcrStringHelper.pathEncode(absPathToDestParentFolder));
                    }
                } else {
                    int lastSlashIndex = cleanDestAbsPath.lastIndexOf("/");
                    Assert.isTrue((lastSlashIndex > 1 ? 1 : 0) != 0, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0003_ILLEGAL_DEST_PATH"));
                    absPathToDestParentFolder = cleanDestAbsPath.substring(0, lastSlashIndex);
                    try {
                        destParentFolderNode = (Node)session.getItem(JcrStringHelper.pathEncode(absPathToDestParentFolder));
                    }
                    catch (PathNotFoundException e1) {
                        Assert.isTrue((boolean)false, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0004_PARENT_MUST_EXIST"));
                    }
                    Assert.isTrue((boolean)JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, destParentFolderNode), (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0005_PARENT_MUST_BE_FOLDER"));
                }
                if (!copy) {
                    JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, srcParentFolderId);
                }
                JcrRepositoryFileUtils.checkoutNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, destParentFolderNode);
                String finalEncodedSrcAbsPath = srcFileNode.getPath();
                String finalEncodedDestAbsPath = null;
                finalEncodedDestAbsPath = appendFileName ? (JcrStringHelper.isEncoded(fileName = srcFileNode.getName()) ? JcrStringHelper.pathEncode(cleanDestAbsPath) + "/" + fileName : JcrStringHelper.pathEncode(cleanDestAbsPath + "/" + fileName)) : JcrStringHelper.pathEncode(cleanDestAbsPath);
                try {
                    if (copy) {
                        session.getWorkspace().copy(finalEncodedSrcAbsPath, finalEncodedDestAbsPath);
                    } else {
                        session.getWorkspace().move(finalEncodedSrcAbsPath, finalEncodedDestAbsPath);
                    }
                }
                catch (ItemExistsException iae) {
                    throw new UnifiedRepositoryException((file.isFolder() ? "Folder " : "File ") + "with path [" + cleanDestAbsPath + "] already exists in the repository");
                }
                JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, destParentFolderNode, versionMessage);
                if (!copy && !destParentFolderNode.getIdentifier().equals(srcParentFolderId.toString())) {
                    JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, srcParentFolderId, versionMessage);
                }
                session.save();
                return null;
            }
        });
    }

    @Override
    public void moveFile(Serializable fileId, String destRelPath, String versionMessage) {
        this.internalCopyOrMove(fileId, destRelPath, versionMessage, false);
    }

    @Override
    public void copyFile(Serializable fileId, String destRelPath, String versionMessage) {
        this.internalCopyOrMove(fileId, destRelPath, versionMessage, true);
    }

    @Override
    public VersionSummary getVersionSummary(final Serializable fileId, final Serializable versionId) {
        Assert.notNull((Object)fileId);
        return (VersionSummary)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileUtils.getVersionSummary(session, pentahoJcrConstants, fileId, versionId);
            }
        });
    }

    @Override
    public void restoreFileAtVersion(final Serializable fileId, final Serializable versionId, String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                Node fileNode = session.getNodeByIdentifier(fileId.toString());
                session.getWorkspace().getVersionManager().restore(fileNode.getPath(), versionId.toString(), true);
                return null;
            }
        });
    }

    @Override
    public boolean canUnlockFile(final Serializable fileId) {
        return (Boolean)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                Node fileNode = session.getNodeByIdentifier(fileId.toString());
                Lock lock = session.getWorkspace().getLockManager().getLock(fileNode.getPath());
                return JcrRepositoryFileDao.this.lockHelper.canUnlock(session, pentahoJcrConstants, lock);
            }
        });
    }

    @Override
    public RepositoryFileTree getTree(final RepositoryRequest repositoryRequest) {
        Assert.hasText((String)repositoryRequest.getPath());
        return (RepositoryFileTree)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                String absPath = JcrRepositoryFileDao.this.pathConversionHelper.relToAbs(repositoryRequest.getPath());
                return JcrRepositoryFileUtils.getTree(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, absPath, repositoryRequest, JcrRepositoryFileDao.this.accessVoterManager);
            }
        });
    }

    @Override
    @Deprecated
    public RepositoryFileTree getTree(final String relPath, int depth, String filter, boolean showHidden) {
        Assert.hasText((String)relPath);
        final RepositoryRequest repositoryRequest = new RepositoryRequest(relPath, Boolean.valueOf(showHidden), Integer.valueOf(depth), filter);
        return (RepositoryFileTree)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                String absPath = JcrRepositoryFileDao.this.pathConversionHelper.relToAbs(relPath);
                return JcrRepositoryFileUtils.getTree(session, pentahoJcrConstants, JcrRepositoryFileDao.this.pathConversionHelper, JcrRepositoryFileDao.this.lockHelper, absPath, repositoryRequest, JcrRepositoryFileDao.this.accessVoterManager);
            }
        });
    }

    @Override
    public List<RepositoryFile> getReferrers(final Serializable fileId) {
        if (fileId == null) {
            return new ArrayList<RepositoryFile>();
        }
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                Node fileNode = session.getNodeByIdentifier(fileId.toString());
                Assert.notNull((Object)fileNode);
                HashSet<RepositoryFile> referrers = new HashSet<RepositoryFile>();
                PropertyIterator refIter = fileNode.getReferences();
                if (refIter.hasNext()) {
                    while (refIter.hasNext()) {
                        RepositoryFile referrer = JcrRepositoryFileDao.this.getReferrerFile(session, pentahoJcrConstants, refIter.nextProperty());
                        if (referrer == null) continue;
                        referrers.add(referrer);
                    }
                }
                session.save();
                return Arrays.asList(referrers.toArray());
            }
        });
    }

    protected RepositoryFile getReferrerFile(Session session, PentahoJcrConstants pentahoJcrConstants, Property referrerProperty) throws RepositoryException {
        Node currentNode = referrerProperty.getParent();
        while (!currentNode.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOHIERARCHYNODE())) {
            currentNode = currentNode.getParent();
        }
        if (currentNode.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER())) {
            return null;
        }
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, currentNode);
    }

    @Override
    public void setFileMetadata(final Serializable fileId, final Map<String, Serializable> metadataMap) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)fileId);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileUtils.setFileMetadata(session, fileId, metadataMap);
                return null;
            }
        });
    }

    @Override
    public Map<String, Serializable> getFileMetadata(final Serializable fileId) {
        Assert.notNull((Object)fileId);
        return (Map)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws IOException, RepositoryException {
                return JcrRepositoryFileUtils.getFileMetadata(session, fileId);
            }
        });
    }

    @Override
    public List<Character> getReservedChars() {
        return JcrRepositoryFileUtils.getReservedChars();
    }

    public IRepositoryDefaultAclHandler getDefaultAclHandler() {
        return this.defaultAclHandler;
    }

    public void setDefaultAclHandler(IRepositoryDefaultAclHandler defaultAclHandler) {
        this.defaultAclHandler = defaultAclHandler;
    }

    @Override
    public List<Locale> getAvailableLocalesForFileById(Serializable fileId) {
        RepositoryFile repositoryFile = this.getFileById(fileId, true);
        return this.getAvailableLocalesForFile(repositoryFile);
    }

    @Override
    public List<Locale> getAvailableLocalesForFileByPath(String relPath) {
        RepositoryFile repositoryFile = this.getFileById((Serializable)((Object)relPath), true);
        return this.getAvailableLocalesForFile(repositoryFile);
    }

    @Override
    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        if (repositoryFile != null && repositoryFile.getLocalePropertiesMap() != null) {
            for (String localeName : repositoryFile.getLocalePropertiesMap().keySet()) {
                String[] localePieces = localeName.split("_");
                String language = localePieces[0];
                String country = localePieces.length > 1 ? localePieces[1] : "";
                String variant = localePieces.length > 2 ? localePieces[2] : "";
                Locale locale = new Locale(language, country, variant);
                localeList.add(locale);
            }
        }
        return localeList;
    }

    @Override
    public Properties getLocalePropertiesForFileById(Serializable fileId, String locale) {
        RepositoryFile repositoryFile = this.getFileById(fileId, true);
        return this.getLocalePropertiesForFile(repositoryFile, locale);
    }

    @Override
    public Properties getLocalePropertiesForFileByPath(String relPath, String locale) {
        RepositoryFile repositoryFile = this.getFileById((Serializable)((Object)relPath), true);
        return this.getLocalePropertiesForFile(repositoryFile, locale);
    }

    @Override
    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        if (StringUtils.isBlank((String)locale)) {
            locale = "default";
        }
        if (repositoryFile != null && repositoryFile.getLocalePropertiesMap() != null) {
            Properties properties = (Properties)repositoryFile.getLocalePropertiesMap().get(locale);
            return properties;
        }
        return null;
    }

    @Override
    public void setLocalePropertiesForFileById(Serializable fileId, String locale, Properties properties) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        RepositoryFile repositoryFile = this.getFileById(fileId, true);
        this.setLocalePropertiesForFile(repositoryFile, locale, properties);
    }

    @Override
    public void setLocalePropertiesForFileByPath(String relPath, String locale, Properties properties) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        RepositoryFile repositoryFile = this.getFileById((Serializable)((Object)relPath), true);
        this.setLocalePropertiesForFile(repositoryFile, locale, properties);
    }

    @Override
    public void setLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale, final Properties properties) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)repositoryFile);
        Assert.notNull((Object)locale);
        Assert.notNull((Object)properties);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                String versionMessage = Messages.getInstance().getString("JcrRepositoryFileDao.LOCALE_0001_UPDATE_PROPERTIES", new Object[]{repositoryFile.getId()});
                JcrRepositoryFileDao.this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
                JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
                JcrRepositoryFileUtils.updateFileLocaleProperties(session, repositoryFile.getId(), locale, properties);
                session.save();
                JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId(), versionMessage);
                JcrRepositoryFileDao.this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
                return null;
            }
        });
    }

    @Override
    public void deleteLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)repositoryFile);
        Assert.notNull((Object)locale);
        this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                String versionMessage = Messages.getInstance().getString("JcrRepositoryFileDao.LOCALE_0002_DELETE_PROPERTIES", new Object[]{repositoryFile.getId()});
                JcrRepositoryFileDao.this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
                JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
                JcrRepositoryFileUtils.deleteFileLocaleProperties(session, repositoryFile.getId(), locale);
                session.save();
                JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId(), versionMessage);
                JcrRepositoryFileDao.this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
                return null;
            }
        });
    }

    @Override
    public RepositoryFile updateFolder(final RepositoryFile file, final String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)file);
        Assert.isTrue((boolean)file.isFolder());
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                return JcrRepositoryFileDao.this.internalUpdateFolder(session, pentahoJcrConstants, file, versionMessage);
            }
        });
    }

    private String extractNameFromPath(String path) {
        int endIndex;
        int startIndex = path.lastIndexOf("/");
        if (startIndex >= 0 && (endIndex = path.indexOf(46, startIndex)) > startIndex) {
            return path.substring(startIndex + 1, endIndex);
        }
        return null;
    }

    private boolean isKioskEnabled() {
        if (PentahoSystem.getInitializedOK()) {
            return "true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"));
        }
        return false;
    }
}

