/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.IRepositoryVersionManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;
import org.pentaho.platform.repository2.unified.webservices.LocaleMapDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAceDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.StringKeyStringValueDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFileAdapter
extends XmlAdapter<RepositoryFileDto, RepositoryFile> {
    private static Logger logger = LoggerFactory.getLogger(RepositoryFileAdapter.class);
    private static DefaultUnifiedRepositoryWebService repoWs;
    private Set<String> membersSet;
    private boolean exclude;
    private boolean includeAcls;

    public RepositoryFileAdapter() {
        this.exclude = false;
        this.includeAcls = false;
        this.membersSet = null;
    }

    public RepositoryFileAdapter(RepositoryRequest repositoryRequest) {
        if (repositoryRequest.getExcludeMemberSet() != null && !repositoryRequest.getExcludeMemberSet().isEmpty()) {
            this.exclude = true;
            this.membersSet = repositoryRequest.getExcludeMemberSet();
        } else {
            this.exclude = false;
            this.membersSet = repositoryRequest.getIncludeMemberSet();
        }
        this.includeAcls = repositoryRequest.isIncludeAcls();
    }

    public static Logger getLogger() {
        return logger;
    }

    public RepositoryFileDto marshal(RepositoryFile v) {
        return RepositoryFileAdapter.toFileDto(v, this.membersSet, this.exclude, this.includeAcls);
    }

    public RepositoryFileDto marshal(RepositoryFileTree repositoryFileTree) {
        return RepositoryFileAdapter.toFileDto(repositoryFileTree, this.membersSet, this.exclude, this.includeAcls);
    }

    private static boolean include(String key, Set<String> set, boolean exclude) {
        return !exclude && (set == null || set.contains(key)) || exclude && !set.contains(key);
    }

    public static RepositoryFileDto toFileDto(RepositoryFileTree repositoryFileTree, Set<String> memberSet, boolean exclude, boolean includeAcls) {
        RepositoryFileDto repositoryFileDto = RepositoryFileAdapter.toFileDto(repositoryFileTree.getFile(), memberSet, exclude, includeAcls);
        return repositoryFileDto;
    }

    public static RepositoryFileDto toFileDto(RepositoryFile v, Set<String> memberSet, boolean exclude) {
        return RepositoryFileAdapter.toFileDto(v, memberSet, exclude, false);
    }

    public static RepositoryFileDto toFileDto(RepositoryFile v, Set<String> memberSet, boolean exclude, boolean includeAcls) {
        IRepositoryVersionManager repositoryVersionManager;
        if (v == null) {
            return null;
        }
        RepositoryFileDto f = new RepositoryFileDto();
        try {
            if (RepositoryFileAdapter.include("name", memberSet, exclude)) {
                f.name = v.getName();
            }
            if (RepositoryFileAdapter.include("path", memberSet, exclude)) {
                f.path = v.getPath();
            }
            if (RepositoryFileAdapter.include("hidden", memberSet, exclude)) {
                f.hidden = v.isHidden();
            }
            if (RepositoryFileAdapter.include("aclNode", memberSet, exclude)) {
                f.aclNode = v.isAclNode();
            }
            if (RepositoryFileAdapter.include("createDate", memberSet, exclude)) {
                f.createdDate = v.getCreatedDate();
            }
            if (RepositoryFileAdapter.include("creatorId", memberSet, exclude)) {
                f.creatorId = v.getCreatorId();
            }
            if (RepositoryFileAdapter.include("fileSize", memberSet, exclude)) {
                f.fileSize = v.getFileSize();
            }
            if (RepositoryFileAdapter.include("description", memberSet, exclude)) {
                f.description = v.getDescription();
            }
            if (RepositoryFileAdapter.include("folder", memberSet, exclude)) {
                f.folder = v.isFolder();
            }
            if (v.getId() != null) {
                f.id = v.getId().toString();
            }
            if (RepositoryFileAdapter.include("lastModifiedDate", memberSet, exclude)) {
                f.lastModifiedDate = v.getLastModifiedDate();
            }
            if (RepositoryFileAdapter.include("locale", memberSet, exclude)) {
                f.locale = v.getLocale();
            }
            if (RepositoryFileAdapter.include("originalParentFolderPath", memberSet, exclude)) {
                f.originalParentFolderPath = v.getOriginalParentFolderPath();
            }
            if (RepositoryFileAdapter.include("deletedDate", memberSet, exclude)) {
                f.deletedDate = v.getDeletedDate();
            }
            if (RepositoryFileAdapter.include("lockDate", memberSet, exclude)) {
                f.lockDate = v.getLockDate();
            }
            if (RepositoryFileAdapter.include("locked", memberSet, exclude)) {
                f.locked = v.isLocked();
            }
            if (RepositoryFileAdapter.include("lockMessage", memberSet, exclude)) {
                f.lockMessage = v.getLockMessage();
            }
            if (RepositoryFileAdapter.include("lockOwner", memberSet, exclude)) {
                f.lockOwner = v.getLockOwner();
            }
            if (RepositoryFileAdapter.include("title", memberSet, exclude)) {
                f.title = v.getTitle();
            }
            if (RepositoryFileAdapter.include("versioned", memberSet, exclude)) {
                f.versioned = v.isVersioned();
            }
            if (RepositoryFileAdapter.include("versionId", memberSet, exclude) && v.getVersionId() != null) {
                f.versionId = v.getVersionId().toString();
            }
        }
        catch (NullPointerException e) {
            RepositoryFileAdapter.getLogger().warn("NullPointerException while reading file attributes, returning null. Probable cause: File does notexist anymore: ");
            return null;
        }
        if (includeAcls) {
            RepositoryFileAclDto repositoryFileAclDto;
            Object id;
            if (v.getId() != null) {
                try {
                    f.repositoryFileAclDto = RepositoryFileAdapter.getRepoWs().getAcl(v.getId().toString());
                    if (f.repositoryFileAclDto.isEntriesInheriting()) {
                        List<RepositoryFileAclAceDto> aces = RepositoryFileAdapter.getRepoWs().getEffectiveAces(v.getId().toString());
                        f.repositoryFileAclDto.setAces(aces, f.repositoryFileAclDto.isEntriesInheriting());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (RepositoryFileAdapter.include("owner", memberSet, exclude) && (id = v.getId()) != null && (repositoryFileAclDto = RepositoryFileAdapter.getRepoWs().getAcl("" + id)) != null) {
                f.owner = repositoryFileAclDto.getOwner();
            }
        }
        if (RepositoryFileAdapter.include("locales", memberSet, exclude) && v.getLocalePropertiesMap() != null) {
            f.localePropertiesMapEntries = new ArrayList<LocaleMapDto>();
            for (Map.Entry entry : v.getLocalePropertiesMap().entrySet()) {
                LocaleMapDto localeMapDto = new LocaleMapDto();
                ArrayList<StringKeyStringValueDto> valuesDto = new ArrayList<StringKeyStringValueDto>();
                Properties properties = (Properties)entry.getValue();
                if (properties != null) {
                    for (String propertyName : properties.stringPropertyNames()) {
                        valuesDto.add(new StringKeyStringValueDto(propertyName, properties.getProperty(propertyName)));
                    }
                }
                localeMapDto.setLocale((String)entry.getKey());
                localeMapDto.setProperties(valuesDto);
                f.localePropertiesMapEntries.add(localeMapDto);
            }
        }
        try {
            repositoryVersionManager = JcrRepositoryFileUtils.getRepositoryVersionManager();
            if (repositoryVersionManager == null) {
                return f;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return f;
        }
        if (RepositoryFileAdapter.include("versioningEnabled", memberSet, exclude)) {
            f.setVersioningEnabled(repositoryVersionManager.isVersioningEnabled(v.getPath()));
        }
        if (RepositoryFileAdapter.include("versionCommentEnabled", memberSet, exclude)) {
            f.setVersionCommentEnabled(repositoryVersionManager.isVersionCommentEnabled(v.getPath()));
        }
        return f;
    }

    public RepositoryFile unmarshal(RepositoryFileDto v) {
        return RepositoryFileAdapter.toFile(v);
    }

    public static RepositoryFile toFile(RepositoryFileDto v) {
        if (v == null) {
            return null;
        }
        RepositoryFile.Builder builder = null;
        builder = v.id != null ? new RepositoryFile.Builder((Serializable)((Object)v.id), v.name) : new RepositoryFile.Builder(v.name);
        if (v.ownerType != -1) {
            new RepositoryFileSid(v.owner, RepositoryFileSid.Type.values()[v.ownerType]);
        }
        if (v.localePropertiesMapEntries != null) {
            for (LocaleMapDto localeMapDto : v.localePropertiesMapEntries) {
                String locale = localeMapDto.getLocale();
                Properties localeProperties = new Properties();
                if (localeMapDto.getProperties() != null) {
                    for (StringKeyStringValueDto keyValueDto : localeMapDto.getProperties()) {
                        localeProperties.put(keyValueDto.getKey(), keyValueDto.getValue());
                    }
                }
                builder.localeProperties(locale, localeProperties);
            }
        }
        return builder.path(v.path).createdDate(v.createdDate).creatorId(v.creatorId).description(v.description).folder(v.folder).fileSize(v.fileSize).lastModificationDate(v.lastModifiedDate).locale(v.locale).lockDate(v.lockDate).locked(v.locked).lockMessage(v.lockMessage).lockOwner(v.lockOwner).title(v.title).versioned(v.versioned).versionId((Serializable)((Object)v.versionId)).originalParentFolderPath(v.originalParentFolderPath).deletedDate(v.deletedDate).hidden(v.hidden).schedulable(!v.isNotSchedulable()).aclNode(v.aclNode).build();
    }

    private static DefaultUnifiedRepositoryWebService getRepoWs() {
        if (repoWs == null) {
            repoWs = new DefaultUnifiedRepositoryWebService();
        }
        return repoWs;
    }
}

