/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class CharType
extends AbstractColumnType {
    private final int length;
    private byte[] data;
    private final Charset charset;

    public CharType(int len, Charset charset) {
        this.length = len;
        this.charset = charset;
        this.data = new byte[len];
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        byteBuffer.get(this.data);
    }

    public String getDataAsString() {
        try {
            return new String(this.data, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.put(this.data);
    }

    public void setData(String string) {
        if (string == null) {
            this.setIsNull(true);
        } else {
            byte[] bytes;
            if (this.isCheckValues() && string.length() > this.length) {
                throw new ValueConverterException("data is too big for this column");
            }
            this.setIsNull(false);
            try {
                bytes = string.getBytes(this.charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            System.arraycopy(bytes, 0, this.data, 0, bytes.length);
            this.padSpacesStartingAt(bytes.length);
        }
    }

    private void padSpacesStartingAt(int startIdx) {
        for (int i = startIdx; i < this.data.length; ++i) {
            this.data[i] = 32;
        }
    }

    protected void zeroOutData() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            String val = meta.getString(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                this.setData(val);
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return true;
    }
}

