/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputMeta;
import org.pentaho.bigdata.api.format.FormatService;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroInputFormat;

public class AvroInput
extends BaseFileInputStep<AvroInputMeta, AvroInputData> {
    public static long SPLIT_SIZE = 0x8000000L;
    private Object[] inputToStepRow;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public AvroInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AvroInputMeta)smi;
        this.data = (AvroInputData)sdi;
        do {
            try {
                if (((AvroInputData)this.data).input == null || ((AvroInputData)this.data).reader == null || ((AvroInputData)this.data).rowIterator == null) {
                    FormatService formatService;
                    try {
                        formatService = (FormatService)this.namedClusterServiceLocator.getService(((AvroInputMeta)this.meta).getNamedCluster(), FormatService.class);
                        this.inputToStepRow = this.getRow();
                        if (this.inputToStepRow == null && ((AvroInputMeta)this.meta).isUseFieldAsInputStream()) {
                            this.fileFinishedHousekeeping();
                            break;
                        }
                    }
                    catch (ClusterInitializationException e) {
                        throw new KettleException("can't get service format shim ", (Throwable)e);
                    }
                    if (((AvroInputMeta)this.meta).getFilename() == null && !((AvroInputMeta)this.meta).isUseFieldAsInputStream()) {
                        throw new KettleException("No input files defined");
                    }
                    ((AvroInputData)this.data).input = (IPentahoAvroInputFormat)formatService.createInputFormat(IPentahoAvroInputFormat.class);
                    ((AvroInputData)this.data).input.setInputFile(((AvroInputMeta)this.meta).getParentStepMeta().getParentTransMeta().environmentSubstitute(((AvroInputMeta)this.meta).getFilename()));
                    ((AvroInputData)this.data).input.setInputSchemaFile(((AvroInputMeta)this.meta).getParentStepMeta().getParentTransMeta().environmentSubstitute(((AvroInputMeta)this.meta).getSchemaFilename()));
                    ((AvroInputData)this.data).input.setInputFields(Arrays.asList(((AvroInputMeta)this.meta).getInputFields()));
                    if (((AvroInputMeta)this.meta).isUseFieldAsInputStream()) {
                        ((AvroInputData)this.data).input.setInputStreamFieldName(((AvroInputMeta)this.meta).getInputStreamFieldName());
                        int fieldIndex = this.getInputRowMeta().indexOfValue(((AvroInputData)this.data).input.getInputStreamFieldName());
                        if (fieldIndex == -1) {
                            throw new KettleException("Field '" + ((AvroInputData)this.data).input.getInputStreamFieldName() + "' was not found in step's input fields");
                        }
                        ((AvroInputData)this.data).input.setInputStream((InputStream)new ByteArrayInputStream(this.getInputRowMeta().getBinary(this.inputToStepRow, fieldIndex)));
                    }
                    ((AvroInputData)this.data).reader = ((AvroInputData)this.data).input.createRecordReader(null);
                    ((AvroInputData)this.data).rowIterator = ((AvroInputData)this.data).reader.iterator();
                }
                if (((AvroInputData)this.data).rowIterator.hasNext()) {
                    RowMetaAndData row = ((AvroInputData)this.data).rowIterator.next();
                    if (this.getInputRowMeta() != null && this.inputToStepRow != null) {
                        row.mergeRowMetaAndData(new RowMetaAndData(this.getInputRowMeta(), this.inputToStepRow), null);
                    }
                    this.putRow(row.getRowMeta(), row.getData());
                    return true;
                }
                this.fileFinishedHousekeeping();
            }
            catch (KettleException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new KettleException((Throwable)ex);
            }
        } while (((AvroInputMeta)this.meta).isUseFieldAsInputStream());
        this.setOutputDone();
        return false;
    }

    private void fileFinishedHousekeeping() {
        try {
            if (((AvroInputData)this.data).reader != null) {
                ((AvroInputData)this.data).reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((AvroInputData)this.data).reader = null;
        ((AvroInputData)this.data).input = null;
    }

    protected boolean init() {
        return true;
    }

    protected IBaseFileInputReader createReader(AvroInputMeta meta, AvroInputData data, FileObject file) throws Exception {
        return null;
    }

    public static List<? extends IAvroInputField> getDefaultFields(NamedClusterServiceLocator namedClusterServiceLocator, NamedCluster namedCluster, String schemaPath, String dataPath) throws Exception {
        FormatService formatService = (FormatService)namedClusterServiceLocator.getService(namedCluster, FormatService.class);
        IPentahoAvroInputFormat in = (IPentahoAvroInputFormat)formatService.createInputFormat(IPentahoAvroInputFormat.class);
        in.setInputSchemaFile(schemaPath);
        in.setInputFile(dataPath);
        return in.getFields();
    }
}

