/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.BaseAvroStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInput;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class AvroInputDialog
extends BaseAvroStepDialog<AvroInputMeta> {
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 554;
    private static final int AVRO_PATH_COLUMN_INDEX = 1;
    private static final int FIELD_NAME_COLUMN_INDEX = 2;
    private static final int FIELD_TYPE_COLUMN_INDEX = 3;
    private static final int FORMAT_COLUMN_INDEX = 4;
    private static final String SCHEMA_SCHEME_DEFAULT = "hdfs";
    private TableView wInputFields;
    protected TextVar wSchemaPath;
    protected Button wbSchemaBrowse;
    private Button wPassThruFields;

    public AvroInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (AvroInputMeta)((Object)in), transMeta, sname);
    }

    @Override
    protected Control createAfterFile(Composite afterFile) {
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addFileTab(wTabFolder);
        this.addSchemaTab(wTabFolder);
        this.addFieldsTab(wTabFolder);
        new BaseAvroStepDialog.FD((Control)wTabFolder).left(0, 0).top(0, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    private String concatenateAvroNameAndType(String avroFieldName, AvroSpec.DataType avroType) {
        return avroFieldName + " (" + avroType.getName() + ")";
    }

    private AvroSpec.DataType extractAvroType(String avroNameTypeFromUI) {
        String uiType;
        if (avroNameTypeFromUI != null && (uiType = StringUtils.substringBetween((String)avroNameTypeFromUI, (String)"(", (String)")")) != null) {
            String uiTypeTrimmed = uiType.trim();
            for (AvroSpec.DataType temp : AvroSpec.DataType.values()) {
                if (!temp.getName().equalsIgnoreCase(uiTypeTrimmed)) continue;
                return temp;
            }
        }
        return null;
    }

    protected void populateFieldsTable() {
        String schemaFileName = this.wSchemaPath.getText();
        schemaFileName = this.transMeta.environmentSubstitute(schemaFileName);
        String avroFileName = this.wPath.getText();
        avroFileName = this.transMeta.environmentSubstitute(avroFileName);
        try {
            List<? extends IAvroInputField> defaultFields = AvroInput.getDefaultFields(((AvroInputMeta)this.meta).getNamedClusterServiceLocator(), ((AvroInputMeta)this.meta).getNamedCluster(), schemaFileName, avroFileName);
            this.wInputFields.clearAll();
            for (IAvroInputField iAvroInputField : defaultFields) {
                TableItem item = new TableItem(this.wInputFields.table, 0);
                if (iAvroInputField == null) continue;
                this.setField(item, this.concatenateAvroNameAndType(iAvroInputField.getDisplayableAvroFieldName(), iAvroInputField.getAvroType()), 1);
                this.setField(item, iAvroInputField.getPentahoFieldName(), 2);
                this.setField(item, ValueMetaFactory.getValueMetaName((int)iAvroInputField.getPentahoType()), 3);
                this.setField(item, iAvroInputField.getStringFormat(), 4);
            }
            this.wInputFields.removeEmptyRows();
            this.wInputFields.setRowNums();
            this.wInputFields.optWidth(true);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString((Class)this.PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[0]), ex);
            new ErrorDialog(this.shell, this.stepname, BaseMessages.getString((Class)this.PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[]{avroFileName}), ex);
        }
    }

    private void setField(TableItem item, String fieldValue, int fieldIndex) {
        if (!Utils.isEmpty((CharSequence)fieldValue)) {
            item.setText(fieldIndex, fieldValue);
        }
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wComp.setLayout((Layout)layout);
        this.wPassThruFields = new Button(wComp, 32);
        this.wPassThruFields.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PassThruFields.Label", (String[])new String[0]));
        this.wPassThruFields.setToolTipText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PassThruFields.Tooltip", (String[])new String[0]));
        this.wPassThruFields.setOrientation(0x2000000);
        this.props.setLook((Control)this.wPassThruFields);
        new BaseAvroStepDialog.FD((Control)this.wPassThruFields).left(0, 0).top((Control)wComp, 0).apply();
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                AvroInputDialog.this.populateFieldsTable();
            }
        };
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseAvroStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo avroPathColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Path", (String[])new String[0]), 1, false, true);
        ColumnInfo nameColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo typeColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        ColumnInfo formatColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Format", (String[])new String[0]), 2, Const.getDateFormats());
        ColumnInfo[] parameterColumns = new ColumnInfo[]{avroPathColumnInfo, nameColumnInfo, typeColumnInfo, formatColumnInfo};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        parameterColumns[3].setAutoResize(false);
        this.wInputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 7, null, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 40, 20, 20, 20});
        this.wInputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wInputFields);
        new BaseAvroStepDialog.FD((Control)this.wInputFields).left(0, 0).right(100, 0).top((Control)this.wPassThruFields, 10).bottom((Control)wGetFields, -10).apply();
        this.wInputFields.setRowNums();
        this.wInputFields.optWidth(true);
        new BaseAvroStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wInputFields.getTable());
        this.setTruncatedColumn(this.wInputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wInputFields.getTable(), 1);
        }
    }

    private void addSchemaTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Schema.TabTitle", (String[])new String[0]));
        Composite wTabComposite = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wTabComposite);
        this.props.setLook((Control)wTabComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        wTabComposite.setLayout((Layout)formLayout);
        Group wSourceGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)wSourceGroup);
        wSourceGroup.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Schema.SourceTitle", (String[])new String[0]));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        wSourceGroup.setLayout((Layout)layout);
        FormData fdSource = new FormData();
        fdSource.top = new FormAttachment(0, 0);
        fdSource.right = new FormAttachment(100, -15);
        fdSource.left = new FormAttachment(0, 15);
        wSourceGroup.setLayoutData((Object)fdSource);
        Label wlSchemaPath = new Label((Composite)wSourceGroup, 131072);
        wlSchemaPath.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Schema.FileName", (String[])new String[0]));
        this.props.setLook((Control)wlSchemaPath);
        new BaseAvroStepDialog.FD((Control)wlSchemaPath).left(0, 0).top(0, 0).apply();
        this.wSchemaPath = new TextVar((VariableSpace)this.transMeta, (Composite)wSourceGroup, 18436);
        this.props.setLook((Control)this.wSchemaPath);
        new BaseAvroStepDialog.FD((Control)this.wSchemaPath).left(0, 0).top((Control)wlSchemaPath, 5).width(350 + VAR_EXTRA_WIDTH).rright().apply();
        this.wbSchemaBrowse = new Button((Composite)wSourceGroup, 8);
        this.props.setLook((Control)this.wbSchemaBrowse);
        this.wbSchemaBrowse.setText(this.getMsg("System.Button.Browse"));
        this.wbSchemaBrowse.addListener(13, event -> this.browseForFileInputPathForSchema());
        int bOffset = (this.wbSchemaBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wSchemaPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        new BaseAvroStepDialog.FD((Control)this.wbSchemaBrowse).left((Control)this.wSchemaPath, 5).top((Control)wlSchemaPath, 5 - bOffset).apply();
        layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wSourceGroup.setLayout((Layout)layout);
    }

    private void browseForFileInputPathForSchema() {
        try {
            String fileName;
            VfsFileChooserDialog fileChooserDialog;
            String path = this.transMeta.environmentSubstitute(this.wSchemaPath.getText());
            if (Utils.isEmpty((CharSequence)path)) {
                fileChooserDialog = this.getVfsFileChooserDialog(null, null);
                fileName = "hdfs://";
            } else {
                FileObject initialFile = this.getInitialFile(this.wSchemaPath.getText());
                FileObject rootFile = initialFile.getFileSystem().getRoot();
                fileChooserDialog = this.getVfsFileChooserDialog(rootFile, initialFile);
                fileName = null;
            }
            FileObject selectedFile = fileChooserDialog.open(this.shell, null, this.getSchemeFromPath(path), true, fileName, FILES_FILTERS, fileFilterNames, true, 2, true, true);
            if (selectedFile != null) {
                this.wSchemaPath.setText(selectedFile.getURL().toString());
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.FileSystemException"));
        }
    }

    @Override
    protected void getData(AvroInputMeta meta) {
        if (meta.getFilename() != null) {
            this.wPath.setText(meta.getFilename());
        }
        if (meta.getSchemaFilename() != null) {
            this.wSchemaPath.setText(meta.getSchemaFilename());
        }
        this.wPassThruFields.setSelection(((FormatInputFile)meta.inputFiles).passingThruFields);
        int itemIndex = 0;
        for (AvroInputField inputField : meta.getInputFields()) {
            TableItem item = null;
            item = itemIndex < this.wInputFields.table.getItemCount() ? this.wInputFields.table.getItem(itemIndex) : new TableItem(this.wInputFields.table, 0);
            if (inputField.getAvroFieldName() != null) {
                if (inputField.getAvroType() != null) {
                    item.setText(1, this.concatenateAvroNameAndType(inputField.getDisplayableAvroFieldName(), inputField.getAvroType()));
                } else {
                    item.setText(1, inputField.getDisplayableAvroFieldName());
                }
            }
            if (inputField.getPentahoFieldName() != null) {
                item.setText(2, inputField.getPentahoFieldName());
            }
            if (inputField.getTypeDesc() != null) {
                item.setText(3, inputField.getTypeDesc());
            }
            if (inputField.getStringFormat() != null) {
                item.setText(4, inputField.getStringFormat());
            } else {
                item.setText(4, "");
            }
            ++itemIndex;
        }
    }

    @Override
    protected void getInfo(AvroInputMeta meta, boolean preview) {
        meta.setFilename(this.wPath.getText());
        meta.setSchemaFilename(this.wSchemaPath.getText());
        ((FormatInputFile)meta.inputFiles).passingThruFields = this.wPassThruFields.getSelection();
        meta.setUseFieldAsInputStream(this.wbGetFileFromField.getSelection());
        meta.setInputStreamFieldName(this.wFieldNameCombo.getText());
        int nrFields = this.wInputFields.nrNonEmpty();
        meta.inputFields = new AvroInputField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wInputFields.getNonEmpty(i);
            AvroInputField field = new AvroInputField();
            field.setFormatFieldName(this.extractFieldName(item.getText(1)));
            field.setAvroType(this.extractAvroType(item.getText(1)));
            field.setPentahoFieldName(item.getText(2));
            field.setPentahoType(ValueMetaFactory.getIdForValueMeta((String)item.getText(3)));
            field.setStringFormat(item.getText(4));
            ((AvroInputField[])meta.inputFields)[i] = field;
        }
    }

    private String extractFieldName(String parquetNameTypeFromUI) {
        if (parquetNameTypeFromUI != null && parquetNameTypeFromUI.indexOf("(") >= 0) {
            return StringUtils.substringBefore((String)parquetNameTypeFromUI, (String)"(").trim();
        }
        return parquetNameTypeFromUI;
    }

    private String getSchemeFromPath(String path) {
        if (Utils.isEmpty((CharSequence)path)) {
            return SCHEMA_SCHEME_DEFAULT;
        }
        int endIndex = path.indexOf(58);
        if (endIndex > 0) {
            return path.substring(0, endIndex);
        }
        return SCHEMA_SCHEME_DEFAULT;
    }

    private void doPreview() {
        this.getInfo((AvroInputMeta)this.meta, true);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)((StepMetaInterface)this.meta), (String)this.wStepname.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 554;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Shell.Title", (String[])new String[0]);
    }

    @Override
    protected Listener getPreview() {
        return new Listener(){

            public void handleEvent(Event e) {
                AvroInputDialog.this.doPreview();
            }
        };
    }
}

