/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InconsistentAmazonS3Client
extends AmazonS3Client {
    public static final String DELAY_KEY_SUBSTRING = "DELAY_LISTING_ME";
    public static final long DELAY_KEY_MILLIS = 5000L;
    private static final Logger LOG = LoggerFactory.getLogger(InconsistentAmazonS3Client.class);
    private Map<String, Delete> delayedDeletes = new HashMap<String, Delete>();
    private Map<String, Long> delayedPutKeys = new HashMap<String, Long>();

    public InconsistentAmazonS3Client(AWSCredentialsProvider credentials, ClientConfiguration clientConfiguration) {
        super(credentials, clientConfiguration);
    }

    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("key {}", (Object)deleteObjectRequest.getKey());
        this.registerDeleteObject(deleteObjectRequest);
        super.deleteObject(deleteObjectRequest);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("key {}", (Object)putObjectRequest.getKey());
        this.registerPutObject(putObjectRequest);
        return super.putObject(putObjectRequest);
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("prefix {}", (Object)listObjectsRequest.getPrefix());
        ObjectListing listing = super.listObjects(listObjectsRequest);
        listing = this.filterListObjects(listObjectsRequest, listing);
        listing = this.restoreListObjects(listObjectsRequest, listing);
        return listing;
    }

    private boolean addIfNotPresent(List<S3ObjectSummary> list, S3ObjectSummary item) {
        String key = item.getKey();
        for (S3ObjectSummary member : list) {
            if (!member.getKey().equals(key)) continue;
            return false;
        }
        return list.add(item);
    }

    private ObjectListing restoreListObjects(ListObjectsRequest request, ObjectListing rawListing) {
        List outputList = rawListing.getObjectSummaries();
        List outputPrefixes = rawListing.getCommonPrefixes();
        for (String key : new HashSet<String>(this.delayedDeletes.keySet())) {
            Delete delete = this.delayedDeletes.get(key);
            if (this.isKeyDelayed(delete.time(), key)) {
                if (!key.startsWith(request.getPrefix())) continue;
                if (delete.summary == null) {
                    if (outputPrefixes.contains(key)) continue;
                    outputPrefixes.add(key);
                    continue;
                }
                this.addIfNotPresent(outputList, delete.summary());
                continue;
            }
            this.delayedDeletes.remove(key);
        }
        return new CustomObjectListing(rawListing, outputList, outputPrefixes);
    }

    private ObjectListing filterListObjects(ListObjectsRequest request, ObjectListing rawListing) {
        ArrayList<S3ObjectSummary> outputList = new ArrayList<S3ObjectSummary>();
        for (S3ObjectSummary s : rawListing.getObjectSummaries()) {
            String key = s.getKey();
            if (this.isKeyDelayed(this.delayedPutKeys.get(key), key)) continue;
            outputList.add(s);
        }
        ArrayList<String> outputPrefixes = new ArrayList<String>();
        for (String key : rawListing.getCommonPrefixes()) {
            if (this.isKeyDelayed(this.delayedPutKeys.get(key), key)) continue;
            outputPrefixes.add(key);
        }
        return new CustomObjectListing(rawListing, outputList, outputPrefixes);
    }

    private boolean isKeyDelayed(Long enqueueTime, String key) {
        long deadline;
        if (enqueueTime == null) {
            LOG.debug("no delay for key {}", (Object)key);
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= (deadline = enqueueTime + 5000L)) {
            this.delayedDeletes.remove(key);
            LOG.debug("no longer delaying {}", (Object)key);
            return false;
        }
        LOG.info("delaying {}", (Object)key);
        return true;
    }

    private void registerDeleteObject(DeleteObjectRequest req) {
        String key = req.getKey();
        if (this.shouldDelay(key)) {
            S3ObjectSummary summary = null;
            ObjectListing list = this.listObjects(req.getBucketName(), key);
            for (S3ObjectSummary result : list.getObjectSummaries()) {
                if (!result.getKey().equals(key)) continue;
                summary = result;
                break;
            }
            this.delayedDeletes.put(key, new Delete(System.currentTimeMillis(), summary));
        }
    }

    private void registerPutObject(PutObjectRequest req) {
        String key = req.getKey();
        if (this.shouldDelay(key)) {
            this.enqueueDelayedPut(key);
        }
    }

    private boolean shouldDelay(String key) {
        boolean delay = key.contains(DELAY_KEY_SUBSTRING);
        LOG.debug("{} -> {}", (Object)key, (Object)delay);
        return delay;
    }

    private void enqueueDelayedPut(String key) {
        LOG.debug("delaying put of {}", (Object)key);
        this.delayedPutKeys.put(key, System.currentTimeMillis());
    }

    private static class CustomObjectListing
    extends ObjectListing {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        public CustomObjectListing(ObjectListing rawListing, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(rawListing.getBucketName());
            this.setCommonPrefixes(rawListing.getCommonPrefixes());
            this.setDelimiter(rawListing.getDelimiter());
            this.setEncodingType(rawListing.getEncodingType());
            this.setMarker(rawListing.getMarker());
            this.setMaxKeys(rawListing.getMaxKeys());
            this.setNextMarker(rawListing.getNextMarker());
            this.setPrefix(rawListing.getPrefix());
            this.setTruncated(rawListing.isTruncated());
        }

        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }

    private static class Delete {
        private Long time;
        private S3ObjectSummary summary;

        Delete(Long time, S3ObjectSummary summary) {
            this.time = time;
            this.summary = summary;
        }

        public Long time() {
            return this.time;
        }

        public S3ObjectSummary summary() {
            return this.summary;
        }
    }
}

