/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.control.ControlNodeActionExecutor;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionKillXCommand;
import org.apache.oozie.command.wf.WfEndXCommand;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.db.SLADbXOperations;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class KillXCommand
extends WorkflowXCommand<Void> {
    private String wfId;
    private WorkflowJobBean wfJob;
    private List<WorkflowActionBean> actionList;
    private ActionService actionService;
    private JPAService jpaService = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public KillXCommand(String wfId) {
        super("kill", "kill", 1);
        this.wfId = ParamChecker.notEmpty(wfId, "wfId");
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.wfId);
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.wfId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.wfId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_KILL, this.wfId);
            this.actionList = this.jpaService.execute(new WorkflowActionsGetForJobJPAExecutor(this.wfId));
            LogUtils.setLogInfo(this.wfJob);
            this.actionService = Services.get().get(ActionService.class);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfJob.getStatus() != WorkflowJob.Status.PREP && this.wfJob.getStatus() != WorkflowJob.Status.RUNNING && this.wfJob.getStatus() != WorkflowJob.Status.SUSPENDED && this.wfJob.getStatus() != WorkflowJob.Status.FAILED) {
            throw new PreconditionException(ErrorCode.E0725, this.wfJob.getId());
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("STARTED WorkflowKillXCommand for jobId=" + this.wfId);
        this.wfJob.setEndTime(new Date());
        if (this.wfJob.getStatus() != WorkflowJob.Status.FAILED) {
            InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
            this.wfJob.setStatus(WorkflowJob.Status.KILLED);
            SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(this.wfJob.getSlaXml(), this.wfJob.getId(), SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_JOB);
            if (slaEvent != null) {
                this.insertList.add(slaEvent);
            }
            try {
                this.wfJob.getWorkflowInstance().kill();
            }
            catch (WorkflowException e) {
                throw new CommandException(ErrorCode.E0725, e.getMessage(), e);
            }
            WorkflowInstance wfInstance = this.wfJob.getWorkflowInstance();
            ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.KILLED);
            this.wfJob.setWorkflowInstance(wfInstance);
        }
        try {
            for (WorkflowActionBean action : this.actionList) {
                if (action.getStatus() == WorkflowAction.Status.RUNNING || action.getStatus() == WorkflowAction.Status.DONE) {
                    if (!(this.actionService.getExecutor(action.getType()) instanceof ControlNodeActionExecutor)) {
                        action.setPending();
                    }
                    action.setStatus(WorkflowAction.Status.KILLED);
                    this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, action));
                    this.queue(new ActionKillXCommand(action.getId(), action.getType()));
                    continue;
                }
                if (action.getStatus() != WorkflowAction.Status.PREP && action.getStatus() != WorkflowAction.Status.START_RETRY && action.getStatus() != WorkflowAction.Status.START_MANUAL && action.getStatus() != WorkflowAction.Status.END_RETRY && action.getStatus() != WorkflowAction.Status.END_MANUAL && action.getStatus() != WorkflowAction.Status.USER_RETRY) continue;
                action.setStatus(WorkflowAction.Status.KILLED);
                action.resetPending();
                SLAEventBean slaEvent = SLADbXOperations.createStatusEvent(action.getSlaXml(), action.getId(), SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                if (slaEvent != null) {
                    this.insertList.add(slaEvent);
                }
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, action));
                if (!EventHandlerService.isEnabled() || this.actionService.getExecutor(action.getType()) instanceof ControlNodeActionExecutor) continue;
                this.generateEvent(action, this.wfJob.getUser());
            }
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END, this.wfJob));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
            if (EventHandlerService.isEnabled()) {
                KillXCommand.generateEvent(this.wfJob);
            }
            this.queue(new WorkflowNotificationXCommand(this.wfJob));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        finally {
            if (this.wfJob.getStatus() == WorkflowJob.Status.KILLED) {
                new WfEndXCommand(this.wfJob).call();
            }
            this.updateParentIfNecessary(this.wfJob);
        }
        this.LOG.info("ENDED WorkflowKillXCommand for jobId=" + this.wfId);
        return null;
    }
}

