/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.DialectUtil;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class GoogleBigQueryDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(GoogleBigQueryDialect.class, Dialect.DatabaseProduct.GOOGLEBIGQUERY);

    public GoogleBigQueryDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean allowsOrderByAlias() {
        return true;
    }

    @Override
    public boolean allowsAs() {
        return true;
    }

    @Override
    public boolean allowsDdl() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public void quoteIdentifier(String val, StringBuilder buf) {
        super.quoteIdentifier(val.replace(' ', '_').replaceAll("[^A-Za-z0-9\\_\\.`]", ""), buf);
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String s) {
        buf.append('\'');
        s = Util.replace(s, "\\", "\\\\");
        s = Util.replace(s, "'", "\\'");
        buf.append(s);
        buf.append('\'');
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        javaRegex = DialectUtil.cleanUnicodeAwareCaseFlag(javaRegex);
        javaRegex = javaRegex.replace("\\Q", "");
        javaRegex = javaRegex.replace("\\E", "");
        StringBuilder sb = new StringBuilder();
        sb.append("cast(");
        sb.append(source);
        sb.append(" as string) is not null and ");
        sb.append("REGEXP_CONTAINS( cast(");
        sb.append(source);
        sb.append(" as string), r");
        this.quoteStringLiteral(sb, javaRegex);
        sb.append(")");
        return sb.toString();
    }
}

