/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.pentaho.osgi.platform.plugin.deployer.impl.BundleStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformDeployerBundleListener
implements BundleListener {
    private static Logger log = LoggerFactory.getLogger(PlatformDeployerBundleListener.class);
    private BundleContext bundleContext;
    private BundleStateManager bundleStateManager;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBundleStateManager(BundleStateManager bundleStateManager) {
        this.bundleStateManager = bundleStateManager;
    }

    static void setLog(Logger log) {
        PlatformDeployerBundleListener.log = log;
    }

    static Logger getLog() {
        return log;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: 
            case 16: {
                if (event.getBundle().getHeaders().get("Bundle-PlatformPluginName") == null) break;
                String bundleStr = (String)event.getBundle().getHeaders().get("Bundle-Name") + (String)event.getBundle().getHeaders().get("Bundle-Version");
                log.info("Received Bundle event : {}", (Object)(bundleStr + (event.getType() == 1 ? "Installed" : "Uninstalled")));
                this.bundleStateManager.setState(bundleStr, event.getType());
            }
        }
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
    }
}

