/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeChildren;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.dom.DocumentFactory;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.tags.SwtTreeRow;

public class SwtTreeItem
extends AbstractSwtXulContainer
implements XulTreeItem {
    private static final Log logger = LogFactory.getLog(SwtTreeItem.class);
    private XulTreeRow row;
    private XulTreeChildren treeChildren;
    private String image;
    private XulDomContainer domContainer;
    private boolean expanded;
    private Reference boundObjectRef;

    public SwtTreeItem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("treeitem");
        this.domContainer = domContainer;
        this.setManagedObject("empty");
    }

    public SwtTreeItem(XulTreeRow row) {
        super("treeitem");
        try {
            this.element = DocumentFactory.createElement((String)"treeitem", (XulComponent)this);
        }
        catch (XulException e) {
            throw new IllegalArgumentException("error creating treeitem", e);
        }
        super.addChild((Element)row);
        this.row = row;
        this.setManagedObject("empty");
    }

    public SwtTreeItem(XulTreeChildren parent) {
        super("treeitem");
        this.setManagedObject("empty");
    }

    public XulTreeRow getRow() {
        return this.row;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isHierarchical() {
        return false;
    }

    public void remove() {
    }

    public void setContainer(boolean isContainer) {
    }

    public void setEmpty(boolean empty) {
    }

    public void setRow(XulTreeRow row) {
        this.row = row;
        super.addChild((Element)row);
    }

    @Override
    public void layout() {
        if (this.getChildNodes().size() > 1) {
            for (Element comp : this.getChildNodes()) {
                if (comp instanceof XulTreeRow) {
                    this.row = (SwtTreeRow)comp;
                    continue;
                }
                this.treeChildren = (XulTreeChildren)comp;
            }
        } else {
            for (Element comp : this.getChildNodes()) {
                if (!(comp instanceof XulTreeRow)) continue;
                this.row = (SwtTreeRow)comp;
            }
        }
        this.initialized = true;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String src) {
        XulTree tree;
        this.image = src;
        if (this.initialized && (tree = this.getTree()) != null) {
            tree.update();
        }
    }

    @Override
    public void setTooltiptext(String tooltip) {
        XulTree tree;
        super.setTooltiptext(tooltip);
        if (this.initialized && (tree = this.getTree()) != null) {
            tree.update();
        }
    }

    public XulTree getTree() {
        XulTree tree = null;
        for (XulComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof XulTree)) continue;
            tree = (XulTree)parent;
            break;
        }
        return tree;
    }

    public void setXulDomContainer(XulDomContainer container) {
        this.domContainer = container;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        XulTree tree;
        this.expanded = expanded;
        if (this.initialized && (tree = this.getTree()) != null) {
            tree.setTreeItemExpanded((XulTreeItem)this, expanded);
        }
        this.changeSupport.firePropertyChange("expanded", null, (Object)expanded);
    }

    public Object getBoundObject() {
        if (this.boundObjectRef != null) {
            return this.boundObjectRef.get();
        }
        return null;
    }

    public void setBoundObject(Object obj) {
        this.boundObjectRef = new WeakReference<Object>(obj);
    }

    public void setClassname(String classname) {
    }

    public String getClassname() {
        return null;
    }
}

