/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.clients.Query;
import org.pentaho.di.trans.dataservice.jdbc.ThinServiceInformation;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinServiceInformation;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.metastore.api.IMetaStore;

public class DataServiceClient
implements IDataServiceClientService {
    private final Query.Service queryService;
    private final DataServiceResolver resolver;
    private final ExecutorService executorService;
    private LogChannelInterface log;

    public DataServiceClient(Query.Service queryService, DataServiceResolver resolver, ExecutorService executorService) {
        this.queryService = queryService;
        this.resolver = resolver;
        this.executorService = executorService;
    }

    public DataInputStream query(String sqlQuery, int maxRows) throws SQLException {
        return this.query(sqlQuery, maxRows, (Map<String, String>)ImmutableMap.of());
    }

    public DataInputStream query(String sqlQuery, int maxRows, Map<String, String> params) throws SQLException {
        try {
            SafePipedStreams pipe = new SafePipedStreams();
            Query query = this.prepareQuery(sqlQuery, maxRows, params);
            this.executorService.execute(() -> {
                try (PipedOutputStream out = pipe.out;){
                    query.writeTo(out);
                }
                catch (Exception e) {
                    this.log.logError(e.getMessage(), (Throwable)e);
                }
            });
            return new DataInputStream(pipe.in);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SQLException.class);
            throw new SQLException(e);
        }
    }

    public DataInputStream query(String sqlQuery, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) throws SQLException {
        return this.query(sqlQuery, windowMode, windowSize, windowEvery, windowLimit, (Map<String, String>)ImmutableMap.of());
    }

    public DataInputStream query(String sqlQuery, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit, Map<String, String> params) throws SQLException {
        try {
            SafePipedStreams pipe = new SafePipedStreams();
            Query query = this.prepareQuery(sqlQuery, windowMode, windowSize, windowEvery, windowLimit, params);
            this.executorService.execute(() -> {
                try (PipedOutputStream out = pipe.out;){
                    query.writeTo(out);
                }
                catch (Exception e) {
                    this.log.logError(e.getMessage(), (Throwable)e);
                }
            });
            return new DataInputStream(pipe.in);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SQLException.class);
            throw new SQLException(e);
        }
    }

    public Query prepareQuery(String sql, int maxRows, Map<String, String> parameters) throws KettleException {
        Query query = this.queryService.prepareQuery(sql, maxRows, this.collectParameters(parameters));
        if (query != null) {
            return query;
        }
        throw new KettleException("Unable to resolve query: " + sql);
    }

    public Query prepareQuery(String sql, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit, Map<String, String> parameters) throws KettleException {
        Query query = this.queryService.prepareQuery(sql, windowMode, windowSize, windowEvery, windowLimit, this.collectParameters(parameters));
        if (query != null) {
            return query;
        }
        throw new KettleException("Unable to resolve query: " + sql);
    }

    public List<IThinServiceInformation> getServiceInformation() throws SQLException {
        ArrayList services = Lists.newArrayList();
        for (DataServiceMeta service : this.resolver.getDataServices((Function<Exception, Void>)((Function)this.logErrors()::apply))) {
            TransMeta transMeta = service.getServiceTrans();
            try {
                transMeta.activateParameters();
                RowMetaInterface serviceFields = transMeta.getStepFields(service.getStepname());
                ThinServiceInformation serviceInformation = new ThinServiceInformation(service.getName(), service.isStreaming(), serviceFields);
                services.add(serviceInformation);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Unable to get fields for service {0}, transformation: {1}", service.getName(), transMeta.getName());
                this.log.logError(message, (Throwable)e);
            }
        }
        return services;
    }

    public ThinServiceInformation getServiceInformation(String name) throws SQLException {
        DataServiceMeta dataServiceMeta = this.resolver.getDataService(name);
        if (dataServiceMeta != null) {
            TransMeta transMeta = dataServiceMeta.getServiceTrans();
            try {
                transMeta.activateParameters();
                RowMetaInterface serviceFields = transMeta.getStepFields(dataServiceMeta.getStepname());
                return new ThinServiceInformation(dataServiceMeta.getName(), dataServiceMeta.isStreaming(), serviceFields);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Unable to get fields for service {0}, transformation: {1}", dataServiceMeta.getName(), transMeta.getName());
                this.log.logError(message, (Throwable)e);
            }
        }
        return null;
    }

    public List<String> getServiceNames(String serviceName) throws SQLException {
        return this.resolver.getDataServiceNames(serviceName);
    }

    public List<String> getServiceNames() throws SQLException {
        return this.resolver.getDataServiceNames();
    }

    private java.util.function.Function<Exception, Void> logErrors() {
        return e -> {
            this.getLogChannel().logError("Unable to retrieve data service", (Throwable)e);
            return null;
        };
    }

    public void setLogChannel(LogChannelInterface log) {
        this.log = log;
    }

    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    @Deprecated
    public void setRepository(Repository repository) {
    }

    @Deprecated
    public void setMetaStore(IMetaStore metaStore) {
    }

    private Map<String, String> collectParameters(Map<String, String> map) {
        HashMap parameters = Maps.newHashMap();
        for (Map.Entry<String, String> parameterEntry : map.entrySet()) {
            String name = parameterEntry.getKey();
            String value = parameterEntry.getValue();
            if (!name.startsWith("PARAMETER_") || value == null) continue;
            parameters.put(name.substring("PARAMETER_".length()), value);
        }
        return ImmutableMap.copyOf((Map)parameters);
    }

    private static class SafePipedStreams {
        final PipedOutputStream out;
        final PipedInputStream in = new PipedInputStream(){

            @Override
            public void close() throws IOException {
                this.ifOpen(() -> open = false);
                super.close();
            }
        };
        private volatile boolean open = true;

        private SafePipedStreams() throws IOException {
            this.out = new PipedOutputStream(this.in){

                @Override
                public void write(int b) throws IOException {
                    this.ifOpen(() -> super.write(b));
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.ifOpen(() -> super.write(b, off, len));
                }
            };
        }

        private synchronized void ifOpen(IOExceptionAction action) throws IOException {
            if (this.open) {
                action.call();
            }
        }

        private static interface IOExceptionAction {
            public void call() throws IOException;
        }
    }
}

