/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming.execution;

import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamExecutionListener;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamingServiceTransExecutor;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class StreamingGeneratedTransExecution
implements Runnable {
    private final StreamingServiceTransExecutor serviceExecutor;
    private final Trans genTrans;
    private final RowListener resultRowListener;
    private final String injectorStepName;
    private final String resultStepName;
    private final String query;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private IDataServiceClientService.StreamingMode windowMode;
    private long windowSize;
    private long windowEvery;
    private long windowLimit;
    private boolean finished;

    public StreamingGeneratedTransExecution(StreamingServiceTransExecutor serviceExecutor, Trans genTrans, RowListener resultRowListener, String injectorStepName, String resultStepName, String query, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) {
        this.serviceExecutor = serviceExecutor;
        this.genTrans = genTrans;
        this.resultRowListener = resultRowListener;
        this.injectorStepName = injectorStepName;
        this.resultStepName = resultStepName;
        this.query = query;
        this.windowMode = windowMode;
        this.windowSize = windowSize;
        this.windowEvery = windowEvery;
        this.windowLimit = windowLimit;
    }

    @Override
    public void run() {
        StreamExecutionListener stream = this.serviceExecutor.getBuffer(this.query, this.windowMode, this.windowSize, this.windowEvery, this.windowLimit);
        try {
            if (stream == null) {
                this.runGenTrans(Collections.emptyList());
            } else {
                this.runGenTrans(stream.getCachedWindow());
            }
        }
        catch (KettleStepException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void runGenTrans(List<RowMetaAndData> rowIterator) throws KettleStepException {
        if (this.isRunning.compareAndSet(false, true)) {
            try {
                LogChannelInterface log = this.genTrans.getLogChannel();
                this.genTrans.cleanup();
                this.genTrans.prepareExecution(null);
                RowProducer rowProducer = this.genTrans.addRowProducer(this.injectorStepName, 0);
                this.genTrans.startThreads();
                StepInterface resultStep = this.genTrans.findRunThread(this.resultStepName);
                resultStep.cleanup();
                resultStep.addRowListener(this.resultRowListener);
                for (RowMetaAndData injectRows : rowIterator) {
                    while (!rowProducer.putRowWait(injectRows.getRowMeta(), injectRows.getData(), 1L, TimeUnit.SECONDS) && this.genTrans.isRunning()) {
                        log.logRowlevel("Row buffer is full, trying again");
                    }
                }
                rowProducer.finished();
                this.genTrans.waitUntilFinished();
                this.genTrans.stopAll();
                log.logDetailed("Generated transformation stopped");
            }
            catch (KettleException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }
}

