/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming.execution;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.execution.PrepareExecution;
import org.pentaho.di.trans.dataservice.execution.TransStarter;
import org.pentaho.di.trans.dataservice.streaming.StreamList;
import org.pentaho.di.trans.dataservice.streaming.StreamServiceKey;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamExecutionListener;
import org.pentaho.di.trans.dataservice.utils.DataServiceConstants;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class StreamingServiceTransExecutor {
    private final Trans serviceTrans;
    private final StreamServiceKey key;
    private final String serviceStepName;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean isStopping = new AtomicBoolean(false);
    private StreamList<RowMetaAndData> stepStream;
    private long lastCacheCleanupMillis = 0L;
    private int windowMaxRowLimit;
    private long windowMaxTimeLimit;
    private final Cache<String, StreamExecutionListener> serviceListeners = CacheBuilder.newBuilder().expireAfterAccess(120L, DataServiceConstants.STREAMING_CACHE_TIME_UNIT).removalListener((RemovalListener)new RemovalListener<String, StreamExecutionListener>(){

        public void onRemoval(RemovalNotification<String, StreamExecutionListener> removal) {
            LogChannelInterface log = StreamingServiceTransExecutor.this.serviceTrans.getLogChannel();
            ((StreamExecutionListener)removal.getValue()).unSubscribe();
            log.logDebug("Streaming cache listener removed: " + (String)removal.getKey());
        }
    }).softValues().build();

    public StreamingServiceTransExecutor(StreamServiceKey key, Trans serviceTrans, String serviceStepName, int windowMaxRowLimit, long windowMaxTimeLimit) {
        this.serviceTrans = serviceTrans;
        this.key = key;
        this.serviceStepName = serviceStepName;
        this.windowMaxRowLimit = windowMaxRowLimit;
        this.windowMaxTimeLimit = windowMaxTimeLimit;
    }

    public Trans getServiceTrans() {
        return this.serviceTrans;
    }

    public StreamServiceKey getKey() {
        return this.key;
    }

    public long getWindowMaxRowLimit() {
        return this.windowMaxRowLimit;
    }

    public long getWindowMaxTimeLimit() {
        return this.windowMaxTimeLimit;
    }

    public StreamExecutionListener getBuffer(String query, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) {
        long maxTime;
        boolean rowBased = IDataServiceClientService.StreamingMode.ROW_BASED.equals((Object)windowMode);
        boolean timeBased = IDataServiceClientService.StreamingMode.TIME_BASED.equals((Object)windowMode);
        int maxRows = windowLimit > 0L && timeBased ? (int)Math.min(windowLimit, (long)this.windowMaxRowLimit) : this.windowMaxRowLimit;
        long l = maxTime = windowLimit > 0L && rowBased ? Math.min(windowLimit, this.windowMaxTimeLimit) : this.windowMaxTimeLimit;
        long l2 = windowSize <= 0L ? 0L : (windowSize = timeBased ? Math.min(windowSize, maxTime) : Math.min(windowSize, (long)maxRows));
        long l3 = windowEvery <= 0L ? 0L : (windowEvery = timeBased ? Math.min(windowEvery, maxTime) : Math.min(windowEvery, (long)maxRows));
        if (windowSize == 0L) {
            return null;
        }
        String cacheId = this.getCacheKey(query, windowMode, windowSize, windowEvery, maxRows, maxTime);
        StreamExecutionListener streamListener = (StreamExecutionListener)this.serviceListeners.getIfPresent((Object)cacheId);
        if (streamListener == null) {
            if (this.stepStream == null) {
                this.stepStream = new StreamList();
            }
            streamListener = new StreamExecutionListener(this.stepStream.getStream(), windowMode, windowSize, windowEvery, maxRows, maxTime);
            this.serviceListeners.put((Object)cacheId, (Object)streamListener);
        }
        if (this.isRunning.compareAndSet(false, true)) {
            this.startService();
        }
        return streamListener;
    }

    private String getCacheKey(String query, IDataServiceClientService.StreamingMode mode, long size, long every, int maxRows, long maxTime) {
        return query.concat(mode.toString()).concat("-").concat(String.valueOf(size)).concat("-").concat(String.valueOf(every)).concat("-").concat(String.valueOf(maxRows)).concat("-").concat(String.valueOf(maxTime));
    }

    private void startService() {
        this.lastCacheCleanupMillis = System.currentTimeMillis();
        PrepareExecution prepExec = new PrepareExecution(this.serviceTrans);
        Runnable serviceTransWiring = this.getServiceTransWiring();
        TransStarter startTrans = new TransStarter(this.serviceTrans);
        prepExec.run();
        serviceTransWiring.run();
        startTrans.run();
    }

    private Runnable getServiceTransWiring() {
        return () -> {
            final Trans trans = this.serviceTrans;
            StepInterface serviceStep = trans.findRunThread(this.serviceStepName);
            if (serviceStep == null) {
                throw Throwables.propagate((Throwable)new KettleException("Service step is not accessible"));
            }
            serviceStep.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    LogChannelInterface log = trans.getLogChannel();
                    try {
                        log.logRowlevel("Passing along row: " + rowMeta.getString(row));
                    }
                    catch (KettleValueException kettleValueException) {
                        // empty catch block
                    }
                    StreamingServiceTransExecutor.this.serviceCacheCleanup();
                    if (StreamingServiceTransExecutor.this.serviceListeners.size() > 0L) {
                        RowMetaAndData rowData = new RowMetaAndData();
                        rowData.setRowMeta(rowMeta);
                        rowData.setData(row);
                        StreamingServiceTransExecutor.this.stepStream.add(rowData);
                    } else {
                        StreamingServiceTransExecutor.this.stopService();
                    }
                }
            });
        };
    }

    private void serviceCacheCleanup() {
        long updateTime = this.lastCacheCleanupMillis + 130000L;
        long currentTime = System.currentTimeMillis();
        if (updateTime <= currentTime) {
            this.serviceListeners.cleanUp();
            this.lastCacheCleanupMillis = currentTime;
        }
    }

    public void clearCache() {
        this.serviceListeners.invalidateAll();
        this.serviceListeners.cleanUp();
    }

    private void stopService() {
        if (this.isRunning.get() && this.isStopping.compareAndSet(false, true)) {
            LogChannelInterface log = this.serviceTrans.getLogChannel();
            this.serviceTrans.stopAll();
            this.isRunning.set(false);
            this.isStopping.set(false);
            log.logDetailed("Streaming transformation stopped");
        }
    }

    public void stopAll() {
        this.stopService();
        this.clearCache();
    }
}

