/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.www;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.CarteServlet;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.clients.DataServiceClient;
import org.pentaho.di.trans.dataservice.clients.Query;
import org.pentaho.di.www.BaseCartePlugin;
import org.pentaho.di.www.CarteRequestHandler;

@CarteServlet(id="sql", name="Get data from a data service", description="Get data from a transformation data service using SQL")
public class TransDataServlet
extends BaseCartePlugin {
    private static final long serialVersionUID = 3634806745372015720L;
    private static final String MAX_ROWS = "MaxRows";
    private static final String SQL = "SQL";
    private final DataServiceClient client;
    public static final String CONTEXT_PATH = "/sql";

    public TransDataServlet(DataServiceClient client) {
        this.client = client;
        this.log = client.getLogChannel();
    }

    public void handleRequest(CarteRequestHandler.CarteRequest request) throws IOException {
        String sqlQuery;
        String string = sqlQuery = !Strings.isNullOrEmpty((String)request.getParameter(SQL)) ? request.getParameter(SQL) : request.getHeader(SQL);
        if (Strings.isNullOrEmpty((String)sqlQuery)) {
            String sqlParamMissing = "SQL not specified";
            this.logError(sqlParamMissing);
            request.respond(400).withMessage(sqlParamMissing);
            return;
        }
        String maxRowsValue = !Strings.isNullOrEmpty((String)request.getParameter(MAX_ROWS)) ? request.getParameter(MAX_ROWS) : request.getHeader(MAX_ROWS);
        int maxRows = Const.toInt((String)maxRowsValue, (int)-1);
        String debugTransFile = request.getParameter("debugtrans");
        Map<String, String> parameters = this.collectParameters(request.getParameters());
        try {
            final Query query = this.client.prepareQuery(sqlQuery, maxRows, parameters);
            List<Trans> transList = query.getTransList();
            for (Trans trans : transList) {
                this.monitorTransformation(trans);
            }
            if (!Strings.isNullOrEmpty((String)debugTransFile) && !transList.isEmpty()) {
                this.saveGeneratedTransformation(((Trans)Iterables.getLast(transList)).getTransMeta(), debugTransFile);
            }
            request.respond(200).with("binary/jdbc", new CarteRequestHandler.OutputStreamResponse(){

                public void write(OutputStream outputStream) throws IOException {
                    query.writeTo(outputStream);
                }
            });
        }
        catch (Exception e) {
            this.logError("Error executing SQL query: " + sqlQuery, e);
            request.respond(400).withMessage(Strings.nullToEmpty((String)e.getMessage()).trim());
        }
    }

    private void monitorTransformation(Trans trans) {
        TransMeta transMeta = trans.getTransMeta();
        TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration();
        TransConfiguration config = new TransConfiguration(transMeta, executionConfiguration);
        this.transformationMap.addTransformation(transMeta.getName(), trans.getContainerObjectId(), trans, config);
    }

    private void saveGeneratedTransformation(TransMeta genTransMeta, String debugTrans) {
        try {
            FileOutputStream fos = new FileOutputStream(debugTrans);
            fos.write(XMLHandler.getXMLHeader((String)"UTF-8").getBytes("UTF-8"));
            fos.write(genTransMeta.getXML().getBytes("UTF-8"));
            fos.close();
        }
        catch (Exception e) {
            this.logError("Unable to write dynamic transformation to file", e);
        }
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private Map<String, String> collectParameters(Map<String, Collection<String>> map) {
        HashMap parameters = Maps.newHashMap();
        for (Map.Entry<String, Collection<String>> parameterEntry : map.entrySet()) {
            String name = parameterEntry.getKey();
            Iterator<String> value = parameterEntry.getValue().iterator();
            if (!name.startsWith("PARAMETER_") || !value.hasNext()) continue;
            String firstVal = value.next();
            parameters.put(name.substring("PARAMETER_".length()), firstVal);
            if (!value.hasNext()) continue;
            this.logDetailed(String.format("More than one value associated with param %s.  Setting to first found (%s)", name, firstVal));
        }
        return ImmutableMap.copyOf((Map)parameters);
    }
}

