/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSContext;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class JmsDelegate {
    @Injection(name="DESTINATION")
    public String destinationName = "";
    @Injection(name="IBMMQ_URL")
    public String ibmUrl = "";
    @Injection(name="IBMMQ_USERNAME")
    public String ibmUsername = "";
    @Sensitive
    @Injection(name="IBMMQ_PASSWORD")
    public String ibmPassword = "";
    @Injection(name="AMQ_URL")
    public String amqUrl = "";
    @Injection(name="AMQ_USERNAME")
    public String amqUsername = "";
    @Sensitive
    @Injection(name="AMQ_PASSWORD")
    public String amqPassword = "";
    @Injection(name="CONNECTION_TYPE")
    public String connectionType = JmsProvider.ConnectionType.ACTIVEMQ.name();
    @Injection(name="DESTINATION_TYPE")
    public String destinationType = JmsProvider.DestinationType.QUEUE.name();
    @Injection(name="RECEIVE_TIMEOUT")
    public String receiveTimeout = "0";
    @Injection(name="MESSAGE_FIELD_NAME")
    public String messageField = "message";
    @Injection(name="DESTINATION_FIELD_NAME")
    public String destinationField = "destination";
    private final List<JmsProvider> jmsProviders;

    public JmsDelegate(List<JmsProvider> jmsProviders) {
        this.jmsProviders = jmsProviders;
    }

    Destination getDestination(VariableSpace variableSpace) {
        return this.getJmsProvider().getDestination(this, variableSpace);
    }

    JMSContext getJmsContext(VariableSpace variableSpace) {
        return this.getJmsProvider().getContext(this, variableSpace);
    }

    private JmsProvider getJmsProvider() {
        return this.jmsProviders.stream().filter(prov -> prov.supports(JmsProvider.ConnectionType.valueOf(this.connectionType))).findFirst().orElseThrow(() -> new RuntimeException(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDelegate.UnsupportedConnectionType", (String[])new String[0])));
    }

    RowMetaInterface getRowMeta() {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.messageField));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.destinationField));
        return rowMeta;
    }
}

