/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import java.util.ArrayList;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSProducer;
import org.apache.commons.lang.BooleanUtils;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.jms.JmsProducerMeta;

public class JmsProducer
extends BaseStep
implements StepInterface {
    private JmsProducerMeta meta;
    private JMSProducer producer;
    private Destination destination;
    private int messageIndex;

    public JmsProducer(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean errorsPresent;
        boolean isInitalized = super.init(stepMetaInterface, stepDataInterface);
        this.meta = (JmsProducerMeta)stepMetaInterface;
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        this.meta.check(remarks, this.getTransMeta(), this.meta.getParentStepMeta(), null, null, null, null, this.variables, this.getRepository(), this.getMetaStore());
        boolean bl = errorsPresent = remarks.stream().filter(result -> result.getType() == 4).peek(result -> this.logError(result.getText())).count() > 0L;
        if (errorsPresent) {
            return false;
        }
        return isInitalized;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JmsProducerMeta)smi;
        Object[] row = this.getRow();
        if (null == row) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.producer = this.meta.jmsDelegate.getJmsContext((VariableSpace)this).createProducer();
            this.destination = this.meta.jmsDelegate.getDestination((VariableSpace)this);
            this.messageIndex = this.getInputRowMeta().indexOfValue(this.environmentSubstitute(this.meta.getFieldToSend()));
            this.setOptions(this.producer);
            for (Map.Entry<String, String> entry : this.meta.getPropertyValuesByName().entrySet()) {
                String keySubstitute = this.environmentSubstitute(entry.getKey());
                String valueSubstitute = this.environmentSubstitute(entry.getValue());
                this.logDebug("Setting Jms Property Name: " + keySubstitute + ", Value: " + valueSubstitute);
                this.producer.setProperty(keySubstitute, valueSubstitute);
            }
            this.first = false;
        }
        this.producer.send(this.destination, row[this.messageIndex].toString());
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    private void setOptions(JMSProducer producer) {
        String optionValue = this.variables.environmentSubstitute(this.meta.getDisableMessageId());
        this.getLogChannel().logDebug("Disable Message ID is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDisableMessageID(BooleanUtils.toBoolean((String)optionValue));
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getDisableMessageTimestamp());
        this.getLogChannel().logDebug("Disable Message Timestamp is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDisableMessageTimestamp(BooleanUtils.toBoolean((String)optionValue));
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getDeliveryMode());
        this.getLogChannel().logDebug("Delivery Mode is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDeliveryMode(Integer.parseInt(optionValue));
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getPriority());
        this.getLogChannel().logDebug("Priority is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setPriority(Integer.parseInt(optionValue));
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getTimeToLive());
        this.getLogChannel().logDebug("Time to Live is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setTimeToLive(Long.parseLong(optionValue));
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getDeliveryDelay());
        this.getLogChannel().logDebug("Delivery Delay is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setDeliveryDelay(Long.parseLong(optionValue));
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getJmsCorrelationId());
        this.getLogChannel().logDebug("JMS Correlation ID is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setJMSCorrelationID(optionValue);
        }
        optionValue = this.variables.environmentSubstitute(this.meta.getJmsType());
        this.getLogChannel().logDebug("JMS Type is set to " + optionValue);
        if (!StringUtil.isEmpty((String)optionValue)) {
            producer.setJMSType(optionValue);
        }
    }
}

