/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.GenericStepData;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.util.serialization.ConfigHelper;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepOption;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.JmsProducer;
import org.pentaho.di.trans.step.jms.context.ActiveMQProvider;
import org.pentaho.metastore.api.IMetaStore;

@InjectionSupported(localizationPrefix="JmsProducerMeta.Injection.", groups={"PROPERTIES"})
@Step(id="Jms2Producer", image="JMSP.svg", name="JMS Producer", description="JmsProducerDialog.TypeLongDesc", categoryDescription="Streaming", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/JMS_Producer")
public class JmsProducerMeta
extends BaseSerializingMeta
implements StepMetaInterface,
Cloneable {
    static final Class<?> PKG = JmsProducerMeta.class;
    static final String FIELD_TO_SEND = "FIELD_TO_SEND";
    static final String PROPERTIES = "PROPERTIES";
    static final String PROPERTY_NAMES = "PROPERTY_NAMES";
    static final String PROPERTY_VALUES = "PROPERTY_VALUES";
    public static final String DISABLE_MESSAGE_ID = "DISABLE_MESSAGE_ID";
    public static final String DISABLE_MESSAGE_TIMESTAMP = "DISABLE_MESSAGE_TIMESTAMP";
    public static final String DELIVERY_MODE = "DELIVERY_MODE";
    public static final String PRIORITY = "PRIORITY";
    public static final String TIME_TO_LIVE = "TIME_TO_LIVE";
    public static final String DELIVERY_DELAY = "DELIVERY_DELAY";
    public static final String JMS_CORRELATION_ID = "JMS_CORRELATION_ID";
    public static final String JMS_TYPE = "JMS_TYPE";
    @InjectionDeep
    public final JmsDelegate jmsDelegate;
    @Injection(name="FIELD_TO_SEND")
    private String fieldToSend = "";
    @Injection(name="PROPERTY_NAMES", group="PROPERTIES")
    private List<String> propertyNames = new ArrayList<String>();
    @Injection(name="PROPERTY_VALUES", group="PROPERTIES")
    private List<String> propertyValues = new ArrayList<String>();
    @Injection(name="DISABLE_MESSAGE_ID")
    private String disableMessageId;
    @Injection(name="DISABLE_MESSAGE_TIMESTAMP")
    private String disableMessageTimestamp;
    @Injection(name="DELIVERY_MODE")
    private String deliveryMode;
    @Injection(name="PRIORITY")
    private String priority;
    @Injection(name="TIME_TO_LIVE")
    private String timeToLive;
    @Injection(name="DELIVERY_DELAY")
    private String deliveryDelay;
    @Injection(name="JMS_CORRELATION_ID")
    private String jmsCorrelationId;
    @Injection(name="JMS_TYPE")
    private String jmsType;

    @VisibleForTesting
    public JmsProducerMeta() {
        this(new JmsDelegate(Collections.singletonList(new ActiveMQProvider())));
    }

    public JmsProducerMeta(JmsDelegate jmsDelegate) {
        this.jmsDelegate = jmsDelegate;
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.step.jms.ui.JmsProducerDialog";
    }

    public void setDefault() {
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new JmsProducer(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new GenericStepData();
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        super.check(remarks, transMeta, stepMeta, prev, input, output, info, space, repository, metaStore);
        StepOption.checkBoolean(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"JmsDialog.Options.DISABLE_MESSAGE_ID", (String[])new String[0]), (String)this.disableMessageId);
        StepOption.checkBoolean(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"JmsDialog.Options.DISABLE_MESSAGE_TIMESTAMP", (String[])new String[0]), (String)this.disableMessageTimestamp);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"JmsDialog.Options.DELIVERY_MODE", (String[])new String[0]), (String)this.deliveryMode);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"JmsDialog.Options.PRIORITY", (String[])new String[0]), (String)this.priority);
        StepOption.checkLong(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"JmsDialog.Options.TIME_TO_LIVE", (String[])new String[0]), (String)this.timeToLive);
        StepOption.checkLong(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"JmsDialog.Options.DELIVERY_DELAY", (String[])new String[0]), (String)this.deliveryDelay);
    }

    public String getFieldToSend() {
        return this.fieldToSend;
    }

    public void setFieldToSend(String fieldToSend) {
        this.fieldToSend = fieldToSend;
    }

    public void setPropertyValuesByName(Map<String, String> propertyValuesByName) {
        this.propertyNames = new ArrayList<String>(propertyValuesByName.keySet());
        this.propertyValues = new ArrayList<String>(propertyValuesByName.values());
    }

    public Map<String, String> getPropertyValuesByName() {
        return ConfigHelper.conf(this.propertyNames, this.propertyValues).asMap();
    }

    public String getDisableMessageId() {
        return this.disableMessageId;
    }

    public void setDisableMessageId(String disableMessageId) {
        this.disableMessageId = disableMessageId;
    }

    public String getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(String disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(String timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void setDeliveryDelay(String deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public String getJmsCorrelationId() {
        return this.jmsCorrelationId;
    }

    public void setJmsCorrelationId(String jmsCorrelationId) {
        this.jmsCorrelationId = jmsCorrelationId;
    }

    public String getJmsType() {
        return this.jmsType;
    }

    public void setJmsType(String jmsType) {
        this.jmsType = jmsType;
    }

    public List<StepOption> retriveOptions() {
        return Arrays.asList(new StepOption(DISABLE_MESSAGE_ID, BaseMessages.getString(PKG, (String)"JmsDialog.Options.DISABLE_MESSAGE_ID", (String[])new String[0]), this.disableMessageId), new StepOption(DISABLE_MESSAGE_TIMESTAMP, BaseMessages.getString(PKG, (String)"JmsDialog.Options.DISABLE_MESSAGE_TIMESTAMP", (String[])new String[0]), this.disableMessageTimestamp), new StepOption(DELIVERY_MODE, BaseMessages.getString(PKG, (String)"JmsDialog.Options.DELIVERY_MODE", (String[])new String[0]), this.deliveryMode), new StepOption(PRIORITY, BaseMessages.getString(PKG, (String)"JmsDialog.Options.PRIORITY", (String[])new String[0]), this.priority), new StepOption(TIME_TO_LIVE, BaseMessages.getString(PKG, (String)"JmsDialog.Options.TIME_TO_LIVE", (String[])new String[0]), this.timeToLive), new StepOption(DELIVERY_DELAY, BaseMessages.getString(PKG, (String)"JmsDialog.Options.DELIVERY_DELAY", (String[])new String[0]), this.deliveryDelay), new StepOption(JMS_CORRELATION_ID, BaseMessages.getString(PKG, (String)"JmsDialog.Options.JMS_CORRELATION_ID", (String[])new String[0]), this.jmsCorrelationId), new StepOption(JMS_TYPE, BaseMessages.getString(PKG, (String)"JmsDialog.Options.JMS_TYPE", (String[])new String[0]), this.jmsType));
    }
}

