/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.context;

import com.google.common.base.Preconditions;
import javax.jms.Destination;
import javax.jms.JMSContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class ActiveMQProvider
implements JmsProvider {
    @Override
    public boolean supports(JmsProvider.ConnectionType type) {
        return type == JmsProvider.ConnectionType.ACTIVEMQ;
    }

    @Override
    public JMSContext getContext(JmsDelegate delegate, VariableSpace variableSpace) {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(variableSpace.environmentSubstitute(delegate.amqUrl).trim());
        return factory.createContext(variableSpace.environmentSubstitute(delegate.amqUsername), variableSpace.environmentSubstitute(delegate.amqPassword));
    }

    @Override
    public Destination getDestination(JmsDelegate delegate, VariableSpace variableSpace) {
        Preconditions.checkNotNull((Object)delegate.destinationName, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsWebsphereMQ.DestinationNameRequired", (String[])new String[0]));
        String destName = variableSpace.environmentSubstitute(delegate.destinationName);
        return this.isQueue(delegate, variableSpace) ? new ActiveMQQueue(destName) : new ActiveMQTopic(destName);
    }
}

