/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.context;

import javax.jms.Destination;
import javax.jms.JMSContext;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;

public interface JmsProvider {
    public boolean supports(ConnectionType var1);

    public JMSContext getContext(JmsDelegate var1, VariableSpace var2);

    public Destination getDestination(JmsDelegate var1, VariableSpace var2);

    default public boolean isQueue(JmsDelegate meta, VariableSpace variableSpace) {
        return DestinationType.valueOf(variableSpace.environmentSubstitute(meta.destinationType)).equals((Object)DestinationType.QUEUE);
    }

    public static enum DestinationType {
        QUEUE,
        TOPIC;

    }

    public static enum ConnectionType {
        ACTIVEMQ{

            public String toString() {
                return BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProvider.ActiveMQ", (String[])new String[0]);
            }

            @Override
            public String getUrlHint() {
                return BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProvider.ActiveMQUrlHint", (String[])new String[0]);
            }
        }
        ,
        WEBSPHERE{

            public String toString() {
                return BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProvider.IBMMQ", (String[])new String[0]);
            }

            @Override
            public String getUrlHint() {
                return BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsProvider.WSUrlHint", (String[])new String[0]);
            }
        };


        public abstract String getUrlHint();
    }
}

