/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.context;

import com.google.common.base.Preconditions;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class WebsphereMQProvider
implements JmsProvider {
    @Override
    public boolean supports(JmsProvider.ConnectionType type) {
        return type == JmsProvider.ConnectionType.WEBSPHERE;
    }

    @Override
    public JMSContext getContext(JmsDelegate meta, VariableSpace variableSpace) {
        MQUrlResolver resolver = new MQUrlResolver(meta, variableSpace);
        MQQueueConnectionFactory connFactory = this.isQueue(meta, variableSpace) ? new MQQueueConnectionFactory() : new MQTopicConnectionFactory();
        connFactory.setHostName(resolver.host);
        try {
            connFactory.setPort(resolver.port);
            connFactory.setQueueManager(resolver.queueManager);
            connFactory.setChannel(resolver.channel);
            connFactory.setTransportType(1);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        return connFactory.createContext(variableSpace.environmentSubstitute(meta.ibmUsername), variableSpace.environmentSubstitute(meta.ibmPassword));
    }

    @Override
    public Destination getDestination(JmsDelegate meta, VariableSpace variableSpace) {
        Preconditions.checkNotNull((Object)meta.destinationName, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsWebsphereMQ.DestinationNameRequired", (String[])new String[0]));
        try {
            String destName = variableSpace.environmentSubstitute(meta.destinationName);
            return this.isQueue(meta, variableSpace) ? new MQQueue(destName) : new MQTopic(destName);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    static class MQUrlResolver {
        private final JmsDelegate meta;
        private final Pattern pattern = Pattern.compile("mq://([\\p{Alnum}\\x2D\\x2E]*)(:(\\p{Digit}*))?/([\\p{Alnum}\\x2E]*)(\\x3F(channel=([^\\s=\\x26]*)))?");
        private String host = null;
        private String queueManager = "default";
        private int port = 1414;
        private String channel = "SYSTEM.DEF.SVRCONN";

        MQUrlResolver(JmsDelegate meta, VariableSpace space) {
            this.meta = meta;
            this.resolve(space);
        }

        void resolve(VariableSpace space) {
            Matcher matcher = this.pattern.matcher(space.environmentSubstitute(this.meta.ibmUrl).trim());
            if (matcher.matches()) {
                this.host = matcher.group(1);
                this.queueManager = matcher.group(4);
                String value = matcher.group(3);
                if (value != null) {
                    this.port = Integer.parseInt(value);
                }
                if ((value = matcher.group(7)) != null) {
                    this.channel = value;
                }
            }
        }
    }
}

