/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.ui;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class ConnectionForm {
    private final Composite parentComponent;
    private final JmsDelegate jmsDelegate;
    private final JmsProvider.ConnectionType currentConnType;
    private PropsUI props;
    private TransMeta transMeta;
    private ModifyListener lsMod;
    private Map<JmsProvider.ConnectionType, Button> typesToButtons = new HashMap<JmsProvider.ConnectionType, Button>();
    private Group wConnectionGroup;
    private Label wlIbmUrl;
    private Label wlIbmUser;
    private Label wlIbmPassword;
    private TextVar wIbmUrl;
    private TextVar wIbmUser;
    private TextVar wIbmPassword;
    private Label wlActiveUrl;
    private Label wlActiveUser;
    private Label wlActivePassword;
    private TextVar wActiveUrl;
    private TextVar wActiveUser;
    private TextVar wActivePassword;

    ConnectionForm(Composite parentComponent, PropsUI props, TransMeta transMeta, ModifyListener lsMod, JmsDelegate jmsDelegate) {
        Preconditions.checkNotNull((Object)parentComponent);
        Preconditions.checkNotNull((Object)props);
        Preconditions.checkNotNull((Object)transMeta);
        Preconditions.checkNotNull((Object)lsMod);
        this.parentComponent = parentComponent;
        this.props = props;
        this.transMeta = transMeta;
        this.lsMod = lsMod;
        this.jmsDelegate = jmsDelegate;
        this.currentConnType = JmsProvider.ConnectionType.valueOf(jmsDelegate.connectionType);
    }

    Group layoutForm() {
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        this.parentComponent.setLayout((Layout)setupLayout);
        this.wConnectionGroup = new Group(this.parentComponent, 16);
        this.wConnectionGroup.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Connection", (String[])new String[0]));
        FormLayout flConnection = new FormLayout();
        flConnection.marginHeight = 15;
        flConnection.marginWidth = 15;
        this.wConnectionGroup.setLayout((Layout)flConnection);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, 0);
        fdConnectionGroup.top = new FormAttachment(0, 0);
        fdConnectionGroup.right = new FormAttachment(100, 0);
        fdConnectionGroup.width = 350;
        this.wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        this.props.setLook((Control)this.wConnectionGroup);
        this.displayConnTypes(this.wConnectionGroup);
        this.setStartingsVals();
        return this.wConnectionGroup;
    }

    private void setStartingsVals() {
        this.wIbmUrl.setText(this.jmsDelegate.ibmUrl);
        this.wIbmUser.setText(this.jmsDelegate.ibmUsername);
        this.wIbmPassword.setText(this.jmsDelegate.ibmPassword);
        this.wActiveUrl.setText(this.jmsDelegate.amqUrl);
        this.wActiveUser.setText(this.jmsDelegate.amqUsername);
        this.wActivePassword.setText(this.jmsDelegate.amqPassword);
        JmsProvider.ConnectionType connectionType = JmsProvider.ConnectionType.valueOf(this.jmsDelegate.connectionType);
        this.typesToButtons.get((Object)connectionType).setSelection(true);
        this.toggleVisibility(connectionType);
    }

    private void displayConnTypes(Group wConnectionGroup) {
        Button previous = null;
        Button widestWidget = null;
        for (final JmsProvider.ConnectionType type : JmsProvider.ConnectionType.values()) {
            Button connectionButton = new Button((Composite)wConnectionGroup, 16);
            connectionButton.setText(type.toString());
            this.typesToButtons.put(type, connectionButton);
            FormData fdbConnType = new FormData();
            fdbConnType.left = new FormAttachment(0, 0);
            fdbConnType.top = previous == null ? new FormAttachment(0, 0) : new FormAttachment(previous, 10);
            previous = connectionButton;
            connectionButton.setLayoutData((Object)fdbConnType);
            connectionButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConnectionForm.this.lsMod.modifyText(null);
                    ConnectionForm.this.toggleVisibility(type);
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ConnectionForm.this.toggleVisibility(type);
                }
            });
            this.props.setLook((Control)connectionButton);
            if (null != widestWidget && previous.getSize().y <= widestWidget.getSize().y) continue;
            widestWidget = previous;
        }
        Label environmentSeparator = new Label((Composite)wConnectionGroup, 514);
        FormData fdenvironmentSeparator = new FormData();
        fdenvironmentSeparator.top = new FormAttachment(0, 0);
        fdenvironmentSeparator.left = new FormAttachment(widestWidget, 15);
        fdenvironmentSeparator.bottom = new FormAttachment(100, 0);
        environmentSeparator.setLayoutData((Object)fdenvironmentSeparator);
        this.layoutIbmMqConnectionFields((Control)environmentSeparator);
        this.layoutActiveMqConnectionFields((Control)environmentSeparator);
    }

    private void layoutIbmMqConnectionFields(Control leftOf) {
        this.wlIbmUrl = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlIbmUrl);
        this.wlIbmUrl.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUrl", (String[])new String[0]));
        FormData fdlJmsUrl = new FormData();
        fdlJmsUrl.left = new FormAttachment(leftOf, 15);
        fdlJmsUrl.top = new FormAttachment(0, 0);
        this.wlIbmUrl.setLayoutData((Object)fdlJmsUrl);
        this.wIbmUrl = new TextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.wIbmUrl.setToolTipText(JmsProvider.ConnectionType.WEBSPHERE.getUrlHint());
        this.props.setLook((Control)this.wIbmUrl);
        this.wIbmUrl.addModifyListener(this.lsMod);
        FormData fdUrl = new FormData();
        fdUrl.left = new FormAttachment(leftOf, 15);
        fdUrl.top = new FormAttachment((Control)this.wlIbmUrl, 5);
        fdUrl.right = new FormAttachment(100, 0);
        this.wIbmUrl.setLayoutData((Object)fdUrl);
        this.wlIbmUser = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlIbmUser);
        this.wlIbmUser.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUser", (String[])new String[0]));
        FormData fdlUser = new FormData();
        fdlUser.left = new FormAttachment(leftOf, 15);
        fdlUser.top = new FormAttachment((Control)this.wIbmUrl, 10);
        this.wlIbmUser.setLayoutData((Object)fdlUser);
        this.wIbmUser = new TextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.props.setLook((Control)this.wIbmUser);
        this.wIbmUser.addModifyListener(this.lsMod);
        FormData fdUser = new FormData();
        fdUser.left = new FormAttachment(leftOf, 15);
        fdUser.top = new FormAttachment((Control)this.wlIbmUser, 5);
        fdUser.right = new FormAttachment(100, 0);
        this.wIbmUser.setLayoutData((Object)fdUser);
        this.wlIbmPassword = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlIbmPassword);
        this.wlIbmPassword.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsPassword", (String[])new String[0]));
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(leftOf, 15);
        fdlPassword.top = new FormAttachment((Control)this.wIbmUser, 10);
        this.wlIbmPassword.setLayoutData((Object)fdlPassword);
        this.wIbmPassword = new PasswordTextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.props.setLook((Control)this.wIbmPassword);
        this.wIbmPassword.addModifyListener(this.lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(leftOf, 15);
        fdPassword.top = new FormAttachment((Control)this.wlIbmPassword, 5);
        fdPassword.right = new FormAttachment(100, 0);
        this.wIbmPassword.setLayoutData((Object)fdPassword);
    }

    private void layoutActiveMqConnectionFields(Control leftOf) {
        this.wlActiveUrl = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlActiveUrl);
        this.wlActiveUrl.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUrl", (String[])new String[0]));
        FormData fdlJmsUrl = new FormData();
        fdlJmsUrl.left = new FormAttachment(leftOf, 15);
        fdlJmsUrl.top = new FormAttachment(0, 0);
        this.wlActiveUrl.setLayoutData((Object)fdlJmsUrl);
        this.wActiveUrl = new TextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.wActiveUrl.setToolTipText(JmsProvider.ConnectionType.ACTIVEMQ.getUrlHint());
        this.props.setLook((Control)this.wActiveUrl);
        this.wActiveUrl.addModifyListener(this.lsMod);
        FormData fdJmsUrl = new FormData();
        fdJmsUrl.left = new FormAttachment(leftOf, 15);
        fdJmsUrl.top = new FormAttachment((Control)this.wlActiveUrl, 5);
        fdJmsUrl.right = new FormAttachment(100, 0);
        this.wActiveUrl.setLayoutData((Object)fdJmsUrl);
        this.wlActiveUser = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlActiveUser);
        this.wlActiveUser.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUser", (String[])new String[0]));
        FormData fdlUser = new FormData();
        fdlUser.left = new FormAttachment(leftOf, 15);
        fdlUser.top = new FormAttachment((Control)this.wActiveUrl, 10);
        this.wlActiveUser.setLayoutData((Object)fdlUser);
        this.wActiveUser = new TextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.props.setLook((Control)this.wActiveUser);
        this.wActiveUser.addModifyListener(this.lsMod);
        FormData fdUser = new FormData();
        fdUser.left = new FormAttachment(leftOf, 15);
        fdUser.top = new FormAttachment((Control)this.wlActiveUser, 5);
        fdUser.right = new FormAttachment(100, 0);
        this.wActiveUser.setLayoutData((Object)fdUser);
        this.wlActivePassword = new Label((Composite)this.wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlActivePassword);
        this.wlActivePassword.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsPassword", (String[])new String[0]));
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(leftOf, 15);
        fdlPassword.top = new FormAttachment((Control)this.wActiveUser, 10);
        this.wlActivePassword.setLayoutData((Object)fdlPassword);
        this.wActivePassword = new PasswordTextVar((VariableSpace)this.transMeta, (Composite)this.wConnectionGroup, 18436);
        this.props.setLook((Control)this.wActivePassword);
        this.wActivePassword.addModifyListener(this.lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(leftOf, 15);
        fdPassword.top = new FormAttachment((Control)this.wlActivePassword, 5);
        fdPassword.right = new FormAttachment(100, 0);
        this.wActivePassword.setLayoutData((Object)fdPassword);
    }

    public String getIbmUrl() {
        return this.wIbmUrl.getText();
    }

    public String getIbmUser() {
        return this.wIbmUser.getText();
    }

    public String getIbmPassword() {
        return this.wIbmPassword.getText();
    }

    public String getActiveUrl() {
        return this.wActiveUrl.getText();
    }

    public String getActiveUser() {
        return this.wActiveUser.getText();
    }

    public String getActivePassword() {
        return this.wActivePassword.getText();
    }

    public String getConnectionType() {
        return ((JmsProvider.ConnectionType)((Object)this.typesToButtons.entrySet().stream().filter(entry -> ((Button)entry.getValue()).getSelection()).findFirst().orElseThrow(() -> new IllegalStateException("One type should be selected")).getKey())).name();
    }

    private void toggleVisibility(JmsProvider.ConnectionType type) {
        switch (type) {
            case WEBSPHERE: {
                this.setActiveMqVisibility(false);
                this.setIbmMqVisibility(true);
                break;
            }
            case ACTIVEMQ: {
                this.setIbmMqVisibility(false);
                this.setActiveMqVisibility(true);
            }
        }
    }

    private void setIbmMqVisibility(boolean isVisible) {
        this.wlIbmUrl.setVisible(isVisible);
        this.wlIbmUser.setVisible(isVisible);
        this.wlIbmPassword.setVisible(isVisible);
        this.wIbmUrl.setVisible(isVisible);
        this.wIbmUser.setVisible(isVisible);
        this.wIbmPassword.setVisible(isVisible);
    }

    private void setActiveMqVisibility(boolean isVisible) {
        this.wlActiveUrl.setVisible(isVisible);
        this.wlActiveUser.setVisible(isVisible);
        this.wlActivePassword.setVisible(isVisible);
        this.wActiveUrl.setVisible(isVisible);
        this.wActiveUser.setVisible(isVisible);
        this.wActivePassword.setVisible(isVisible);
    }
}

