/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;

public class POCollectedGroup
extends PhysicalOperator {
    private static final List<PhysicalPlan> EMPTY_PLAN_LIST = new ArrayList<PhysicalPlan>();
    protected static final long serialVersionUID = 1L;
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    protected List<PhysicalPlan> plans;
    protected List<ExpressionOperator> leafOps = new ArrayList<ExpressionOperator>();
    protected byte keyType;
    private final Tuple output = mTupleFactory.newTuple(2);
    private DataBag outputBag = null;
    private Object prevKey = null;
    private transient boolean useDefaultBag;

    public POCollectedGroup(OperatorKey k) {
        this(k, -1, null);
    }

    public POCollectedGroup(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POCollectedGroup(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POCollectedGroup(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitCollectedGroup(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Map side group " + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void attachInput(Tuple t) {
        super.attachInput(t);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result inp;
        block9: {
            Object curKey;
            Tuple tup;
            inp = null;
            Result res = null;
            while (true) {
                inp = this.processInput();
                if (inp.returnStatus == 3) {
                    if (this.parentPlan.endOfAllInput) {
                        return this.getStreamCloseResult();
                    }
                    break block9;
                }
                if (inp.returnStatus == 2) break block9;
                if (inp.returnStatus == 1) continue;
                for (PhysicalPlan ep : this.plans) {
                    ep.attachInput((Tuple)inp.result);
                }
                ArrayList<Result> resLst = new ArrayList<Result>();
                for (ExpressionOperator op : this.leafOps) {
                    res = op.getNext(op.getResultType());
                    if (res.returnStatus != 0) {
                        return new Result();
                    }
                    resLst.add(res);
                }
                tup = this.constructOutput(resLst, (Tuple)inp.result);
                curKey = tup.get(0);
                if (this.prevKey == null && this.outputBag == null) {
                    String bagType;
                    if (PigMapReduce.sJobConfInternal.get() != null && (bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.type")) != null && bagType.equalsIgnoreCase("default")) {
                        this.useDefaultBag = true;
                    }
                    this.prevKey = curKey;
                    this.outputBag = this.useDefaultBag ? BagFactory.getInstance().newDefaultBag() : new InternalCachedBag(1);
                    this.outputBag.add((Tuple)tup.get(1));
                    continue;
                }
                if (this.prevKey == null && curKey == null) {
                    this.outputBag.add((Tuple)tup.get(1));
                    continue;
                }
                if (this.prevKey == null || curKey == null || ((Comparable)curKey).compareTo(this.prevKey) != 0) break;
                this.outputBag.add((Tuple)tup.get(1));
            }
            Tuple tup2 = mTupleFactory.newTuple(2);
            tup2.set(0, this.prevKey);
            tup2.set(1, this.outputBag);
            res.result = tup2;
            this.prevKey = curKey;
            this.outputBag = this.useDefaultBag ? BagFactory.getInstance().newDefaultBag() : new InternalCachedBag(1);
            this.outputBag.add((Tuple)tup.get(1));
            return res;
        }
        return inp;
    }

    protected Tuple constructOutput(List<Result> resLst, Tuple value) throws ExecException {
        Object key;
        if (resLst.size() > 1) {
            Tuple t = mTupleFactory.newTuple(resLst.size());
            int i = -1;
            for (Result res : resLst) {
                t.set(++i, res.result);
            }
            key = t;
        } else {
            key = resLst.get((int)0).result;
        }
        this.output.set(0, key);
        this.output.set(1, value);
        return this.output;
    }

    public byte getKeyType() {
        return this.keyType;
    }

    public void setKeyType(byte keyType) {
        this.keyType = keyType;
    }

    public List<PhysicalPlan> getPlans() {
        return this.plans == null ? EMPTY_PLAN_LIST : this.plans;
    }

    public void setPlans(List<PhysicalPlan> plans) throws PlanException {
        this.plans = plans;
        this.leafOps.clear();
        for (PhysicalPlan plan : plans) {
            ExpressionOperator leaf = (ExpressionOperator)plan.getLeaves().get(0);
            this.leafOps.add(leaf);
        }
    }

    private void setIllustratorEquivalenceClasses(Tuple tin) {
        if (this.illustrator != null) {
            this.illustrator.getEquivalenceClasses().get(0).add(tin);
        }
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    private Result getStreamCloseResult() throws ExecException {
        if (this.outputBag != null) {
            Tuple tup = mTupleFactory.newTuple(2);
            tup.set(0, this.prevKey);
            tup.set(1, this.outputBag);
            this.outputBag = null;
            return new Result(0, tup);
        }
        return new Result(3, null);
    }
}

