/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.api;

import java.util.ArrayList;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public enum SparkDataType {
    BINARY_TYPE(DataTypes.BinaryType),
    BOOLEAN_TYPE(DataTypes.BooleanType),
    BYTE_TYPE(DataTypes.ByteType),
    DATE_TYPE(DataTypes.DateType),
    DECIMAL_TYPE((DataType)DataTypes.createDecimalType((int)18, (int)4)),
    DOUBLE_TYPE(DataTypes.DoubleType),
    FLOAT_TYPE(DataTypes.FloatType),
    INTEGER_TYPE(DataTypes.IntegerType),
    LONG_TYPE(DataTypes.LongType),
    NULL_TYPE(DataTypes.NullType),
    SHORT_TYPE(DataTypes.ShortType),
    STRING_TYPE(DataTypes.StringType),
    TIMESTAMP_TYPE(DataTypes.TimestampType);

    private final DataType dataType;
    public static final SparkDataType[] values;
    private static final ArrayList<SparkDataType> enumValues;

    private SparkDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static DataType getDataType(int typeValue) {
        return enumValues.get(typeValue).getDataType();
    }

    static {
        values = SparkDataType.values();
        enumValues = new ArrayList<SparkDataType>(){
            {
                for (SparkDataType dataType : SparkDataType.values()) {
                    this.add(dataType.ordinal(), dataType);
                }
            }
        };
    }
}

