/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.annotations.EnginePlugin;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.spark.api.SparkOperationResolver;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;

@EnginePlugin(id="spark", name="Spark Engine")
public class SparkEngine
implements Engine {
    private final ExecutorService executorService;
    private final SparkOperationResolver resolver;
    private JavaSparkContext javaSparkContext;

    public SparkEngine(ExecutorService executorService, SparkOperationResolver operationResolver) {
        this.executorService = executorService;
        this.resolver = operationResolver;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ExecutionContext prepare(Transformation trans) {
        this.javaSparkContext = new JavaSparkContext(SparkContext.getOrCreate());
        return new SparkEngineContext(this, trans, this.javaSparkContext, this.resolver);
    }

    public String getId() {
        return SparkEngine.class.getAnnotation(EnginePlugin.class).id();
    }

    public void shutdown() {
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            if (this.javaSparkContext != null) {
                this.javaSparkContext.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class Result
    implements ExecutionResult {
        private static final long serialVersionUID = 6008932223982487127L;
        private final Map<Operation, Metrics> report;

        Result(Map<Operation, Metrics> report) {
            this.report = report;
        }

        public Map<Operation, Metrics> getDataEventReport() {
            return this.report;
        }
    }
}

