/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.util.AccumulatorV2;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.events.SubTransCreationEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.api.reporting.SubTransCreation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperationResolver;
import org.pentaho.di.engine.spark.impl.SparkEngine;
import org.pentaho.di.engine.spark.impl.accumulators.LogEntryAccumulator;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;
import org.pentaho.di.engine.spark.impl.execution.ExecutionPlan;
import org.pentaho.di.engine.spark.impl.execution.JobGroupDriverTask;
import org.pentaho.di.engine.spark.impl.execution.TaskObservable;
import org.pentaho.di.engine.spark.impl.listeners.LoggingAccumSparkListener;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.listeners.SparkTaskMetricsListener;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.reactivestreams.Publisher;

public class SparkEngineContext
implements ExecutionContext {
    private static Class<?> PKG = SparkEngineContext.class;
    private static LogChannelInterface logChannel = KettleLogStore.getLogChannelInterfaceFactory().create(SparkEngineContext.class);
    public static final int REPLAY_BUFFER_MAX_AGE = 30;
    public static final int REPLAY_BUFFER_MAX_SIZE = 1000;
    public static final String TRANS_LOGGING_ACCUM = "trans_logging";
    public static final String OP_LOGGING_ACCUM = "op_logging";
    public static final String SEP = "-";
    public static final String STOPPING_TRANSF_JOBGROUPID = "SparkEngineContext.StoppingJobGroupId";
    public static final String RUNNING_TRANSFORMATION = "SparkEngineContext.RunningTransformation";
    public static final String RUNNING_NXT_DRV_TASK = "SparkEngineContext.RunningNextDriverTask";
    public static final String TRANSFORMATION_FINISHED = "SparkEngineContext.TransformationFinished";
    public static final String OPERATION_NOT_FOUND = "SparkEngineContext.OperationNotFound";
    public static final String COMPILING_TRANSFORMATION = "SparkEngineContext.CompilingTransformation";
    public static final String SUBTRANSFORMATIONS = "SubTransformations";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final SparkEngine engine;
    private final Transformation transformation;
    private final JavaSparkContext sparkContext;
    private final SparkOperationResolver resolver;
    private final LogEntryAccumulator transLoggingAccumulator;
    private Principal actingPrincipal;
    private org.pentaho.di.engine.api.reporting.LogLevel loggingLogLevel;
    private Single<ExecutionPlan> executionPlanSingle;
    private ReplaySubject<LogEntry> loggingSubject;
    private AtomicBoolean listenerRegistered = new AtomicBoolean(false);
    private JavaRDD<Row> initialRDD;
    private JavaRDD<Row> finalRDD;
    private List<String> resultFiles;
    final Map<String, MetricsAccumulator> metricsAccumulators;
    private final String jobGroupId;
    private final String jobGroupDescription;
    private LoggingToAccumAdapter loggingToAccumAdapter;
    private List<JavaStreamingContext> childStreamingContexts = new CopyOnWriteArrayList<JavaStreamingContext>();

    public SparkEngineContext(SparkEngine engine, Transformation trans, JavaSparkContext sparkContext, SparkOperationResolver resolver) {
        this(engine, trans, sparkContext, resolver, Maps.newConcurrentMap());
    }

    public SparkEngineContext(SparkEngine engine, Transformation trans, JavaSparkContext sparkContext, SparkOperationResolver resolver, Map<String, MetricsAccumulator> metricsAccumulators) {
        this.engine = Objects.requireNonNull(engine);
        this.transformation = Objects.requireNonNull(trans);
        this.sparkContext = Objects.requireNonNull(sparkContext);
        this.resolver = Objects.requireNonNull(resolver);
        this.loggingToAccumAdapter = new LoggingToAccumAdapter();
        KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)this.loggingToAccumAdapter);
        this.loggingSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
        this.transLoggingAccumulator = LogEntryAccumulator.getTransformationLogging(sparkContext, this.loggingSubject, this.loggingToAccumAdapter);
        this.executionPlanSingle = Single.fromCallable(this::createExecutionPlan).cache();
        this.metricsAccumulators = metricsAccumulators;
        this.jobGroupDescription = this.transformation.getConfig() != null ? (String)this.transformation.getConfig().get("TransMetaName") : this.transformation.getId();
        this.jobGroupId = this.jobGroupDescription != null ? this.jobGroupDescription + SEP + UUID.randomUUID().toString() : UUID.randomUUID().toString();
        this.resultFiles = new ArrayList<String>();
    }

    public Map<String, Object> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    public Map<String, Object> getEnvironment() {
        return ImmutableMap.copyOf(this.environment);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    public void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void setEnvironment(String key, Object value) {
        this.environment.put(key, value);
    }

    public void setLoggingLogLevel(org.pentaho.di.engine.api.reporting.LogLevel logLevel) {
        DefaultLogLevel.setLogLevel((LogLevel)Util.mapKettleLogLevel(logLevel));
        logChannel.setLogLevel(DefaultLogLevel.getLogLevel());
        this.loggingLogLevel = logLevel;
    }

    public org.pentaho.di.engine.api.reporting.LogLevel getLoggingLogLevel() {
        return this.loggingLogLevel;
    }

    public void stopTransformation() {
        logChannel.logDetailed(BaseMessages.getString(PKG, (String)STOPPING_TRANSF_JOBGROUPID, (String[])new String[]{this.jobGroupId}));
        this.sparkContext.cancelJobGroup(this.jobGroupId);
        this.childStreamingContexts.forEach(stream -> {
            logChannel.logDebug("Stopping streaming context.");
            stream.stop(false, true);
        });
    }

    public void registerStreamingContext(JavaStreamingContext streamingContext) {
        this.childStreamingContexts.add(streamingContext);
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public CompletableFuture<ExecutionResult> execute() {
        logChannel.logDebug(BaseMessages.getString(PKG, (String)RUNNING_TRANSFORMATION, (String[])new String[0]));
        if (this.loggingLogLevel == org.pentaho.di.engine.api.reporting.LogLevel.DEBUG || this.loggingLogLevel == org.pentaho.di.engine.api.reporting.LogLevel.TRACE) {
            this.sparkContext.sc().addSparkListener((SparkListenerInterface)new SparkTaskMetricsListener(this.transLoggingAccumulator.getAccumulator()));
        }
        ExecutionPlan executionPlan = this.getExecutionPlan();
        ImmutableMap.Builder reportBuilder = ImmutableMap.builder();
        for (TaskObservable taskObservable : executionPlan.getMaterializedOperations().values()) {
            taskObservable.getSparkOperation().getLogicalOperation().ifPresent(operation -> {
                CompletableFuture future = (CompletableFuture)taskObservable.getMetrics().lastOrError().to(Util::completableFuture);
                reportBuilder.put(operation, (Object)future);
            });
        }
        final CompletableFuture report = Util.invertMap(reportBuilder.build());
        ConnectableObservable<DriverTask> driverTasks = executionPlan.getDriverTasks();
        driverTasks.subscribe((Observer)new DisposableObserver<DriverTask>(){

            public void onNext(DriverTask driverTask) {
                SparkEngineContext.this.engine.getExecutorService().execute(JobGroupDriverTask.create(SparkEngineContext.this.sparkContext, SparkEngineContext.this.jobGroupId, SparkEngineContext.this.jobGroupDescription, false, driverTask));
                if (logChannel.isDebug()) {
                    logChannel.logDebug(BaseMessages.getString((Class)PKG, (String)SparkEngineContext.RUNNING_NXT_DRV_TASK, (String[])new String[]{driverTask.getSparkOperation().getId()}));
                }
            }

            public void onError(Throwable e) {
                KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)SparkEngineContext.this.loggingToAccumAdapter);
                report.completeExceptionally(e);
            }

            public void onComplete() {
                if (logChannel.isDebug()) {
                    logChannel.logDebug(BaseMessages.getString((Class)PKG, (String)SparkEngineContext.TRANSFORMATION_FINISHED, (String[])new String[0]));
                }
                KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)SparkEngineContext.this.loggingToAccumAdapter);
            }
        });
        driverTasks.connect();
        return report.thenApply(SparkEngine.Result::new);
    }

    private SparkOperation compile(Operation operation, StepMeta stepMeta) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(stepMeta);
        try {
            return this.resolver.resolve(operation, this.transformation, stepMeta, this.sparkContext, this);
        }
        catch (KettlePluginException e) {
            throw new IllegalStateException(e);
        }
    }

    public Principal getActingPrincipal() {
        return this.actingPrincipal;
    }

    public void setActingPrincipal(Principal actingPrincipal) {
        this.actingPrincipal = actingPrincipal;
    }

    public <S extends LogicalModelElement, D extends Serializable> Publisher<PDIEvent<S, D>> eventStream(S source, Class<D> type) {
        ExecutionPlan executionPlan = this.getExecutionPlan();
        if (source instanceof Transformation) {
            if (Status.class == type) {
                return executionPlan.getStatus().map(status -> new StatusEvent((LogicalModelElement)this.transformation, status)).toFlowable(BackpressureStrategy.BUFFER);
            }
            if (type == LogEntry.class) {
                if (this.loggingSubject == null) {
                    this.loggingSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
                }
                if (!this.listenerRegistered.getAndSet(true)) {
                    this.sparkContext.sc().addSparkListener((SparkListenerInterface)new LoggingAccumSparkListener(this.transLoggingAccumulator));
                }
                return this.loggingSubject.map(logEntry -> new LogEvent((LogicalModelElement)((Transformation)source), logEntry)).toFlowable(BackpressureStrategy.BUFFER);
            }
        }
        if (source instanceof Operation) {
            TaskObservable taskObservable = (TaskObservable)executionPlan.getMaterializedOperations().get((Object)source.getId());
            Optional operation = Optional.ofNullable(taskObservable).map(TaskObservable::getSparkOperation).flatMap(SparkOperation::getLogicalOperation);
            if (!operation.isPresent()) {
                String message = BaseMessages.getString(PKG, (String)OPERATION_NOT_FOUND, (String[])new String[]{source.getId()});
                return Flowable.error((Throwable)new IllegalArgumentException(message));
            }
            if (type == Status.class) {
                return taskObservable.getStatus().map(status -> new StatusEvent((LogicalModelElement)operation.get(), status)).toFlowable(BackpressureStrategy.BUFFER);
            }
            if (type == Metrics.class) {
                return taskObservable.getMetrics().map(metrics -> new MetricsEvent((LogicalModelElement)operation.get(), metrics)).toFlowable(BackpressureStrategy.LATEST);
            }
            if (type == LogEntry.class) {
                return taskObservable.getLogging().map(logEntry -> new LogEvent((LogicalModelElement)operation.get(), logEntry)).toFlowable(BackpressureStrategy.BUFFER);
            }
            if (type == SubTransCreation.class) {
                return taskObservable.getSubTransCreation().map(subTransCreation -> new SubTransCreationEvent((LogicalModelElement)operation.get(), subTransCreation)).toFlowable(BackpressureStrategy.BUFFER);
            }
        }
        return Flowable.empty();
    }

    public Collection<LogicalModelElement> getReportingSources() {
        return ImmutableList.builder().add((Object)this.transformation).addAll((Iterable)this.transformation.getOperations()).build();
    }

    private ExecutionPlan getExecutionPlan() {
        return (ExecutionPlan)this.executionPlanSingle.blockingGet();
    }

    private ExecutionPlan createExecutionPlan() {
        logChannel.logDebug(BaseMessages.getString(PKG, (String)COMPILING_TRANSFORMATION, (String[])new String[0]));
        TransMeta transMeta = MetaHelper.getTransMeta(this.transformation);
        Maps.transformValues(this.environment, String::valueOf).forEach((arg_0, arg_1) -> ((TransMeta)transMeta).setVariable(arg_0, arg_1));
        ImmutableMap<String, StepMeta> stepMetas = transMeta.getSteps().stream().collect(Util.toImmutableMap(StepMeta::getName, stepMeta -> stepMeta));
        return new ExecutionPlan.Builder(this.sparkContext).add(this.transformation.getOperations(), operation -> this.compile((Operation)operation, (StepMeta)stepMetas.get((Object)operation.getId()))).addKettleLogListener(this.loggingToAccumAdapter).addAccumulator(TRANS_LOGGING_ACCUM, (AccumulatorV2<?, ?>)this.transLoggingAccumulator.getAccumulator()).metricAccumulators(this.metricsAccumulators).build(this.sparkContext);
    }

    public SparkEngine getEngine() {
        return this.engine;
    }

    SparkOperationResolver getResolver() {
        return this.resolver;
    }

    public Optional<JavaRDD<Row>> getInitialRdd() {
        return Optional.ofNullable(this.initialRDD);
    }

    public void setInitialRdd(JavaRDD<Row> initialRDD) {
        this.initialRDD = initialRDD;
    }

    public void setFinalRdd(JavaRDD<Row> finalRDD) {
        this.finalRDD = finalRDD;
    }

    public Optional<JavaRDD<Row>> getFinalRdd() {
        return Optional.ofNullable(this.finalRDD);
    }

    public void addResultFile(String resultFile) {
        this.resultFiles.add(resultFile);
    }

    public List<String> getResultFiles() {
        return this.resultFiles;
    }

    public SparkEngineContext createSubTransContext(String subTransPath) {
        HashMap subTransformations = (HashMap)this.transformation.getConfig(SUBTRANSFORMATIONS).get();
        Transformation subtrans = (Transformation)subTransformations.get(subTransPath);
        SparkEngineContext subTransContext = new SparkEngineContext(this.engine, subtrans, this.sparkContext, this.resolver, this.metricsAccumulators);
        subTransContext.setLoggingLogLevel(this.loggingLogLevel);
        subTransContext.setEnvironment(this.getEnvironment());
        return subTransContext;
    }

    public LoggingToAccumAdapter getLoggingToAccumAdapter() {
        return this.loggingToAccumAdapter;
    }
}

