/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.accumulators;

import io.reactivex.subjects.Subject;
import java.io.Serializable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.i18n.BaseMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEntryAccumulator
implements Serializable {
    private static final long serialVersionUID = 5176168312302301287L;
    private static final Class<?> PKG = LogEntryAccumulator.class;
    private static Logger logger = LoggerFactory.getLogger(LogEntryAccumulator.class);
    private static final String REGISTERING_LOG_ENTRY_ACCUMULATOR = "LogEntryAccumulator.RegisteringLogEntryAccumulator";
    private static final String LOGGING_ACCUMULATOR_HAS_VALUES = "LogEntryAccumulator.LoggingAccumulatorHasValues";
    private static final String LOGGING_ACCUMULATOR_RESET = "LogEntryAccumulator.LoggingAccumulatorReset";
    private final CollectionAccumulator<LogEntry> accumulator = new CollectionAccumulator();
    private final Subject<LogEntry> loggingSubject;
    private final String operationId;

    private LogEntryAccumulator(JavaSparkContext javaSparkContext, Subject<LogEntry> loggingSubject, String operationId, LoggingToAccumAdapter loggingToAccumAdapter) {
        this.loggingSubject = loggingSubject;
        this.operationId = operationId;
        javaSparkContext.sc().register(this.accumulator);
        logger.debug(BaseMessages.getString(PKG, (String)REGISTERING_LOG_ENTRY_ACCUMULATOR, (Object[])new Object[]{operationId, this.accumulator.id()}));
        loggingToAccumAdapter.addAccumulator(operationId, this.accumulator);
    }

    public static LogEntryAccumulator getTransformationLogging(JavaSparkContext javaSparkContext, Subject<LogEntry> loggingSubject, LoggingToAccumAdapter loggingToAccumAdapter) {
        return new LogEntryAccumulator(javaSparkContext, loggingSubject, "trans_logging", loggingToAccumAdapter);
    }

    public static LogEntryAccumulator getOperationLogging(JavaSparkContext javaSparkContext, Subject<LogEntry> loggingSubject, LoggingToAccumAdapter loggingToAccumAdapter, String operationId) {
        return new LogEntryAccumulator(javaSparkContext, loggingSubject, operationId, loggingToAccumAdapter);
    }

    public CollectionAccumulator<LogEntry> getAccumulator() {
        return this.accumulator;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void updateLogs() {
        LogEntryAccumulator.updateLogs(this.operationId, this.accumulator, this.loggingSubject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLogs(String operationId, CollectionAccumulator<LogEntry> accumulator, Subject<LogEntry> loggingSubject) {
        if (accumulator != null && accumulator.value().size() > 0) {
            logger.debug(BaseMessages.getString(PKG, (String)LOGGING_ACCUMULATOR_HAS_VALUES, (Object[])new Object[]{accumulator.value().size(), operationId}));
            CollectionAccumulator<LogEntry> collectionAccumulator = accumulator;
            synchronized (collectionAccumulator) {
                accumulator.value().forEach(arg_0 -> loggingSubject.onNext(arg_0));
                accumulator.reset();
                logger.debug(BaseMessages.getString(PKG, (String)LOGGING_ACCUMULATOR_RESET, (Object[])new Object[]{accumulator.value().size(), operationId}));
            }
        }
    }
}

